/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.misc.IntArray;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeNodeStream;

public class BufferedTreeNodeStream
implements TreeNodeStream {
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 100;
    public static final int INITIAL_CALL_STACK_SIZE = 10;
    protected Object down;
    protected Object up;
    protected Object eof;
    protected List nodes;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected boolean uniqueNavigationNodes = false;
    protected int p = -1;
    protected int lastMarker;
    protected IntArray calls;

    public BufferedTreeNodeStream(Object tree) {
        this(new CommonTreeAdaptor(), tree);
    }

    public BufferedTreeNodeStream(TreeAdaptor adaptor, Object tree) {
        this(adaptor, tree, 100);
    }

    public BufferedTreeNodeStream(TreeAdaptor adaptor, Object tree, int initialBufferSize) {
        this.root = tree;
        this.adaptor = adaptor;
        this.nodes = new ArrayList(initialBufferSize);
        this.down = adaptor.create(2, "DOWN");
        this.up = adaptor.create(3, "UP");
        this.eof = adaptor.create(-1, "EOF");
    }

    protected void fillBuffer() {
        this.fillBuffer(this.root);
        this.p = 0;
    }

    public void fillBuffer(Object t) {
        boolean nil = this.adaptor.isNil(t);
        if (!nil) {
            this.nodes.add(t);
        }
        int n = this.adaptor.getChildCount(t);
        if (!nil && n > 0) {
            this.addNavigationNode(2);
        }
        int c = 0;
        while (c < n) {
            Object child = this.adaptor.getChild(t, c);
            this.fillBuffer(child);
            ++c;
        }
        if (!nil && n > 0) {
            this.addNavigationNode(3);
        }
    }

    protected int getNodeIndex(Object node2) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        int i = 0;
        while (i < this.nodes.size()) {
            Object t = this.nodes.get(i);
            if (t == node2) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void addNavigationNode(int ttype) {
        Object navNode = null;
        navNode = ttype == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.nodes.add(navNode);
    }

    public Object get(int i) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.get(i);
    }

    public Object LT(int k) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            return this.LB(-k);
        }
        if (this.p + k - 1 >= this.nodes.size()) {
            return this.eof;
        }
        return this.nodes.get(this.p + k - 1);
    }

    public Object getCurrentSymbol() {
        return this.LT(1);
    }

    protected Object LB(int k) {
        if (k == 0) {
            return null;
        }
        if (this.p - k < 0) {
            return null;
        }
        return this.nodes.get(this.p - k);
    }

    public Object getTreeSource() {
        return this.root;
    }

    public String getSourceName() {
        return this.getTokenStream().getSourceName();
    }

    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokens) {
        this.tokens = tokens;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public void setTreeAdaptor(TreeAdaptor adaptor) {
        this.adaptor = adaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean uniqueNavigationNodes) {
        this.uniqueNavigationNodes = uniqueNavigationNodes;
    }

    public void consume() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        ++this.p;
    }

    public int LA(int i) {
        return this.adaptor.getType(this.LT(i));
    }

    public int mark() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.lastMarker = this.index();
        return this.lastMarker;
    }

    public void release(int marker) {
    }

    public int index() {
        return this.p;
    }

    public void rewind(int marker) {
        this.seek(marker);
    }

    public void rewind() {
        this.seek(this.lastMarker);
    }

    public void seek(int index) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        this.p = index;
    }

    public void push(int index) {
        if (this.calls == null) {
            this.calls = new IntArray();
        }
        this.calls.push(this.p);
        this.seek(index);
    }

    public int pop() {
        int ret = this.calls.pop();
        this.seek(ret);
        return ret;
    }

    public void reset() {
        this.p = 0;
        this.lastMarker = 0;
        if (this.calls != null) {
            this.calls.clear();
        }
    }

    public int size() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return this.nodes.size();
    }

    public Iterator iterator() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        return new StreamIterator();
    }

    public void replaceChildren(Object parent, int startChildIndex, int stopChildIndex, Object t) {
        if (parent != null) {
            this.adaptor.replaceChildren(parent, startChildIndex, stopChildIndex, t);
        }
    }

    public String toTokenTypeString() {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.nodes.size()) {
            Object t = this.nodes.get(i);
            buf.append(" ");
            buf.append(this.adaptor.getType(t));
            ++i;
        }
        return buf.toString();
    }

    public String toTokenString(int start2, int stop) {
        if (this.p == -1) {
            this.fillBuffer();
        }
        StringBuffer buf = new StringBuffer();
        int i = start2;
        while (i < this.nodes.size() && i <= stop) {
            Object t = this.nodes.get(i);
            buf.append(" ");
            buf.append(this.adaptor.getToken(t));
            ++i;
        }
        return buf.toString();
    }

    public String toString(Object start2, Object stop) {
        String text;
        System.out.println("toString");
        if (start2 == null || stop == null) {
            return null;
        }
        if (this.p == -1) {
            this.fillBuffer();
        }
        if (start2 instanceof CommonTree) {
            System.out.print("toString: " + ((CommonTree)start2).getToken() + ", ");
        } else {
            System.out.println(start2);
        }
        if (stop instanceof CommonTree) {
            System.out.println(((CommonTree)stop).getToken());
        } else {
            System.out.println(stop);
        }
        if (this.tokens != null) {
            int beginTokenIndex = this.adaptor.getTokenStartIndex(start2);
            int endTokenIndex = this.adaptor.getTokenStopIndex(stop);
            if (this.adaptor.getType(stop) == 3) {
                endTokenIndex = this.adaptor.getTokenStopIndex(start2);
            } else if (this.adaptor.getType(stop) == -1) {
                endTokenIndex = this.size() - 2;
            }
            return this.tokens.toString(beginTokenIndex, endTokenIndex);
        }
        Object t = null;
        int i = 0;
        while (i < this.nodes.size()) {
            t = this.nodes.get(i);
            if (t == start2) break;
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        t = this.nodes.get(i);
        while (t != stop) {
            text = this.adaptor.getText(t);
            if (text == null) {
                text = " " + String.valueOf(this.adaptor.getType(t));
            }
            buf.append(text);
            t = this.nodes.get(++i);
        }
        text = this.adaptor.getText(stop);
        if (text == null) {
            text = " " + String.valueOf(this.adaptor.getType(stop));
        }
        buf.append(text);
        return buf.toString();
    }

    protected class StreamIterator
    implements Iterator {
        int i = 0;

        protected StreamIterator() {
        }

        public boolean hasNext() {
            return this.i < BufferedTreeNodeStream.this.nodes.size();
        }

        public Object next() {
            int current;
            if ((current = this.i++) < BufferedTreeNodeStream.this.nodes.size()) {
                return BufferedTreeNodeStream.this.nodes.get(current);
            }
            return BufferedTreeNodeStream.this.eof;
        }

        public void remove() {
            throw new RuntimeException("cannot remove nodes from stream");
        }
    }
}

