/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXAnnotationAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXCodeAdapter;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXFieldAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXClassAdapter
extends SAXAdapter
implements ClassVisitor {
    private final boolean singleDocument;
    private static final int ACCESS_CLASS = 262144;
    private static final int ACCESS_FIELD = 524288;
    private static final int ACCESS_INNER = 0x100000;

    public SAXClassAdapter(ContentHandler contentHandler, boolean bl) {
        super(contentHandler);
        this.singleDocument = bl;
        if (!bl) {
            this.addDocumentStart();
        }
    }

    public void visitSource(String string2, String string3) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (string2 != null) {
            attributesImpl.addAttribute("", "file", "file", "", SAXClassAdapter.encode(string2));
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "debug", "debug", "", SAXClassAdapter.encode(string3));
        }
        this.addElement("source", attributesImpl);
    }

    public void visitOuterClass(String string2, String string3, String string4) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "owner", "owner", "", string2);
        if (string3 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string3);
        }
        if (string4 != null) {
            attributesImpl.addAttribute("", "desc", "desc", "", string4);
        }
        this.addElement("outerclass", attributesImpl);
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        return new SAXAnnotationAdapter(this.getContentHandler(), "annotation", bl ? 1 : -1, null, string2);
    }

    public void visit(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        SAXClassAdapter.appendAccess(n2 | 0x40000, stringBuffer);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
        if (string2 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string2);
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(string3));
        }
        if (string4 != null) {
            attributesImpl.addAttribute("", "parent", "parent", "", string4);
        }
        attributesImpl.addAttribute("", "major", "major", "", Integer.toString(n & 0xFFFF));
        attributesImpl.addAttribute("", "minor", "minor", "", Integer.toString(n >>> 16));
        this.addStart("class", attributesImpl);
        this.addStart("interfaces", new AttributesImpl());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                AttributesImpl attributesImpl2 = new AttributesImpl();
                attributesImpl2.addAttribute("", "name", "name", "", stringArray[i]);
                this.addElement("interface", attributesImpl2);
            }
        }
        this.addEnd("interfaces");
    }

    public FieldVisitor visitField(int n, String string2, String string3, String string4, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        SAXClassAdapter.appendAccess(n | 0x80000, stringBuffer);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        if (string4 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", SAXClassAdapter.encode(string4));
        }
        if (object != null) {
            attributesImpl.addAttribute("", "value", "value", "", SAXClassAdapter.encode(object.toString()));
        }
        return new SAXFieldAdapter(this.getContentHandler(), attributesImpl);
    }

    public MethodVisitor visitMethod(int n, String string2, String string3, String string4, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        SAXClassAdapter.appendAccess(n, stringBuffer);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
        attributesImpl.addAttribute("", "name", "name", "", string2);
        attributesImpl.addAttribute("", "desc", "desc", "", string3);
        if (string4 != null) {
            attributesImpl.addAttribute("", "signature", "signature", "", string4);
        }
        this.addStart("method", attributesImpl);
        this.addStart("exceptions", new AttributesImpl());
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                AttributesImpl attributesImpl2 = new AttributesImpl();
                attributesImpl2.addAttribute("", "name", "name", "", stringArray[i]);
                this.addElement("exception", attributesImpl2);
            }
        }
        this.addEnd("exceptions");
        return new SAXCodeAdapter(this.getContentHandler(), n);
    }

    public final void visitInnerClass(String string2, String string3, String string4, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        SAXClassAdapter.appendAccess(n | 0x100000, stringBuffer);
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "access", "access", "", stringBuffer.toString());
        if (string2 != null) {
            attributesImpl.addAttribute("", "name", "name", "", string2);
        }
        if (string3 != null) {
            attributesImpl.addAttribute("", "outerName", "outerName", "", string3);
        }
        if (string4 != null) {
            attributesImpl.addAttribute("", "innerName", "innerName", "", string4);
        }
        this.addElement("innerclass", attributesImpl);
    }

    public final void visitEnd() {
        this.addEnd("class");
        if (!this.singleDocument) {
            this.addDocumentEnd();
        }
    }

    static final String encode(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c < ' ' || c > '\u007f') {
                stringBuffer.append("\\u");
                if (c < '\u0010') {
                    stringBuffer.append("000");
                } else if (c < '\u0100') {
                    stringBuffer.append("00");
                } else if (c < '\u1000') {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toString(c, 16));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static void appendAccess(int n, StringBuffer stringBuffer) {
        if ((n & 1) != 0) {
            stringBuffer.append("public ");
        }
        if ((n & 2) != 0) {
            stringBuffer.append("private ");
        }
        if ((n & 4) != 0) {
            stringBuffer.append("protected ");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append("final ");
        }
        if ((n & 8) != 0) {
            stringBuffer.append("static ");
        }
        if ((n & 0x20) != 0) {
            if ((n & 0x40000) == 0) {
                stringBuffer.append("synchronized ");
            } else {
                stringBuffer.append("super ");
            }
        }
        if ((n & 0x40) != 0) {
            if ((n & 0x80000) == 0) {
                stringBuffer.append("bridge ");
            } else {
                stringBuffer.append("volatile ");
            }
        }
        if ((n & 0x80) != 0) {
            if ((n & 0x80000) == 0) {
                stringBuffer.append("varargs ");
            } else {
                stringBuffer.append("transient ");
            }
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("native ");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append("strict ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("interface ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("abstract ");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("synthetic ");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("annotation ");
        }
        if ((n & 0x4000) != 0) {
            stringBuffer.append("enum ");
        }
        if ((n & 0x20000) != 0) {
            stringBuffer.append("deprecated ");
        }
    }
}

