/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.UnmarshalXPathEngine;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.documentpreservation.NoDocumentPreservationPolicy;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderPolicy;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.UnionField;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.XMLEntry;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathEngine<XML_FIELD extends Field> {
    private static XPathEngine instance = null;
    private UnmarshalXPathEngine unmarshalXPathEngine;
    private DocumentPreservationPolicy noDocPresPolicy = new NoDocumentPreservationPolicy();
    private DocumentPreservationPolicy xmlBinderPolicy = new XMLBinderPolicy();

    public static XPathEngine getInstance() {
        if (instance == null) {
            instance = new XPathEngine();
        }
        return instance;
    }

    private XPathEngine() {
        this.unmarshalXPathEngine = new UnmarshalXPathEngine();
    }

    public Node create(Field xmlField, Node element, CoreAbstractSession session) throws XMLMarshalException {
        return this.create(xmlField, element, this, session);
    }

    public Node create(Field xmlField, Node element, Object value2, CoreAbstractSession session) {
        return this.create(xmlField, element, value2, null, this.noDocPresPolicy, session);
    }

    public Node create(Field xmlField, Node element, Object value2, Field lastUpdated, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) throws XMLMarshalException {
        XPathFragment fragment;
        if (value2 == null) {
            return null;
        }
        if (docPresPolicy == null) {
            docPresPolicy = this.noDocPresPolicy;
        }
        if ((fragment = xmlField.getXPathFragment()).getNextFragment() == null && fragment.nameIsText()) {
            Object textValue = this.getValueToWrite(value2, xmlField, session);
            if (textValue instanceof String) {
                if (xmlField.isTypedTextField()) {
                    XMLNodeList createdElements = new XMLNodeList();
                    createdElements.add(element);
                    this.addTypeAttributes(createdElements, xmlField, value2, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)));
                }
                return this.addText(xmlField, element, (String)textValue);
            }
            return null;
        }
        NodeList created = this.createCollection(xmlField, element, value2, lastUpdated, docPresPolicy, session);
        if (created == null || created.getLength() == 0) {
            return null;
        }
        return created.item(0);
    }

    public void create(List<Field> xmlFields, Node contextNode, List<XMLEntry> values, Field lastUpdatedField, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) {
        ArrayList<Object> itemsToWrite = new ArrayList<Object>();
        int i = 0;
        int size2 = values.size();
        while (i < size2) {
            XMLEntry nextEntry = values.get(i);
            itemsToWrite.add(nextEntry.getValue());
            if (i == values.size() - 1 || values.get(i + 1).getXMLField() != nextEntry.getXMLField()) {
                this.create(nextEntry.getXMLField(), contextNode, itemsToWrite, lastUpdatedField, docPresPolicy, session);
                itemsToWrite = new ArrayList();
                lastUpdatedField = nextEntry.getXMLField();
            }
            ++i;
        }
    }

    private NodeList createCollection(Field xmlField, Node element, Object value2, Field lastUpdated, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) throws XMLMarshalException {
        NodeList nodes;
        XMLNodeList createdElements = new XMLNodeList();
        if (value2 == null || value2 instanceof Collection && ((Collection)value2).size() == 0) {
            return createdElements;
        }
        Node nextElement = element;
        Element sibling = null;
        XPathFragment siblingFragment = null;
        if (lastUpdated != null) {
            siblingFragment = lastUpdated.getXPathFragment();
        }
        if (lastUpdated != null && !siblingFragment.isAttribute() && !siblingFragment.nameIsText() && (nodes = this.unmarshalXPathEngine.selectElementNodes(element, siblingFragment, this.getNamespaceResolverForField(lastUpdated))).getLength() > 0) {
            sibling = (Element)nodes.item(nodes.getLength() - 1);
        }
        XPathFragment next2 = xmlField.getXPathFragment();
        while (next2 != null) {
            NodeList nodes2;
            if (next2.isAttribute()) {
                this.addAttribute(next2, xmlField, nextElement, value2, session);
            } else if (next2.containsIndex()) {
                boolean hasMore;
                boolean bl = hasMore = !next2.getHasText() && next2.getNextFragment() != null;
                if (hasMore) {
                    nextElement = this.addIndexedElement(next2, xmlField, nextElement, this, !hasMore, session);
                } else {
                    Object valueToWrite = this.getValueToWrite(value2, xmlField, session);
                    nextElement = this.addIndexedElement(next2, xmlField, nextElement, valueToWrite, !hasMore, session);
                    createdElements.add(nextElement);
                }
            } else {
                NodeList elements;
                boolean hasMore;
                boolean bl = hasMore = !next2.getHasText() && next2.getNextFragment() != null;
                if (hasMore) {
                    elements = this.addElements(next2, xmlField, nextElement, this, !hasMore, sibling, docPresPolicy, session);
                } else {
                    XPathFragment nextFragment = next2.getNextFragment();
                    if (nextFragment != null && nextFragment.isAttribute() && !(value2 instanceof List)) {
                        elements = this.addElements(next2, xmlField, nextElement, this, hasMore, sibling, docPresPolicy, session);
                    } else {
                        Object valueToWrite = this.getValueToWrite(value2, xmlField, session);
                        elements = this.addElements(next2, xmlField, nextElement, valueToWrite, !hasMore, sibling, docPresPolicy, session);
                        createdElements.addAll(elements);
                    }
                }
                nextElement = elements.item(elements.getLength() - 1);
            }
            sibling = siblingFragment != null && sibling != null && siblingFragment.equals(next2) ? ((siblingFragment = siblingFragment.getNextFragment()) != null && !siblingFragment.isAttribute() && !siblingFragment.nameIsText() ? ((nodes2 = this.unmarshalXPathEngine.selectElementNodes(nextElement, siblingFragment, this.getNamespaceResolverForField(lastUpdated))).getLength() > 0 ? (Element)nodes2.item(nodes2.getLength() - 1) : null) : null) : null;
            next2 = next2.getNextFragment();
            if (next2 == null || !next2.nameIsText()) continue;
            next2 = null;
        }
        if (xmlField.isTypedTextField()) {
            this.addTypeAttributes(createdElements, xmlField, value2, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)));
        }
        return createdElements;
    }

    private Object getNonNodeValueToWrite(Object value2, Field xmlField, CoreAbstractSession session) {
        if (this == value2) {
            return this;
        }
        QName schemaType = null;
        if (xmlField.getLeafElementType() != null) {
            schemaType = xmlField.getLeafElementType();
        } else {
            if (xmlField.isUnionField()) {
                return this.getValueToWriteForUnion((UnionField)xmlField, value2, session);
            }
            if (xmlField.isTypedTextField()) {
                schemaType = xmlField.getXMLType(value2.getClass());
            } else if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        if (value2 instanceof List) {
            if (xmlField.usesSingleNode()) {
                StringBuilder returnStringBuilder = new StringBuilder();
                int i = 0;
                while (i < ((List)value2).size()) {
                    Object nextItem = ((List)value2).get(i);
                    String nextConvertedItem = null;
                    nextConvertedItem = schemaType != null && schemaType.equals(Constants.QNAME_QNAME) ? this.getStringForQName((QName)nextItem, this.getNamespaceResolverForField(xmlField)) : (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(nextItem, CoreClassConstants.STRING, schemaType);
                    returnStringBuilder.append(nextConvertedItem);
                    if (i < ((List)value2).size() - 1) {
                        returnStringBuilder.append(' ');
                    }
                    ++i;
                }
                return returnStringBuilder.toString();
            }
            ArrayList items = new ArrayList(((List)value2).size());
            int index = 0;
            while (index < ((List)value2).size()) {
                String nextConvertedItem;
                Object nextItem = ((List)value2).get(index);
                if (nextItem instanceof Node || nextItem == XMLRecord.NIL) {
                    items.add(nextItem);
                } else if (schemaType != null && schemaType.equals(Constants.QNAME_QNAME)) {
                    nextConvertedItem = this.getStringForQName((QName)nextItem, this.getNamespaceResolverForField(xmlField));
                    items.add(nextConvertedItem);
                } else {
                    nextConvertedItem = (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(nextItem, CoreClassConstants.STRING, schemaType);
                    items.add(nextConvertedItem);
                }
                ++index;
            }
            return items;
        }
        if (schemaType != null && schemaType.equals(Constants.QNAME_QNAME)) {
            return this.getStringForQName((QName)value2, this.getNamespaceResolverForField(xmlField));
        }
        return ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.STRING, schemaType);
    }

    private Object getValueToWrite(Object value2, Field xmlField, CoreAbstractSession session) {
        if (value2 instanceof Node || value2 == XMLRecord.NIL) {
            return value2;
        }
        return this.getNonNodeValueToWrite(value2, xmlField, session);
    }

    private String getSingleValueToWriteForUnion(UnionField xmlField, Object value2, CoreAbstractSession session) {
        List<QName> schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        int i = 0;
        while (i < schemaTypes.size()) {
            block4: {
                QName nextQName = xmlField.getSchemaTypes().get(i);
                try {
                    if (nextQName != null) {
                        Class javaClass = xmlField.getJavaClass(nextQName);
                        value2 = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value2, javaClass, nextQName);
                        schemaType = nextQName;
                        break;
                    }
                }
                catch (ConversionException conversionException) {
                    if (i != schemaTypes.size() - 1) break block4;
                    schemaType = nextQName;
                }
            }
            ++i;
        }
        return (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.STRING, schemaType);
    }

    private Object getValueToWriteForUnion(UnionField xmlField, Object value2, CoreAbstractSession session) {
        if (value2 instanceof List) {
            if (xmlField.usesSingleNode()) {
                StringBuilder returnStringBuilder = new StringBuilder();
                Object next2 = null;
                int i = 0;
                while (i < ((List)value2).size()) {
                    next2 = ((List)value2).get(i);
                    returnStringBuilder.append(this.getSingleValueToWriteForUnion(xmlField, next2, session));
                    if (i < ((List)value2).size() - 1) {
                        returnStringBuilder.append(' ');
                    }
                    ++i;
                }
                return returnStringBuilder.toString();
            }
            ArrayList<String> items = new ArrayList<String>(((List)value2).size());
            Object next3 = null;
            int i = 0;
            while (i < ((List)value2).size()) {
                next3 = ((List)value2).get(i);
                items.add(this.getSingleValueToWriteForUnion(xmlField, next3, session));
                ++i;
            }
            return items;
        }
        return this.getSingleValueToWriteForUnion(xmlField, value2, session);
    }

    private Node addIndexedElement(XPathFragment fragment, Field xmlField, Node parent, Object value2, boolean forceCreate, CoreAbstractSession session) throws XMLMarshalException {
        Node existingElement;
        String element = fragment.getShortName();
        int index = fragment.getIndexValue();
        if (index < 0) {
            throw XMLMarshalException.invalidXPathIndexString(fragment.getXPath());
        }
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(xmlField);
        int i = 1;
        while (i < index) {
            XMLField field2 = new XMLField(String.valueOf(element) + "[" + i + "]");
            field2.setNamespaceResolver(namespaceResolver);
            existingElement = (Node)this.unmarshalXPathEngine.selectSingleNode(parent, field2, namespaceResolver);
            if (existingElement == null) {
                this.addElement(new XPathFragment(element), xmlField, parent, this, true, session);
            }
            ++i;
        }
        XMLField field3 = new XMLField(fragment.getXPath());
        field3.setNamespaceResolver(namespaceResolver);
        existingElement = (Node)this.unmarshalXPathEngine.selectSingleNode(parent, field3, namespaceResolver);
        if (existingElement == null) {
            return this.addElement(new XPathFragment(element), field3, parent, value2, true, session);
        }
        if (existingElement != null && !forceCreate) {
            return existingElement;
        }
        String namespace = this.resolveNamespacePrefix(fragment, namespaceResolver);
        Element elementToReturn = parent.getOwnerDocument().createElementNS(namespace, element);
        if (value2 != this && value2 != null && value2 instanceof String) {
            this.addText(xmlField, elementToReturn, (String)value2);
        }
        parent.replaceChild(elementToReturn, existingElement);
        return elementToReturn;
    }

    private Node addElement(XPathFragment fragment, Field xmlField, Node parent, Object value2, boolean forceCreate, CoreAbstractSession session) {
        return this.addElement(fragment, xmlField, parent, null, value2, forceCreate, session);
    }

    private Node addElement(XPathFragment fragment, Field xmlField, Node parent, QName schemaType, Object value2, boolean forceCreate, CoreAbstractSession session) {
        NodeList list2 = this.addElements(fragment, xmlField, parent, value2, forceCreate, null, this.noDocPresPolicy, session);
        if (list2.getLength() > 0) {
            return list2.item(0);
        }
        return null;
    }

    private NodeList addElements(XPathFragment fragment, Field xmlField, Node parent, Object value2, boolean forceCreate, Element sibling, DocumentPreservationPolicy docPresPolicy, CoreAbstractSession session) {
        NodeList nodes;
        if (!forceCreate && (nodes = this.unmarshalXPathEngine.selectElementNodes(parent, fragment, this.getNamespaceResolverForField(xmlField))).getLength() > 0) {
            return nodes;
        }
        XMLNodeList elementsToReturn = new XMLNodeList();
        if (value2 == this) {
            XPathFragment predicateFragment;
            String namespace = this.resolveNamespacePrefix(fragment, this.getNamespaceResolverForField(xmlField));
            Element newElement = parent.getOwnerDocument().createElementNS(namespace, fragment.getShortName());
            XPathPredicate predicate = fragment.getPredicate();
            if (predicate != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                if (predicateFragment.getNamespaceURI() == null || predicateFragment.getNamespaceURI().length() == 0) {
                    newElement.setAttribute(predicateFragment.getLocalName(), fragment.getPredicate().getValue());
                } else {
                    String name = predicateFragment.getLocalName();
                    if (predicateFragment.getPrefix() != null && predicateFragment.getPrefix().length() != 0) {
                        name = String.valueOf(predicateFragment.getPrefix()) + ':' + name;
                    }
                    newElement.setAttributeNS(predicateFragment.getNamespaceURI(), name, fragment.getPredicate().getValue());
                }
            }
            elementsToReturn.add(newElement);
            docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
        } else if (value2 == null) {
            elementsToReturn.add(parent);
        } else if (value2 instanceof List) {
            List values = (List)value2;
            int index = 0;
            while (index < values.size()) {
                XPathFragment predicateFragment;
                Element newElement = null;
                if (values.get(index) != XMLRecord.NIL) {
                    newElement = (Element)this.createElement(parent, fragment, xmlField, values.get(index), session);
                } else {
                    newElement = (Element)this.createElement(parent, fragment, xmlField, "", session);
                    this.addXsiNilToElement(newElement, xmlField);
                }
                XPathPredicate predicate = fragment.getPredicate();
                if (predicate != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                    if (predicateFragment.getNamespaceURI() == null || predicateFragment.getNamespaceURI().length() == 0) {
                        newElement.setAttribute(predicateFragment.getLocalName(), fragment.getPredicate().getValue());
                    } else {
                        String name = predicateFragment.getLocalName();
                        if (predicateFragment.getPrefix() != null && predicateFragment.getPrefix().length() != 0) {
                            name = String.valueOf(predicateFragment.getPrefix()) + ':' + name;
                        }
                        newElement.setAttributeNS(predicateFragment.getNamespaceURI(), name, fragment.getPredicate().getValue());
                    }
                }
                docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
                elementsToReturn.add(newElement);
                sibling = newElement;
                ++index;
            }
        } else {
            XPathFragment predicateFragment;
            Element newElement = null;
            if (value2 != XMLRecord.NIL) {
                newElement = (Element)this.createElement(parent, fragment, xmlField, value2, session);
            } else {
                newElement = (Element)this.createElement(parent, fragment, xmlField, "", session);
                this.addXsiNilToElement(newElement, xmlField);
            }
            XPathPredicate predicate = fragment.getPredicate();
            if (predicate != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                if (predicateFragment.getNamespaceURI() == null || predicateFragment.getNamespaceURI().length() == 0) {
                    newElement.setAttribute(predicateFragment.getLocalName(), fragment.getPredicate().getValue());
                } else {
                    String name = predicateFragment.getLocalName();
                    if (predicateFragment.getPrefix() != null && predicateFragment.getPrefix().length() != 0) {
                        name = String.valueOf(predicateFragment.getPrefix()) + ':' + name;
                    }
                    newElement.setAttributeNS(predicateFragment.getNamespaceURI(), name, fragment.getPredicate().getValue());
                }
            }
            docPresPolicy.getNodeOrderingPolicy().appendNode(parent, newElement, sibling);
            elementsToReturn.add(newElement);
        }
        return elementsToReturn;
    }

    private Node createElement(Node parent, XPathFragment fragment, Field xmlField, Object value2, CoreAbstractSession session) {
        if (value2 == null) {
            return parent;
        }
        if (value2 instanceof Node) {
            return this.createElement(parent, fragment, this.getNamespaceResolverForField(xmlField), (Node)value2);
        }
        Element element = null;
        if (parent.getOwnerDocument() == null) {
            element = ((Document)parent).getDocumentElement();
        } else {
            XPathFragment predicateFragment;
            XPathPredicate predicate;
            String namespace = this.resolveNamespacePrefix(fragment, this.getNamespaceResolverForField(xmlField));
            NamespaceResolver domResolver = new NamespaceResolver();
            domResolver.setDOM(parent);
            String existingPrefix = domResolver.resolveNamespaceURI(namespace);
            String elementName = fragment.getShortName();
            if (existingPrefix != null) {
                elementName = existingPrefix.length() > 0 ? String.valueOf(existingPrefix) + ':' + fragment.getLocalName() : fragment.getLocalName();
            }
            element = parent.getOwnerDocument().createElementNS(namespace, elementName);
            if (fragment.isGeneratedPrefix() && existingPrefix == null) {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + fragment.getPrefix(), fragment.getNamespaceURI());
            }
            if ((predicate = fragment.getPredicate()) != null && (predicateFragment = predicate.getXPathFragment()).isAttribute()) {
                element.setAttributeNS(predicateFragment.getNamespaceURI(), predicateFragment.getLocalName(), fragment.getPredicate().getValue());
            }
        }
        XPathFragment nextFragment = fragment.getNextFragment();
        if (nextFragment != null && nextFragment.isAttribute()) {
            this.addAttribute(nextFragment, xmlField, element, value2, session);
        } else if (value2 instanceof String && ((String)value2).length() > 0) {
            this.addText(xmlField, element, (String)value2);
        } else if (value2 == XMLRecord.NIL) {
            this.addXsiNilToElement(element, xmlField);
        }
        return element;
    }

    public Element createUnownedElement(Node parent, Field xmlField) {
        XPathFragment lastFragment = xmlField.getXPathFragment();
        while (lastFragment.getNextFragment() != null) {
            lastFragment = lastFragment.getNextFragment();
        }
        lastFragment.getShortName();
        String namespace = this.resolveNamespacePrefix(lastFragment, this.getNamespaceResolverForField(xmlField));
        NamespaceResolver domResolver = new NamespaceResolver();
        domResolver.setDOM(parent);
        String existingPrefix = domResolver.resolveNamespaceURI(namespace);
        String elementName = lastFragment.getShortName();
        if (existingPrefix != null) {
            elementName = existingPrefix.length() > 0 ? String.valueOf(existingPrefix) + ':' + lastFragment.getLocalName() : lastFragment.getLocalName();
        }
        Element elem = parent.getOwnerDocument().createElementNS(namespace, elementName);
        if (lastFragment.isGeneratedPrefix() && existingPrefix == null) {
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + lastFragment.getPrefix(), lastFragment.getNamespaceURI());
        }
        return elem;
    }

    private void addTypeAttributes(NodeList elements, Field field2, Object value2, String schemaInstancePrefix) {
        ArrayList<Object> values;
        NamespaceResolver namespaceResolver = this.getNamespaceResolverForField(field2);
        if (!field2.isTypedTextField()) {
            return;
        }
        if (value2 instanceof List) {
            values = (ArrayList<Object>)value2;
        } else {
            values = new ArrayList<Object>();
            values.add(value2);
        }
        int size2 = elements.getLength();
        int valuesSize = values.size();
        if (size2 != valuesSize) {
            return;
        }
        Node next2 = null;
        int i = 0;
        while (i < size2) {
            QName qname;
            Class<?> valueClass;
            next2 = elements.item(i);
            if (next2.getNodeType() == 1 && (valueClass = values.get(i).getClass()) != CoreClassConstants.STRING && (qname = field2.getXMLType(valueClass)) != null) {
                String prefix;
                if (schemaInstancePrefix == null) {
                    schemaInstancePrefix = namespaceResolver.generatePrefix("xsi");
                    ((Element)next2).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + schemaInstancePrefix, "http://www.w3.org/2001/XMLSchema-instance");
                }
                if ((prefix = this.resolveNamespacePrefixForURI(qname.getNamespaceURI(), namespaceResolver)) == null || prefix.length() == 0) {
                    prefix = qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? namespaceResolver.generatePrefix("xsd") : namespaceResolver.generatePrefix();
                    ((Element)next2).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, qname.getNamespaceURI());
                }
                String type = String.valueOf(prefix) + ':' + qname.getLocalPart();
                ((Element)next2).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", String.valueOf(schemaInstancePrefix) + ':' + "type", type);
            }
            ++i;
        }
    }

    private Node createElement(Node parent, XPathFragment fragment, NamespaceResolver namespaceResolver, Node value2) {
        fragment.getXPath();
        Document document = parent.getOwnerDocument();
        if (document == null && parent.getNodeType() == 9) {
            document = (Document)parent;
        }
        String nodeUri = value2.getNamespaceURI();
        String nodeName = value2.getLocalName();
        String fragUri = fragment.getNamespaceURI();
        String fragName = fragment.getLocalName();
        if (nodeName != null && nodeName.equals(fragName) && (nodeUri != null && nodeUri.equals(fragUri) || nodeUri == null && fragUri == null)) {
            if (document != value2.getOwnerDocument()) {
                return document.importNode(value2, true);
            }
            return value2;
        }
        String namespace = this.resolveNamespacePrefix(fragment, namespaceResolver);
        Element clone2 = document.createElementNS(namespace, fragName);
        NamedNodeMap attributes = value2.getAttributes();
        int attributesLength = attributes.getLength();
        int index = 0;
        while (index < attributesLength) {
            Node attribute = document.importNode(attributes.item(index), true);
            clone2.setAttributeNode((Attr)attribute);
            ++index;
        }
        NodeList elements = value2.getChildNodes();
        int elementsLength = elements.getLength();
        int index2 = 0;
        while (index2 < elementsLength) {
            Node attribute = document.importNode(elements.item(index2), true);
            clone2.appendChild(attribute);
            ++index2;
        }
        return clone2;
    }

    private Node addAttribute(XPathFragment attributeFragment, Field xmlField, Node parent, Object value2, CoreAbstractSession session) {
        Object valueToWrite = null;
        if (!(parent instanceof Element)) {
            return parent;
        }
        Element parentElement = (Element)parent;
        if (value2 instanceof Node) {
            if (((Node)value2).getNodeType() == 2) {
                Attr attr = (Attr)value2;
                if (parent.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) == null) {
                    String pfx = null;
                    if (xmlField.getNamespaceResolver() != null) {
                        pfx = this.getNamespaceResolverForField(xmlField).resolveNamespaceURI(attr.getNamespaceURI());
                    }
                    if (pfx != null) {
                        parentElement.setAttributeNS(attr.getNamespaceURI(), String.valueOf(pfx) + ':' + attr.getLocalName(), attr.getNodeValue());
                    } else {
                        parentElement.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getNodeValue());
                    }
                }
                return parent;
            }
            valueToWrite = value2;
        } else {
            valueToWrite = this.getNonNodeValueToWrite(value2, xmlField, session);
        }
        String attributeName = attributeFragment.getLocalName();
        String attributeNamespace = this.resolveNamespacePrefix(attributeFragment, this.getNamespaceResolverForField(xmlField));
        if (valueToWrite != null && parent.getAttributes().getNamedItemNS(attributeNamespace, attributeName) == null) {
            if (valueToWrite == this) {
                parentElement.setAttributeNS(attributeNamespace, attributeFragment.getShortName(), "");
            } else if (valueToWrite instanceof String) {
                parentElement.setAttributeNS(attributeNamespace, attributeFragment.getShortName(), (String)valueToWrite);
            }
            if (attributeFragment.isGeneratedPrefix()) {
                parentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + attributeFragment.getPrefix(), attributeFragment.getNamespaceURI());
            }
        }
        return parent;
    }

    public NodeList remove(Field xmlField, Node element) throws XMLMarshalException {
        return this.remove(xmlField, element, false);
    }

    public NodeList remove(Field xmlField, Node element, boolean forceRemove) throws XMLMarshalException {
        String xpathString = xmlField.getXPath();
        NodeList nodes = this.unmarshalXPathEngine.selectNodes(element, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField));
        int numberOfNodes = nodes.getLength();
        boolean shouldNullOutNode = this.containsIndex(xpathString) && !forceRemove;
        int i = 0;
        while (i < numberOfNodes) {
            Node node2 = nodes.item(i);
            if (node2.getNodeType() == 2) {
                ((Attr)node2).getOwnerElement().removeAttribute(node2.getNodeName());
            } else if (shouldNullOutNode) {
                Element blankNode = node2.getParentNode().getOwnerDocument().createElementNS(node2.getNamespaceURI(), node2.getNodeName());
                node2.getParentNode().replaceChild(blankNode, node2);
            } else {
                node2.getParentNode().removeChild(node2);
            }
            ++i;
        }
        return nodes;
    }

    public NodeList replaceValue(Field xmlField, Node parent, Object value2, CoreAbstractSession session) throws XMLMarshalException {
        int i;
        NodeList nodes = this.unmarshalXPathEngine.selectNodes(parent, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField), null, false, false);
        int numberOfNodes = nodes.getLength();
        if (numberOfNodes == 0 && xmlField.getLastXPathFragment().nameIsText()) {
            nodes = this.unmarshalXPathEngine.selectNodes(parent, xmlField, this.getNamespaceResolverForField(xmlField), null, true);
            XMLNodeList textNodes = new XMLNodeList();
            i = 0;
            while (i < nodes.getLength()) {
                Element nextNode = (Element)nodes.item(i);
                Text text = nextNode.getOwnerDocument().createTextNode("");
                nextNode.appendChild(text);
                textNodes.add(text);
                ++i;
            }
            numberOfNodes = textNodes.getLength();
            nodes = textNodes;
        }
        XMLNodeList createdElements = new XMLNodeList();
        i = 0;
        while (i < numberOfNodes) {
            Node node2 = nodes.item(i);
            if (node2.getNodeType() != 1) {
                if ((node2.getNodeType() == 3 || node2.getNodeType() == 4) && value2 == null) {
                    Node parentNode = node2.getParentNode();
                    if (parentNode != null) {
                        Node grandParentNode = parentNode.getParentNode();
                        NodeList childNodes = parentNode.getChildNodes();
                        if (childNodes.getLength() == numberOfNodes) {
                            grandParentNode.removeChild(parentNode);
                        } else {
                            int x = 0;
                            while (x < childNodes.getLength()) {
                                Node next2 = childNodes.item(x);
                                if (next2.getNodeType() == 3 || next2.getNodeType() == 4) {
                                    parentNode.removeChild(next2);
                                }
                                ++x;
                            }
                        }
                    }
                } else if (value2 == null) {
                    ((Attr)node2).getOwnerElement().removeAttributeNode((Attr)node2);
                } else if (value2 == XMLRecord.NIL && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
                    Element parentElement = (Element)node2.getParentNode();
                    this.addXsiNilToElement(parentElement, xmlField);
                    parentElement.removeChild(node2);
                } else {
                    String stringValue = (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.STRING);
                    Element parentElement = (Element)node2.getParentNode();
                    if (parentElement == null && parent.getNodeType() == 1) {
                        parentElement = (Element)parent;
                    }
                    if (stringValue.length() == 0 && (node2.getNodeType() == 3 || node2.getNodeType() == 4) && parentElement != null) {
                        parentElement.removeChild(node2);
                    } else {
                        Attr nil;
                        node2.setNodeValue(stringValue);
                        if ((node2.getNodeType() == 3 || node2.getNodeType() == 4) && parentElement != null && (nil = parentElement.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "nil")) != null) {
                            parentElement.removeAttributeNode(nil);
                        }
                    }
                }
            } else {
                Element element = (Element)node2;
                Node parentNode = element.getParentNode();
                if (value2 == null) {
                    parentNode.removeChild(element);
                } else {
                    String elementName = element.getTagName();
                    Element newElement = null;
                    Object valueToWrite = this.getValueToWrite(value2, xmlField, session);
                    XPathFragment childFrag = new XPathFragment(elementName);
                    childFrag.setNamespaceURI(element.getNamespaceURI());
                    newElement = (Element)this.createElement(parentNode, childFrag, xmlField, valueToWrite, session);
                    createdElements.add(newElement);
                    if (newElement != element) {
                        parentNode.replaceChild(newElement, element);
                    }
                }
            }
            ++i;
        }
        if (xmlField.isTypedTextField()) {
            this.addTypeAttributes(createdElements, xmlField, value2, this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", this.getNamespaceResolverForField(xmlField)));
        }
        return nodes;
    }

    public List<XMLEntry> replaceCollection(List<Field> xmlFields, List<XMLEntry> values, Node contextNode, DocumentPreservationPolicy docPresPolicy, Field lastUpdatedField, CoreAbstractSession session) {
        List<XMLEntry> oldNodes = this.unmarshalXPathEngine.selectNodes(contextNode, xmlFields, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlFields.get(0)));
        if (oldNodes == null || oldNodes.size() == 0) {
            return oldNodes;
        }
        block0: for (XMLEntry entry2 : oldNodes) {
            Node nextNode = (Node)entry2.getValue();
            Node parent = nextNode.getParentNode();
            parent.removeChild(nextNode);
            while (parent != contextNode) {
                if (parent.getChildNodes().getLength() != 0) continue block0;
                nextNode = parent;
                parent = nextNode.getParentNode();
                parent.removeChild(nextNode);
            }
        }
        this.create(xmlFields, contextNode, values, lastUpdatedField, this.xmlBinderPolicy, session);
        return oldNodes;
    }

    public NodeList replaceCollection(Field xmlField, Node parent, Collection values, CoreAbstractSession session) throws XMLMarshalException {
        NodeList nodes = null;
        nodes = xmlField != null ? this.unmarshalXPathEngine.selectNodes(parent, xmlField, (XMLNamespaceResolver)this.getNamespaceResolverForField(xmlField)) : parent.getChildNodes();
        if (nodes.getLength() == 0) {
            return nodes;
        }
        Iterator collectionValues = values.iterator();
        int i = 0;
        int nodesLength = nodes.getLength();
        Vector<Element> newNodes = new Vector<Element>();
        boolean performedReplace = true;
        Object value2 = null;
        while (i < nodesLength && collectionValues.hasNext()) {
            Node oldChild = nodes.item(i);
            Element newChild = null;
            if (performedReplace) {
                value2 = collectionValues.next();
            }
            Node parentNode = oldChild.getParentNode();
            if (oldChild.getNodeType() != 1) {
                if ((oldChild.getNodeType() == 3 || oldChild.getNodeType() == 4) && value2 == null) {
                    Node grandParentNode = parentNode.getParentNode();
                    grandParentNode.removeChild(parentNode);
                } else {
                    oldChild.setNodeValue((String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value2, CoreClassConstants.STRING));
                }
            } else {
                Element element = (Element)oldChild;
                String elementName = element.getTagName();
                Object valueToWrite = this.getValueToWrite(value2, xmlField, session);
                XPathFragment childFragment = new XPathFragment(elementName);
                childFragment.setNamespaceURI(element.getNamespaceURI());
                newChild = (Element)this.createElement(parentNode, childFragment, xmlField, valueToWrite, session);
                if (!newNodes.contains(oldChild)) {
                    if (newChild != oldChild) {
                        parentNode.replaceChild(newChild, oldChild);
                    }
                    newNodes.addElement(newChild);
                    performedReplace = true;
                } else {
                    performedReplace = false;
                }
            }
            ++i;
        }
        while (i < nodesLength) {
            Node toRemove = nodes.item(i);
            Node removedParent = toRemove.getParentNode();
            if (removedParent != null && !newNodes.contains(toRemove)) {
                removedParent.removeChild(toRemove);
            }
            ++i;
        }
        if (value2 != null && !performedReplace) {
            if (xmlField.getXPathFragment().getNextFragment() == null || xmlField.getXPathFragment().getHasText()) {
                this.create(xmlField, parent, value2, xmlField, this.xmlBinderPolicy, session);
            } else {
                this.create(xmlField, parent, value2, session);
            }
        }
        while (collectionValues.hasNext()) {
            value2 = collectionValues.next();
            if (xmlField.getXPathFragment().getNextFragment() == null || xmlField.getXPathFragment().getHasText()) {
                this.create(xmlField, parent, value2, xmlField, this.xmlBinderPolicy, session);
                continue;
            }
            this.create(xmlField, parent, value2, session);
        }
        return nodes;
    }

    private boolean containsIndex(String xpathString) {
        return xpathString.lastIndexOf(91) != -1 && xpathString.lastIndexOf(93) != -1;
    }

    private String resolveNamespacePrefix(XPathFragment fragment, NamespaceResolver namespaceResolver) {
        block4: {
            try {
                if (fragment.getNamespaceURI() != null) {
                    return fragment.getNamespaceURI();
                }
                if (fragment.getPrefix() != null || !fragment.isAttribute()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return namespaceResolver.resolveNamespacePrefix(fragment.getPrefix());
    }

    private String resolveNamespacePrefixForURI(String namespaceURI, NamespaceResolver namespaceResolver) {
        if (namespaceResolver == null) {
            return null;
        }
        return namespaceResolver.resolveNamespaceURI(namespaceURI);
    }

    private Node addText(Field xmlField, Node element, String textValue) {
        if (xmlField.isCDATA()) {
            CDATASection cdata = element.getOwnerDocument().createCDATASection(textValue);
            element.appendChild(cdata);
            return cdata;
        }
        Text text = element.getOwnerDocument().createTextNode(textValue);
        element.appendChild(text);
        return text;
    }

    private String getStringForQName(QName qName, NamespaceResolver namespaceResolver) {
        if (qName == null) {
            return null;
        }
        if (qName.getNamespaceURI() == null) {
            return qName.getLocalPart();
        }
        String namespaceURI = qName.getNamespaceURI();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(namespaceURI);
        }
        String prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
        if (prefix == null) {
            return qName.getLocalPart();
        }
        return String.valueOf(prefix) + ':' + qName.getLocalPart();
    }

    private NamespaceResolver getNamespaceResolverForField(Field field2) {
        NamespaceResolver nr = (NamespaceResolver)field2.getNamespaceResolver();
        if (nr == null) {
            field2.setNamespaceResolver(new NamespaceResolver());
        }
        return (NamespaceResolver)field2.getNamespaceResolver();
    }

    private void addXsiNilToElement(Element element, Field xmlField) {
        NamespaceResolver nsr = new NamespaceResolver();
        nsr.setDOM(element);
        String schemaInstancePrefix = this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", nsr);
        Node parentNode = element.getParentNode();
        while (schemaInstancePrefix == null && parentNode != null && parentNode.getNodeType() == 1) {
            nsr.setDOM(element);
            schemaInstancePrefix = this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", nsr);
            parentNode = parentNode.getParentNode();
        }
        if (schemaInstancePrefix == null && element.getOwnerDocument() != null) {
            nsr.setDOM(element.getOwnerDocument().getDocumentElement());
            schemaInstancePrefix = this.resolveNamespacePrefixForURI("http://www.w3.org/2001/XMLSchema-instance", nsr);
        }
        if (schemaInstancePrefix == null) {
            nsr = this.getNamespaceResolverForField(xmlField);
            schemaInstancePrefix = nsr.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
            if (schemaInstancePrefix == null) {
                schemaInstancePrefix = nsr.generatePrefix("xsi");
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + schemaInstancePrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        element.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
    }
}

