/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.record.PlatformUnmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DOMUnmarshaller
implements PlatformUnmarshaller {
    private XMLParser parser;
    private XMLUnmarshaller xmlUnmarshaller;
    private boolean isResultAlwaysXMLRoot;

    public DOMUnmarshaller(XMLUnmarshaller xmlUnmarshaller, Map<String, Boolean> parserFeatures) {
        this.parser = parserFeatures == null ? XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser() : XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser(parserFeatures);
        this.parser.setNamespaceAware(true);
        this.parser.setValidationMode(0);
        this.xmlUnmarshaller = xmlUnmarshaller;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    @Override
    public int getValidationMode() {
        return this.parser.getValidationMode();
    }

    @Override
    public void setValidationMode(int validationMode) {
        this.parser.setValidationMode(validationMode);
    }

    @Override
    public void setWhitespacePreserving(boolean isWhitespacePreserving) {
        this.parser.setWhitespacePreserving(isWhitespacePreserving);
    }

    @Override
    public void setSchemas(Object[] schemas) {
        try {
            this.parser.setXMLSchemas(schemas);
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.errorSettingSchemas(e, schemas);
        }
    }

    @Override
    public void setSchema(Schema schema) {
        this.parser.setXMLSchema(schema);
    }

    @Override
    public Schema getSchema() {
        Schema schema = null;
        try {
            schema = this.parser.getXMLSchema();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        return schema;
    }

    @Override
    public Object unmarshal(File file) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(file);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(File file, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(file);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputStream inputStream, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputStream);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(InputSource inputSource, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Node node2) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        Element element = null;
        switch (node2.getNodeType()) {
            case 9: {
                element = ((Document)node2).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node2;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element));
    }

    @Override
    public Object unmarshal(Node node2, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        Element element = null;
        switch (node2.getNodeType()) {
            case 9: {
                element = ((Document)node2).getDocumentElement();
                break;
            }
            case 1: {
                element = (Element)node2;
                break;
            }
            default: {
                throw XMLMarshalException.unmarshalException();
            }
        }
        return this.xmlToObject(new DOMRecord(element), clazz);
    }

    @Override
    public Object unmarshal(Reader reader) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(reader);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Reader reader, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(reader);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Source source) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(source);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(Source source, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(source);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(URL url) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(url);
            Object object = this.xmlToObject(new DOMRecord(document));
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(URL url, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            Document document = null;
            document = this.parser.parse(url);
            Object object = this.xmlToObject(new DOMRecord(document), clazz);
            return object;
        }
        catch (XMLPlatformException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
            xmlReader.setContentHandler(saxDocumentBuilder);
            xmlReader.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(saxDocumentBuilder.getDocument()));
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public Object unmarshal(XMLReader xmlReader, InputSource inputSource, Class clazz) {
        if (!this.xmlUnmarshaller.getMediaType().isApplicationXML()) {
            throw XMLMarshalException.unsupportedMediaTypeForPlatform();
        }
        try {
            SAXDocumentBuilder saxDocumentBuilder = new SAXDocumentBuilder();
            xmlReader.setContentHandler(saxDocumentBuilder);
            xmlReader.parse(inputSource);
            Object object = this.xmlToObject(new DOMRecord(saxDocumentBuilder.getDocument()), clazz);
            return object;
        }
        catch (IOException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    public Object xmlToObject(DOMRecord xmlRecord) throws XMLMarshalException {
        return this.xmlToObject(xmlRecord, null);
    }

    public Object xmlToObject(DOMRecord xmlRow, Class referenceClass) throws XMLMarshalException {
        try {
            String xmlEncoding = "UTF-8";
            String xmlVersion = "1.0";
            try {
                Method getEncoding = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlEncoding", new Class[0], true);
                Method getVersion = PrivilegedAccessHelper.getMethod(xmlRow.getDocument().getClass(), "getXmlVersion", new Class[0], true);
                xmlEncoding = (String)PrivilegedAccessHelper.invokeMethod(getEncoding, xmlRow.getDocument(), new Object[0]);
                xmlVersion = (String)PrivilegedAccessHelper.invokeMethod(getVersion, xmlRow.getDocument(), new Object[0]);
            }
            catch (Exception exception) {}
            XMLContext xmlContext = this.xmlUnmarshaller.getXMLContext();
            if (referenceClass != null && (XMLConversionManager.getDefaultJavaTypes().get(referenceClass) != null || CoreClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(referenceClass) || CoreClassConstants.DURATION.isAssignableFrom(referenceClass))) {
                String nodeVal;
                try {
                    Text rootTxt = (Text)xmlRow.getDOM().getFirstChild();
                    nodeVal = rootTxt.getNodeValue();
                }
                catch (Exception exception) {
                    nodeVal = null;
                }
                Object obj = ((XMLConversionManager)((DatabaseSession)xmlContext.getSession()).getDatasourcePlatform().getConversionManager()).convertObject(nodeVal, referenceClass);
                XMLRoot xmlRoot = new XMLRoot();
                xmlRoot.setObject(obj);
                String lName = xmlRow.getDOM().getLocalName();
                if (lName == null) {
                    lName = xmlRow.getDOM().getNodeName();
                }
                xmlRoot.setLocalName(lName);
                xmlRoot.setNamespaceURI(xmlRow.getDOM().getNamespaceURI());
                xmlRoot.setEncoding(xmlEncoding);
                xmlRoot.setVersion(xmlVersion);
                XMLRoot xMLRoot = xmlRoot;
                return xMLRoot;
            }
            Descriptor descriptor = null;
            AbstractSession readSession = null;
            boolean shouldWrap = true;
            if (referenceClass == null) {
                String namespaceURI;
                QName rootQName = new QName(xmlRow.getNamespaceURI(), xmlRow.getLocalName());
                descriptor = xmlContext.getDescriptor(rootQName);
                if (descriptor == null) {
                    String type = ((Element)xmlRow.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (type != null) {
                        XPathFragment typeFragment = new XPathFragment(type);
                        namespaceURI = xmlRow.resolveNamespacePrefix(typeFragment.getPrefix());
                        typeFragment.setNamespaceURI(namespaceURI);
                        descriptor = xmlContext.getDescriptorByGlobalType(typeFragment);
                    }
                } else if (descriptor.getDefaultRootElementField() != null && !descriptor.isResultAlwaysXMLRoot() && !this.xmlUnmarshaller.isResultAlwaysXMLRoot()) {
                    String descLocalName = descriptor.getDefaultRootElementField().getXPathFragment().getLocalName();
                    String localName = xmlRow.getDOM().getLocalName();
                    if (localName == null) {
                        localName = xmlRow.getDOM().getNodeName();
                    }
                    namespaceURI = xmlRow.getDOM().getNamespaceURI();
                    if (descLocalName != null && descLocalName.equals(localName)) {
                        String descUri = descriptor.getDefaultRootElementField().getXPathFragment().getNamespaceURI();
                        if (namespaceURI == null && descUri == null || namespaceURI != null && namespaceURI.length() == 0 && descUri == null || namespaceURI != null && namespaceURI.equals(descUri)) {
                            shouldWrap = false;
                        }
                    }
                }
                if (descriptor == null) {
                    throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
                }
                readSession = xmlContext.getSession(descriptor.getJavaClass());
            } else {
                readSession = xmlContext.getSession(referenceClass);
                descriptor = (Descriptor)readSession.getDescriptor(referenceClass);
                if (descriptor == null) {
                    throw XMLMarshalException.descriptorNotFoundInProject(referenceClass.getName());
                }
            }
            Object object = null;
            if (xmlRow.getDOM().getAttributes().getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "nil") == null) {
                xmlRow.setUnmarshaller(this.xmlUnmarshaller);
                xmlRow.setDocPresPolicy(xmlContext.getDocumentPreservationPolicy(readSession));
                XMLObjectBuilder objectBuilder = (XMLObjectBuilder)descriptor.getObjectBuilder();
                ReadObjectQuery query = new ReadObjectQuery();
                query.setReferenceClass(referenceClass);
                query.setSession(readSession);
                object = objectBuilder.buildObject(query, xmlRow, null);
                xmlRow.resolveReferences(readSession, this.xmlUnmarshaller.getIDResolver());
            }
            String elementNamespaceUri = xmlRow.getDOM().getNamespaceURI();
            String elementLocalName = xmlRow.getDOM().getLocalName();
            if (elementLocalName == null) {
                elementLocalName = xmlRow.getDOM().getNodeName();
            }
            String elementPrefix = xmlRow.getDOM().getPrefix();
            if (shouldWrap || descriptor.isResultAlwaysXMLRoot() || this.isResultAlwaysXMLRoot) {
                Object object2 = descriptor.wrapObjectInXMLRoot(object, elementNamespaceUri, elementLocalName, elementPrefix, xmlEncoding, xmlVersion, this.isResultAlwaysXMLRoot, true, this.xmlUnmarshaller);
                return object2;
            }
            Object object3 = object;
            return object3;
        }
        finally {
            this.xmlUnmarshaller.getStringBuffer().reset();
        }
    }

    @Override
    public boolean isResultAlwaysXMLRoot() {
        return this.isResultAlwaysXMLRoot;
    }

    @Override
    public void setResultAlwaysXMLRoot(boolean alwaysReturnRoot) {
        this.isResultAlwaysXMLRoot = alwaysReturnRoot;
    }

    @Override
    public void mediaTypeChanged() {
    }
}

