/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DomToXMLEventWriter {
    private XMLEventFactory xmlEventFactory;

    public DomToXMLEventWriter() {
        this.xmlEventFactory = XMLEventFactory.newInstance();
    }

    public DomToXMLEventWriter(XMLEventFactory xmlEventFactory) {
        this.xmlEventFactory = xmlEventFactory;
    }

    public void writeToEventWriter(Node dom, String uri, String name, XMLEventWriter xew) throws XMLStreamException {
        Node currentNode = dom;
        if (dom.getNodeType() == 9) {
            Document doc = (Document)dom;
            xew.add(this.xmlEventFactory.createStartDocument(doc.getXmlEncoding(), doc.getXmlVersion()));
            currentNode = doc.getDocumentElement();
        }
        if (currentNode.getNodeType() == 1) {
            this.writeElement((Element)currentNode, uri, name, xew);
        } else if (currentNode.getNodeType() == 2) {
            Attr attribute = (Attr)currentNode;
            if (attribute.getPrefix() != null && attribute.getPrefix().equals("xmlns")) {
                xew.add(this.xmlEventFactory.createNamespace(attribute.getLocalName(), attribute.getValue()));
            } else if (attribute.getPrefix() == null) {
                xew.add(this.xmlEventFactory.createAttribute(attribute.getName(), attribute.getValue()));
            } else {
                xew.add(this.xmlEventFactory.createAttribute(attribute.getPrefix(), attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue()));
            }
        } else if (currentNode.getNodeType() == 3) {
            xew.add(this.xmlEventFactory.createCharacters(((Text)currentNode).getNodeValue()));
        }
        if (dom.getNodeType() == 9) {
            xew.add(this.xmlEventFactory.createEndDocument());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeElement(Element elem, String newNamespace, String newName, XMLEventWriter xew) throws XMLStreamException {
        void var14_19;
        void var14_16;
        String prefix = null;
        String namespace = null;
        String localName = null;
        String nodeName = null;
        if (newName != null) {
            namespace = newNamespace;
            localName = newName;
            nodeName = newName;
            if (newNamespace != null && newNamespace.length() > 0) {
                NamespaceResolver tempNR = new NamespaceResolver();
                tempNR.setDOM(elem);
                prefix = tempNR.resolveNamespaceURI(namespace);
                if (prefix == null || prefix.length() == 0) {
                    String defaultNamespace = elem.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
                    prefix = defaultNamespace == null ? tempNR.generatePrefix() : (defaultNamespace != namespace ? tempNR.generatePrefix() : "");
                }
            }
        } else {
            prefix = elem.getPrefix();
            namespace = elem.getNamespaceURI();
            localName = elem.getLocalName();
            nodeName = elem.getNodeName();
        }
        String defaultNamespace = xew.getNamespaceContext().getNamespaceURI("");
        boolean needToAddDefaultNS = false;
        if (prefix != null && prefix.length() > 0) {
            String namespaceURI = xew.getNamespaceContext().getNamespaceURI(prefix);
            xew.add(this.xmlEventFactory.createStartElement(prefix, namespace, localName));
            if (!namespace.equals(namespaceURI)) {
                xew.add(this.xmlEventFactory.createNamespace(prefix, namespace));
            }
        } else if (namespace == null || namespace.length() == 0) {
            xew.add(this.xmlEventFactory.createStartElement("", "", nodeName));
            if (defaultNamespace != null && defaultNamespace.length() > 0) {
                xew.add(this.xmlEventFactory.createNamespace(""));
            }
        } else {
            needToAddDefaultNS = true;
            xew.add(this.xmlEventFactory.createStartElement("", namespace, localName));
        }
        NodeList childNodes = elem.getChildNodes();
        NamedNodeMap attrs = elem.getAttributes();
        ArrayList<Object> nonNamespaceDeclAttrs = new ArrayList<Object>();
        boolean bl = false;
        while (var14_16 < attrs.getLength()) {
            Attr next2 = (Attr)attrs.item((int)var14_16);
            if (next2.getNodeType() == 2) {
                Object attribute = next2;
                if (next2.getPrefix() != null && next2.getPrefix().equals("xmlns")) {
                    String currentUri = xew.getNamespaceContext().getNamespaceURI(next2.getLocalName());
                    if (currentUri == null || !currentUri.equals(next2.getValue())) {
                        xew.add(this.xmlEventFactory.createNamespace(next2.getLocalName(), next2.getValue()));
                    }
                } else if (next2.getName().equals("xmlns")) {
                    xew.add(this.xmlEventFactory.createNamespace(next2.getValue()));
                    needToAddDefaultNS = false;
                } else {
                    nonNamespaceDeclAttrs.add(attribute);
                }
            }
            ++var14_16;
        }
        if (needToAddDefaultNS && (defaultNamespace == null || !defaultNamespace.equals(namespace))) {
            xew.add(this.xmlEventFactory.createNamespace(namespace));
        }
        for (Attr attr : nonNamespaceDeclAttrs) {
            if (attr.getPrefix() == null) {
                xew.add(this.xmlEventFactory.createAttribute(attr.getName(), attr.getValue()));
                continue;
            }
            xew.add(this.xmlEventFactory.createAttribute(attr.getPrefix(), attr.getNamespaceURI(), attr.getLocalName(), attr.getValue()));
        }
        boolean bl2 = false;
        while (var14_19 < childNodes.getLength()) {
            Node next2 = childNodes.item((int)var14_19);
            if (next2.getNodeType() == 3) {
                xew.add(this.xmlEventFactory.createCharacters(((Text)next2).getNodeValue()));
            } else if (next2.getNodeType() == 4) {
                xew.add(this.xmlEventFactory.createCData(next2.getNodeValue()));
            } else if (next2.getNodeType() == 8) {
                xew.add(this.xmlEventFactory.createComment(next2.getNodeValue()));
            } else if (next2.getNodeType() == 1) {
                this.writeElement((Element)next2, null, null, xew);
            }
            ++var14_19;
        }
        if (elem.getPrefix() != null && elem.getPrefix().length() > 0) {
            xew.add(this.xmlEventFactory.createEndElement(elem.getPrefix(), elem.getNamespaceURI(), elem.getLocalName()));
        } else if (elem.getNamespaceURI() != null && elem.getNamespaceURI().length() > 0) {
            xew.add(this.xmlEventFactory.createEndElement("", elem.getNamespaceURI(), elem.getLocalName()));
        } else {
            xew.add(this.xmlEventFactory.createEndElement("", "", elem.getNodeName()));
        }
    }
}

