/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLFragmentReader
extends DOMReader {
    protected NamespaceResolver nsresolver;
    protected List<NamespaceResolver> nsresolverList = new ArrayList<NamespaceResolver>();
    protected Map<Element, NamespaceResolver> tmpresolverMap;

    public XMLFragmentReader(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            this.nsresolverList.add(namespaceResolver);
        }
        this.tmpresolverMap = new HashMap<Element, NamespaceResolver>();
    }

    @Override
    public void parse(Node node2, String uri, String name) throws SAXException {
        if (node2.getNodeType() == 11) {
            this.handleChildNodes(node2.getChildNodes());
        } else {
            super.parse(node2, uri, name);
        }
    }

    @Override
    protected void reportElementEvents(Element elem) throws SAXException {
        super.reportElementEvents(elem);
        this.cleanupNamespaceResolvers(elem);
    }

    @Override
    protected void endDocument() throws SAXException {
    }

    @Override
    protected void startDocument() throws SAXException {
    }

    @Override
    protected void handleNewNamespaceDeclaration(Element elem, String prefix, String namespaceURI) {
        String uri = this.resolveNamespacePrefix(prefix);
        if (uri == null || !uri.equals(namespaceURI)) {
            NamespaceResolver tmpresolver = this.getTempResolver(elem);
            tmpresolver.put(prefix, namespaceURI);
            if (!this.nsresolverList.contains(tmpresolver)) {
                this.nsresolverList.add(tmpresolver);
            }
        }
    }

    @Override
    protected void handlePrefixedAttribute(Element elem) throws SAXException {
        NamedNodeMap attributes;
        String uri;
        String prefix = elem.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        if ((uri = this.resolveNamespacePrefix(prefix)) == null && elem.getNamespaceURI() != null || uri != null && !uri.equals(elem.getNamespaceURI())) {
            String namespaceURI;
            NamespaceResolver tmpresolver = this.getTempResolver(elem);
            tmpresolver.put(prefix, elem.getNamespaceURI());
            if (!this.nsresolverList.contains(tmpresolver)) {
                this.nsresolverList.add(tmpresolver);
            }
            if ((namespaceURI = elem.getNamespaceURI()) == null) {
                namespaceURI = "";
            }
            this.getContentHandler().startPrefixMapping(prefix, namespaceURI);
        }
        if ((attributes = elem.getAttributes()) != null) {
            int x = 0;
            while (x < attributes.getLength()) {
                NamespaceResolver tmpresolver;
                Node attribute = attributes.item(x);
                if ("xmlns".equals(attribute.getPrefix())) {
                    tmpresolver = this.getTempResolver(elem);
                    tmpresolver.put(attribute.getLocalName(), attribute.getNodeValue());
                    if (!this.nsresolverList.contains(tmpresolver)) {
                        this.nsresolverList.add(tmpresolver);
                    }
                } else if ("xmlns".equals(attribute.getNodeName())) {
                    tmpresolver = this.getTempResolver(elem);
                    String namespace = attribute.getNodeValue();
                    if (namespace == null) {
                        namespace = "";
                    }
                    tmpresolver.put("", namespace);
                    if (!this.nsresolverList.contains(tmpresolver)) {
                        this.nsresolverList.add(tmpresolver);
                    }
                }
                ++x;
            }
        }
    }

    @Override
    protected void endPrefixMappings(Element elem) throws SAXException {
        NamespaceResolver tmpresolver = this.getTempResolver(elem);
        if (tmpresolver != null) {
            ExtendedContentHandler contentHandler = this.getContentHandler();
            String defaultNamespace = tmpresolver.getDefaultNamespaceURI();
            if (defaultNamespace != null) {
                contentHandler.endPrefixMapping("");
            }
            if (tmpresolver.hasPrefixesToNamespaces()) {
                for (Map.Entry<String, String> entry2 : tmpresolver.getPrefixesToNamespaces().entrySet()) {
                    contentHandler.endPrefixMapping(entry2.getKey());
                }
            }
        }
    }

    protected NamespaceResolver getTempResolver(Element elem) {
        NamespaceResolver tmpresolver = this.tmpresolverMap.get(elem);
        if (tmpresolver == null) {
            tmpresolver = new NamespaceResolver();
            this.tmpresolverMap.put(elem, tmpresolver);
        }
        return tmpresolver;
    }

    protected void cleanupNamespaceResolvers(Element elem) {
        NamespaceResolver tmpresolver = this.tmpresolverMap.get(elem);
        if (tmpresolver != null) {
            this.tmpresolverMap.remove(elem);
            this.nsresolverList.remove(tmpresolver);
        }
    }

    protected String resolveNamespacePrefix(String prefix) {
        String uri = null;
        if (prefix == null || prefix.length() == 0) {
            int i = this.nsresolverList.size() - 1;
            while (i >= 0) {
                NamespaceResolver next2 = this.nsresolverList.get(i);
                uri = next2.getDefaultNamespaceURI();
                if (uri == null || uri.length() <= 0) {
                    --i;
                    continue;
                }
                break;
            }
        } else {
            int i = this.nsresolverList.size() - 1;
            while (i >= 0) {
                NamespaceResolver next3 = this.nsresolverList.get(i);
                uri = next3.resolveNamespacePrefix(prefix);
                if (uri == null || uri.length() <= 0) {
                    --i;
                    continue;
                }
                break;
            }
        }
        return uri;
    }

    @Override
    protected void processParentNamespaces(Element element) throws SAXException {
    }

    @Override
    protected void handleXsiTypeAttribute(Attr attr) throws SAXException {
        String prefix;
        String uri;
        String value2 = attr.getValue();
        int colon2 = value2.indexOf(58);
        if (colon2 != -1 && (uri = this.resolveNamespacePrefix(prefix = value2.substring(0, colon2))) == null && (uri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(attr.getOwnerElement(), prefix)) != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }
}

