/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.sessions.CopyGroup;

public class AttributeItem
extends CoreAttributeItem<AttributeGroup>
implements Serializable {
    protected AttributeItem() {
    }

    public AttributeItem(AttributeGroup parent, String attributeName) {
        this.parent = parent;
        this.attributeName = attributeName;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public AttributeItem toCopyGroup(Map<AttributeGroup, CopyGroup> cloneMap, CopyGroup parentClone, Map copies) {
        AttributeItem clone2 = new AttributeItem();
        clone2.attributeName = this.attributeName;
        if (this.group != null) {
            clone2.group = ((AttributeGroup)this.group).toCopyGroup(cloneMap, copies);
        }
        if (clone2.keyGroup != null) {
            clone2.keyGroup = ((AttributeGroup)this.keyGroup).toCopyGroup(cloneMap, copies);
        }
        clone2.parent = parentClone;
        if (this.subGroups != null) {
            clone2.subGroups = new HashMap();
            for (Map.Entry group : this.subGroups.entrySet()) {
                clone2.subGroups.put(group.getKey(), ((AttributeGroup)group.getValue()).toCopyGroup(cloneMap, copies));
            }
        }
        if (this.keyGroups != null) {
            clone2.keyGroups = new HashMap();
            for (Map.Entry group : this.keyGroups.entrySet()) {
                clone2.keyGroups.put(group.getKey(), ((AttributeGroup)group.getValue()).toCopyGroup(cloneMap, copies));
            }
        }
        return clone2;
    }

    public AttributeItem toFetchGroup(Map<AttributeGroup, FetchGroup> cloneMap, FetchGroup parentClone) {
        AttributeItem clone2 = new AttributeItem();
        clone2.attributeName = this.attributeName;
        if (this.group != null) {
            clone2.group = ((AttributeGroup)this.group).toFetchGroup(cloneMap);
        }
        if (clone2.keyGroup != null) {
            clone2.keyGroup = ((AttributeGroup)this.keyGroup).toFetchGroup(cloneMap);
        }
        clone2.parent = parentClone;
        if (this.subGroups != null) {
            clone2.subGroups = new HashMap();
            for (Map.Entry group : this.subGroups.entrySet()) {
                clone2.subGroups.put(group.getKey(), ((AttributeGroup)group.getValue()).toFetchGroup(cloneMap));
            }
        }
        if (this.keyGroups != null) {
            clone2.keyGroups = new HashMap();
            for (Map.Entry group : this.keyGroups.entrySet()) {
                clone2.keyGroups.put(group.getKey(), ((AttributeGroup)group.getValue()).toFetchGroup(cloneMap));
            }
        }
        return clone2;
    }

    public AttributeItem toLoadGroup(Map<AttributeGroup, LoadGroup> cloneMap, LoadGroup parentClone, boolean loadOnly) {
        AttributeItem clone2 = new AttributeItem();
        clone2.attributeName = this.attributeName;
        if (this.group != null) {
            clone2.group = ((AttributeGroup)this.group).toLoadGroup(cloneMap, loadOnly);
        }
        if (clone2.keyGroup != null) {
            clone2.keyGroup = ((AttributeGroup)this.keyGroup).toLoadGroup(cloneMap, loadOnly);
        }
        clone2.parent = parentClone;
        if (this.subGroups != null) {
            clone2.subGroups = new HashMap();
            for (Map.Entry group : this.subGroups.entrySet()) {
                clone2.subGroups.put(group.getKey(), ((AttributeGroup)group.getValue()).toLoadGroup(cloneMap, loadOnly));
            }
        }
        if (this.keyGroups != null) {
            clone2.keyGroups = new HashMap();
            for (Map.Entry group : this.keyGroups.entrySet()) {
                clone2.keyGroups.put(group.getKey(), ((AttributeGroup)group.getValue()).toLoadGroup(cloneMap, loadOnly));
            }
        }
        return clone2;
    }

    @Override
    public AttributeGroup getParent() {
        return (AttributeGroup)super.getParent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        AttributeGroup anotherGroup;
        if (this == obj) return true;
        if (obj == null) {
            return false;
        }
        AttributeItem anotherItem = null;
        try {
            anotherItem = (AttributeItem)obj;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.subGroups != null) {
            if (anotherItem.subGroups == null) {
                return false;
            }
            if (this.subGroups.size() != anotherItem.subGroups.size()) return false;
            for (Map.Entry entry2 : this.subGroups.entrySet()) {
                anotherGroup = (AttributeGroup)anotherItem.subGroups.get(entry2.getKey());
                if (((AttributeGroup)entry2.getValue()).equals(anotherGroup)) continue;
                return false;
            }
        } else if (anotherItem.subGroups != null) {
            return false;
        }
        if (this.keyGroups != null) {
            if (anotherItem.keyGroups == null) {
                return false;
            }
            if (this.keyGroups.size() != anotherItem.keyGroups.size()) return false;
            for (Map.Entry entry2 : this.keyGroups.entrySet()) {
                anotherGroup = (AttributeGroup)anotherItem.keyGroups.get(entry2.getKey());
                if (((AttributeGroup)entry2.getValue()).equals(anotherGroup)) continue;
                return false;
            }
            return true;
        } else {
            if (anotherItem.keyGroups == null) return true;
            return false;
        }
    }

    @Override
    public AttributeGroup getGroup() {
        return (AttributeGroup)super.getGroup();
    }

    public void setGroup(AttributeGroup group) {
        this.group = group;
    }
}

