/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.ForUpdateOfClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class JoinedAttributeManager
implements Cloneable,
Serializable {
    protected transient List<DatabaseMapping> joinedAggregateMappings = new ArrayList<DatabaseMapping>(0);
    protected transient List<DatabaseMapping> joinedAttributeMappings = new ArrayList<DatabaseMapping>(0);
    protected List<Expression> joinedAttributeExpressions;
    protected List<Expression> joinedMappingExpressions;
    protected List<Expression> joinedAttributes;
    protected boolean isToManyJoin = false;
    protected boolean hasOuterJoinedAttribute = true;
    protected transient Map<DatabaseMapping, Object> joinedMappingIndexes;
    protected transient Map<DatabaseMapping, ObjectLevelReadQuery> joinedMappingQueries;
    protected transient Map<DatabaseMapping, ObjectLevelReadQuery> joinedMappingQueryClones;
    protected transient List<AbstractRecord> dataResults;
    protected transient Map<Object, List<AbstractRecord>> dataResultsByPrimaryKey;
    protected transient ClassDescriptor descriptor;
    protected ExpressionBuilder baseExpressionBuilder;
    protected Expression lastJoinedAttributeBaseExpression;
    protected ObjectBuildingQuery baseQuery;
    protected int parentResultIndex;
    protected boolean shouldFilterDuplicates = true;
    protected transient List<Expression> orderByExpressions;
    protected transient List<Expression> additionalFieldExpressions;

    public JoinedAttributeManager() {
    }

    public JoinedAttributeManager(ClassDescriptor descriptor, ExpressionBuilder baseBuilder, ObjectBuildingQuery baseQuery) {
        this.descriptor = descriptor;
        this.baseQuery = baseQuery;
        this.baseExpressionBuilder = baseBuilder;
        this.parentResultIndex = 0;
    }

    public boolean shouldFilterDuplicates() {
        return this.shouldFilterDuplicates;
    }

    public void setShouldFilterDuplicates(boolean shouldFilterDuplicates) {
        this.shouldFilterDuplicates = shouldFilterDuplicates;
    }

    public void addJoinedAttribute(Expression attributeExpression) {
        this.getJoinedAttributes().add(attributeExpression);
    }

    public void addJoinedAttributeExpression(Expression attributeExpression) {
        if (!this.getJoinedAttributeExpressions().contains(attributeExpression)) {
            this.getJoinedAttributeExpressions().add(attributeExpression);
        }
    }

    public void addJoinedMappingExpression(Expression mappingExpression) {
        this.getJoinedMappingExpressions().add(mappingExpression);
    }

    public void addJoinedMapping(String attributeName) {
        this.addJoinedMappingExpression(this.baseExpressionBuilder.get(attributeName));
    }

    public JoinedAttributeManager clone() {
        JoinedAttributeManager joinManager = null;
        try {
            joinManager = (JoinedAttributeManager)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        if (this.joinedAttributeExpressions != null) {
            joinManager.joinedAttributeExpressions = new ArrayList<Expression>(this.joinedAttributeExpressions);
        }
        if (this.joinedMappingExpressions != null) {
            joinManager.joinedMappingExpressions = new ArrayList<Expression>(this.joinedMappingExpressions);
        }
        if (this.joinedAttributes != null) {
            joinManager.joinedAttributes = new ArrayList<Expression>(this.joinedAttributes);
        }
        if (this.joinedMappingIndexes != null) {
            joinManager.joinedMappingIndexes = new HashMap<DatabaseMapping, Object>(this.joinedMappingIndexes);
        }
        if (this.joinedMappingQueries != null) {
            joinManager.joinedMappingQueries = new HashMap<DatabaseMapping, ObjectLevelReadQuery>(this.joinedMappingQueries);
        }
        if (this.orderByExpressions != null) {
            joinManager.orderByExpressions = new ArrayList<Expression>(this.orderByExpressions);
        }
        if (this.additionalFieldExpressions != null) {
            joinManager.additionalFieldExpressions = new ArrayList<Expression>(this.additionalFieldExpressions);
        }
        if (this.joinedAttributeMappings != null) {
            joinManager.joinedAttributeMappings = new ArrayList<DatabaseMapping>(this.joinedAttributeMappings);
        }
        if (this.joinedAggregateMappings != null) {
            joinManager.joinedAggregateMappings = new ArrayList<DatabaseMapping>(this.joinedAggregateMappings);
        }
        return joinManager;
    }

    public void copyFrom(JoinedAttributeManager otherJoinManager) {
        this.joinedAttributeExpressions = otherJoinManager.joinedAttributeExpressions;
        this.joinedMappingExpressions = otherJoinManager.joinedMappingExpressions;
        this.joinedAttributes = otherJoinManager.joinedAttributes;
        this.joinedMappingIndexes = otherJoinManager.joinedMappingIndexes;
        this.joinedMappingQueries = otherJoinManager.joinedMappingQueries;
        this.orderByExpressions = otherJoinManager.orderByExpressions;
        this.additionalFieldExpressions = otherJoinManager.additionalFieldExpressions;
        this.joinedAttributeMappings = otherJoinManager.joinedAttributeMappings;
        this.joinedAggregateMappings = otherJoinManager.joinedAggregateMappings;
    }

    public void clear() {
        this.joinedAttributeExpressions = null;
        this.joinedMappingExpressions = null;
        this.joinedAttributes = null;
        this.joinedMappingIndexes = null;
        this.isToManyJoin = false;
        this.hasOuterJoinedAttribute = false;
        this.joinedMappingQueries = null;
        this.joinedMappingQueryClones = null;
        this.orderByExpressions = null;
        this.additionalFieldExpressions = null;
        this.joinedAttributeMappings = null;
        this.joinedAggregateMappings = null;
    }

    public int computeJoiningMappingIndexes(boolean includeAllSubclassFields, AbstractSession session, int offset2) {
        if (!this.hasJoinedExpressions()) {
            return offset2;
        }
        this.setJoinedMappingIndexes_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
        int fieldIndex = 0;
        if (this.getBaseQuery().hasPartialAttributeExpressions()) {
            fieldIndex = this.getDescriptor().getPrimaryKeyFields().size();
            for (Expression expression : ((ObjectLevelReadQuery)this.getBaseQuery()).getPartialAttributeExpressions()) {
                if (!expression.isQueryKeyExpression() || this.getJoinedMappingExpressions().contains(expression) || this.getJoinedAttributeExpressions().contains(expression)) continue;
                fieldIndex += ((QueryKeyExpression)expression).getFields().size();
            }
        } else {
            fieldIndex = this.getBaseQuery().hasExecutionFetchGroup() ? ((ObjectLevelReadQuery)this.getBaseQuery()).getFetchGroupNonNestedFieldsSet().size() : (includeAllSubclassFields ? this.getDescriptor().getAllSelectionFields((ObjectLevelReadQuery)this.getBaseQuery()).size() : this.getDescriptor().getSelectionFields((ObjectLevelReadQuery)this.getBaseQuery()).size());
        }
        fieldIndex += offset2;
        fieldIndex = this.computeIndexesForJoinedExpressions(this.getJoinedAttributeExpressions(), fieldIndex, session);
        fieldIndex = this.computeIndexesForJoinedExpressions(this.getJoinedMappingExpressions(), fieldIndex, session);
        return fieldIndex;
    }

    protected void computeNestedQueriesForJoinedExpressions(List joinedExpressions, AbstractSession session, ObjectLevelReadQuery readQuery) {
        int index = 0;
        while (index < joinedExpressions.size()) {
            ObjectExpression objectExpression = (ObjectExpression)joinedExpressions.get(index);
            objectExpression.getBuilder().setSession(session.getRootSession(null));
            if (objectExpression.getBuilder().getQueryClass() == null) {
                objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            ObjectExpression baseExpression = this.getFirstNonAggregateExpressionAfterExpressionBuilder(objectExpression, this.getJoinedAggregateMappings());
            this.addJoinedAttribute(baseExpression);
            DatabaseMapping mapping = baseExpression.getMapping();
            this.getJoinedAttributeMappings().add(mapping);
            if (mapping.isForeignReferenceMapping() && !this.getJoinedMappingQueries_().containsKey(mapping)) {
                ObjectLevelReadQuery nestedQuery = ((ForeignReferenceMapping)mapping).prepareNestedJoins(this, readQuery, session);
                if (nestedQuery != null) {
                    this.getJoinedMappingQueries_().put(mapping, nestedQuery);
                }
                if (mapping.isCollectionMapping()) {
                    ((CollectionMapping)mapping).getContainerPolicy().addNestedJoinsQueriesForMapKey(this, readQuery, session);
                }
            }
            ++index;
        }
    }

    public void computeJoiningMappingQueries(AbstractSession session) {
        if (this.hasJoinedExpressions()) {
            this.joinedAttributeMappings = new ArrayList<DatabaseMapping>(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size());
            this.joinedAttributes = new ArrayList<Expression>(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size());
            this.setJoinedMappingQueries_(new HashMap(this.getJoinedAttributeExpressions().size() + this.getJoinedMappingExpressions().size()));
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedAttributeExpressions(), session, (ObjectLevelReadQuery)this.baseQuery);
            this.computeNestedQueriesForJoinedExpressions(this.getJoinedMappingExpressions(), session, (ObjectLevelReadQuery)this.baseQuery);
        }
    }

    protected int computeIndexesForJoinedExpressions(List joinedExpressions, int currentIndex, AbstractSession session) {
        int index = 0;
        while (index < joinedExpressions.size()) {
            ObjectExpression objectExpression = (ObjectExpression)joinedExpressions.get(index);
            DatabaseMapping mapping = objectExpression.getMapping();
            ObjectExpression localExpression = this.getFirstNonAggregateExpressionAfterExpressionBuilder(objectExpression, new ArrayList(1));
            if (localExpression == objectExpression && mapping != null && mapping.isForeignReferenceMapping()) {
                this.getJoinedMappingIndexes_().put(mapping, currentIndex);
            }
            ClassDescriptor descriptor = mapping.getReferenceDescriptor();
            int numberOfFields = 0;
            if (descriptor == null) {
                if (mapping.isDirectCollectionMapping()) {
                    numberOfFields = 1;
                }
            } else {
                ObjectLevelReadQuery nestedQuery = this.getNestedJoinedMappingQuery(objectExpression);
                FetchGroup fetchGroup = null;
                if (descriptor.hasFetchGroupManager()) {
                    fetchGroup = nestedQuery.getExecutionFetchGroup();
                }
                numberOfFields = fetchGroup != null ? nestedQuery.getFetchGroupNonNestedFieldsSet(mapping).size() : (objectExpression.isQueryKeyExpression() && objectExpression.isUsingOuterJoinForMultitableInheritance() ? descriptor.getAllSelectionFields(nestedQuery).size() : descriptor.getSelectionFields(nestedQuery).size());
            }
            if (mapping.isCollectionMapping()) {
                numberOfFields += ((CollectionMapping)mapping).getContainerPolicy().updateJoinedMappingIndexesForMapKey(this.getJoinedMappingIndexes_(), numberOfFields);
            }
            currentIndex += numberOfFields;
            ++index;
        }
        return currentIndex;
    }

    public List<Expression> getAdditionalFieldExpressions() {
        if (this.additionalFieldExpressions == null) {
            this.additionalFieldExpressions = new ArrayList<Expression>();
        }
        return this.additionalFieldExpressions;
    }

    public List<Expression> getAdditionalFieldExpressions_() {
        return this.additionalFieldExpressions;
    }

    public ExpressionBuilder getBaseExpressionBuilder() {
        return this.baseExpressionBuilder;
    }

    public ObjectBuildingQuery getBaseQuery() {
        return this.baseQuery;
    }

    public List<AbstractRecord> getDataResults_() {
        return this.dataResults;
    }

    public ClassDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.baseQuery.getDescriptor();
        }
        return this.descriptor;
    }

    protected ObjectExpression getFirstNonAggregateExpressionAfterExpressionBuilder(ObjectExpression fullExpression, List aggregateMappingsEncountered) {
        boolean done = false;
        ObjectExpression baseExpression = fullExpression;
        ObjectExpression prevExpression = fullExpression;
        while (!baseExpression.getBaseExpression().isExpressionBuilder() && !done) {
            baseExpression = (ObjectExpression)baseExpression.getBaseExpression();
            while (!baseExpression.isExpressionBuilder() && baseExpression.getMapping().isAggregateObjectMapping()) {
                aggregateMappingsEncountered.add(baseExpression.getMapping());
                baseExpression = (ObjectExpression)baseExpression.getBaseExpression();
            }
            if (baseExpression.isExpressionBuilder()) {
                done = true;
                baseExpression = prevExpression;
                continue;
            }
            prevExpression = baseExpression;
        }
        return baseExpression;
    }

    public boolean hasAdditionalFieldExpressions() {
        return this.additionalFieldExpressions != null && !this.additionalFieldExpressions.isEmpty();
    }

    public void setAdditionalFieldExpressions_(List<Expression> expressions) {
        this.additionalFieldExpressions = expressions;
    }

    public List<DatabaseMapping> getJoinedAggregateMappings() {
        if (this.joinedAggregateMappings == null) {
            this.joinedAggregateMappings = new ArrayList<DatabaseMapping>();
        }
        return this.joinedAggregateMappings;
    }

    public List<Expression> getJoinedAttributeExpressions() {
        if (this.joinedAttributeExpressions == null) {
            this.joinedAttributeExpressions = new ArrayList<Expression>();
        }
        return this.joinedAttributeExpressions;
    }

    public List<DatabaseMapping> getJoinedAttributeMappings() {
        if (this.joinedAttributeMappings == null) {
            this.joinedAttributeMappings = new ArrayList<DatabaseMapping>();
        }
        return this.joinedAttributeMappings;
    }

    public List<Expression> getJoinedAttributes() {
        if (this.joinedAttributes == null) {
            this.joinedAttributes = new ArrayList<Expression>();
        }
        return this.joinedAttributes;
    }

    public List<Expression> getJoinedMappingExpressions() {
        if (this.joinedMappingExpressions == null) {
            this.joinedMappingExpressions = new ArrayList<Expression>();
        }
        return this.joinedMappingExpressions;
    }

    public boolean hasJoinedAttributeExpressions() {
        return this.joinedAttributeExpressions != null && !this.joinedAttributeExpressions.isEmpty();
    }

    public boolean hasJoinedExpressions() {
        return this.hasJoinedAttributeExpressions() || this.hasJoinedMappingExpressions();
    }

    public boolean hasJoinedMappingExpressions() {
        return this.joinedMappingExpressions != null && !this.joinedMappingExpressions.isEmpty();
    }

    public boolean hasJoinedAttributes() {
        return this.joinedAttributes != null && !this.joinedAttributes.isEmpty();
    }

    public boolean hasOuterJoinedAttributeQuery() {
        return this.hasOuterJoinedAttribute;
    }

    public List<Expression> getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<Expression>();
        }
        return this.orderByExpressions;
    }

    public List<Expression> getOrderByExpressions_() {
        return this.orderByExpressions;
    }

    public Object getValueFromObjectForExpression(AbstractSession session, Object clone2, ObjectExpression expression) {
        if (!expression.isExpressionBuilder()) {
            Object baseValue = this.getValueFromObjectForExpression(session, clone2, (ObjectExpression)expression.getBaseExpression());
            if (baseValue == null) {
                return null;
            }
            DatabaseMapping mapping = expression.getMapping();
            Object attributeValue = mapping.getRealAttributeValueFromObject(baseValue, session);
            if (attributeValue != null && mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).getIndirectionPolicy().usesTransparentIndirection()) {
                ((ForeignReferenceMapping)mapping).getIndirectionPolicy().instantiateObject(baseValue, attributeValue);
            }
            return attributeValue;
        }
        return clone2;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null && !this.orderByExpressions.isEmpty();
    }

    public void setOrderByExpressions_(List<Expression> expressions) {
        this.orderByExpressions = expressions;
    }

    public boolean isToManyJoin() {
        return this.isToManyJoin;
    }

    public boolean isAttributeJoined(ClassDescriptor mappingDescriptor, DatabaseMapping attributeMapping) {
        if (this.hasJoinedAttributes()) {
            if (attributeMapping.isAggregateMapping()) {
                return this.getJoinedAggregateMappings().contains(attributeMapping);
            }
            return this.getJoinedAttributeMappings().contains(attributeMapping);
        }
        return this.isAttributeExpressionJoined(attributeMapping) || this.isAttributeMappingJoined(attributeMapping);
    }

    protected boolean isMappingInJoinedExpressionList(DatabaseMapping attributeMapping, List joinedExpressionList) {
        Iterator joinEnum = joinedExpressionList.iterator();
        while (joinEnum.hasNext()) {
            ArrayList aggregateMappings = new ArrayList();
            ObjectExpression expression = this.getFirstNonAggregateExpressionAfterExpressionBuilder((ObjectExpression)joinEnum.next(), aggregateMappings);
            if (attributeMapping.isAggregateObjectMapping() && aggregateMappings.contains(attributeMapping)) {
                return true;
            }
            if (!attributeMapping.equals(expression.getMapping())) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributeNameInJoinedExpressionList(String attributeName, List joinedExpressionList) {
        for (QueryKeyExpression expression : joinedExpressionList) {
            while (!expression.getBaseExpression().isExpressionBuilder()) {
                expression = (QueryKeyExpression)expression.getBaseExpression();
            }
            if (!expression.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAttributeExpressionJoined(DatabaseMapping attributeMapping) {
        return this.isMappingInJoinedExpressionList(attributeMapping, this.getJoinedAttributeExpressions());
    }

    protected boolean isAttributeMappingJoined(DatabaseMapping attributeMapping) {
        return this.isAttributeNameInJoinedExpressionList(attributeMapping.getAttributeName(), this.getJoinedMappingExpressions());
    }

    public void setJoinedAttributeExpressions_(List joinedExpressions) {
        this.joinedAttributeExpressions = joinedExpressions;
    }

    public void setJoinedMappingExpressions_(List joinedMappingExpressions) {
        this.joinedMappingExpressions = joinedMappingExpressions;
    }

    public Map<DatabaseMapping, Object> getJoinedMappingIndexes_() {
        return this.joinedMappingIndexes;
    }

    public Map<DatabaseMapping, ObjectLevelReadQuery> getJoinedMappingQueries_() {
        return this.joinedMappingQueries;
    }

    public ObjectLevelReadQuery getNestedJoinedMappingQuery(Expression expression) {
        ObjectExpression currentExpression = (ObjectExpression)expression;
        ArrayList<ObjectExpression> expressionBaseList = new ArrayList<ObjectExpression>();
        do {
            if (currentExpression.getMapping().isAggregateObjectMapping()) continue;
            expressionBaseList.add(currentExpression);
        } while (!(currentExpression = (ObjectExpression)currentExpression.getBaseExpression()).isExpressionBuilder());
        DatabaseMapping currentMapping = ((QueryKeyExpression)expressionBaseList.get(expressionBaseList.size() - 1)).getMapping();
        ObjectLevelReadQuery nestedQuery = this.getJoinedMappingQueries_().get(currentMapping);
        int i = expressionBaseList.size() - 2;
        while (i >= 0) {
            currentMapping = ((QueryKeyExpression)expressionBaseList.get(i)).getMapping();
            nestedQuery = nestedQuery.getJoinedAttributeManager().getJoinedMappingQueries_().get(currentMapping);
            --i;
        }
        return nestedQuery;
    }

    public void setJoinedMappingQueries_(Map joinedMappingQueries) {
        this.joinedMappingQueries = joinedMappingQueries;
    }

    public void setJoinedMappingIndexes_(Map joinedMappingIndexes) {
        this.joinedMappingIndexes = joinedMappingIndexes;
    }

    protected void setIsOuterJoinedAttributeQuery(boolean isOuterJoinedAttribute) {
        this.hasOuterJoinedAttribute = isOuterJoinedAttribute;
    }

    public void setIsToManyJoinQuery(boolean isToManyJoin) {
        this.isToManyJoin = isToManyJoin;
    }

    public void prepareJoinExpressions(AbstractSession session) {
        Expression expression;
        this.setIsOuterJoinedAttributeQuery(false);
        Expression lastJoinedAttributeBaseExpression = null;
        ArrayList groupedExpressionList = new ArrayList(this.getJoinedAttributeExpressions().size());
        int index = 0;
        while (index < this.getJoinedAttributeExpressions().size()) {
            expression = this.getJoinedAttributeExpressions().get(index);
            expression = this.prepareJoinExpression(expression, session);
            lastJoinedAttributeBaseExpression = this.addExpressionAndBaseToGroupedList(expression, groupedExpressionList, lastJoinedAttributeBaseExpression);
            ++index;
        }
        this.setJoinedAttributeExpressions_(groupedExpressionList);
        index = 0;
        while (index < this.getJoinedMappingExpressions().size()) {
            expression = this.getJoinedMappingExpressions().get(index);
            expression = this.prepareJoinExpression(expression, session);
            this.getJoinedMappingExpressions().set(index, expression);
            ++index;
        }
    }

    protected Expression addExpressionAndBaseToGroupedList(Expression expression, List expressionlist, Expression lastJoinedAttributeBaseExpression) {
        if (!expressionlist.contains(expression)) {
            int baseExpressionIndex = -1;
            boolean sameBase = false;
            if (expression.isObjectExpression()) {
                Expression baseExpression = ((BaseExpression)expression).getBaseExpression();
                while (!baseExpression.isExpressionBuilder() && ((QueryKeyExpression)baseExpression).getMapping().isAggregateMapping()) {
                    baseExpression = ((BaseExpression)baseExpression).getBaseExpression();
                }
                if (baseExpression != null && !baseExpression.isExpressionBuilder()) {
                    this.addExpressionAndBaseToGroupedList(baseExpression, expressionlist, lastJoinedAttributeBaseExpression);
                    if (baseExpression != lastJoinedAttributeBaseExpression) {
                        baseExpressionIndex = this.getJoinedAttributeExpressions().indexOf(baseExpression);
                    } else {
                        sameBase = true;
                    }
                }
            }
            if (baseExpressionIndex == -1) {
                expressionlist.add(expression);
                if (!sameBase) {
                    lastJoinedAttributeBaseExpression = expression;
                }
            } else {
                expressionlist.add(baseExpressionIndex + 1, expression);
            }
        }
        return lastJoinedAttributeBaseExpression;
    }

    protected Expression prepareJoinExpression(Expression expression, AbstractSession session) {
        if (!expression.isQueryKeyExpression()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(expression);
        }
        QueryKeyExpression objectExpression = (QueryKeyExpression)expression;
        if (objectExpression.getBuilder().getQueryClass() == null && (objectExpression = (QueryKeyExpression)objectExpression.rebuildOn(this.baseExpressionBuilder)).getBuilder().getQueryClass() == null) {
            objectExpression.getBuilder().setQueryClass(this.descriptor.getJavaClass());
        }
        objectExpression.getBuilder().setSession(session.getRootSession(null));
        if (objectExpression.getMapping() == null || !objectExpression.getMapping().isJoiningSupported()) {
            throw QueryException.mappingForExpressionDoesNotSupportJoining(objectExpression);
        }
        ObjectExpression baseExpression = objectExpression;
        while (!baseExpression.isExpressionBuilder()) {
            baseExpression.setShouldUseOuterJoinForMultitableInheritance(true);
            if (baseExpression.shouldQueryToManyRelationship()) {
                this.setIsToManyJoinQuery(true);
            }
            if (baseExpression.shouldUseOuterJoin()) {
                this.setIsOuterJoinedAttributeQuery(true);
            }
            baseExpression = (ObjectExpression)baseExpression.getBaseExpression();
        }
        return objectExpression;
    }

    public void processJoinedMappings(AbstractSession session) {
        block7: {
            ObjectBuilder objectBuilder;
            Set<String> fetchGroupAttributes = null;
            FetchGroup fetchGroup = this.getBaseQuery().getExecutionFetchGroup();
            if (fetchGroup != null) {
                fetchGroupAttributes = fetchGroup.getAttributeNames();
            }
            if (!(objectBuilder = this.getDescriptor().getObjectBuilder()).hasJoinedAttributes()) break block7;
            List<DatabaseMapping> mappingJoinedAttributes = objectBuilder.getJoinedAttributes();
            if (!this.hasJoinedAttributeExpressions()) {
                int i = 0;
                while (i < mappingJoinedAttributes.size()) {
                    ForeignReferenceMapping mapping = (ForeignReferenceMapping)mappingJoinedAttributes.get(i);
                    if (fetchGroupAttributes == null || fetchGroupAttributes.contains(mapping.getAttributeName())) {
                        this.addAndPrepareJoinedMapping(mapping, session);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < mappingJoinedAttributes.size()) {
                    ForeignReferenceMapping mapping = (ForeignReferenceMapping)mappingJoinedAttributes.get(i);
                    if (!this.isAttributeExpressionJoined(mapping) && (fetchGroupAttributes == null || fetchGroupAttributes.contains(mapping.getAttributeName()))) {
                        this.addAndPrepareJoinedMapping(mapping, session);
                    }
                    ++i;
                }
            }
        }
    }

    public Expression addAndPrepareJoinedMapping(ForeignReferenceMapping mapping, AbstractSession session) {
        Expression joinMappingExpression = null;
        if (mapping.isCollectionMapping()) {
            if (mapping.isInnerJoinFetched()) {
                joinMappingExpression = this.getBaseExpressionBuilder().anyOf(mapping.getAttributeName(), false);
            } else if (mapping.isOuterJoinFetched()) {
                joinMappingExpression = this.getBaseExpressionBuilder().anyOfAllowingNone(mapping.getAttributeName(), false);
            }
        } else if (mapping.isInnerJoinFetched()) {
            joinMappingExpression = this.getBaseExpressionBuilder().get(mapping.getAttributeName());
        } else if (mapping.isOuterJoinFetched()) {
            joinMappingExpression = this.getBaseExpressionBuilder().getAllowingNull(mapping.getAttributeName());
        }
        if (joinMappingExpression != null) {
            joinMappingExpression = this.prepareJoinExpression(joinMappingExpression, session);
            this.addJoinedMappingExpression(joinMappingExpression);
        }
        return joinMappingExpression;
    }

    public void reset() {
        this.joinedMappingExpressions = null;
        this.joinedAttributes = null;
        this.isToManyJoin = false;
        this.hasOuterJoinedAttribute = true;
        this.joinedMappingIndexes = null;
        this.joinedMappingQueries = null;
        this.dataResults = null;
        this.joinedAttributeMappings = null;
        this.joinedAggregateMappings = null;
    }

    public void setBaseQuery(ObjectLevelReadQuery query) {
        this.baseQuery = query;
    }

    protected void setBaseExpressionBuilder(ExpressionBuilder builder) {
        this.baseExpressionBuilder = builder;
    }

    public Map<Object, List<AbstractRecord>> getDataResultsByPrimaryKey() {
        return this.dataResultsByPrimaryKey;
    }

    protected void setDataResultsByPrimaryKey(Map<Object, List<AbstractRecord>> dataResultsByPrimaryKey) {
        this.dataResultsByPrimaryKey = dataResultsByPrimaryKey;
    }

    public void setDataResults(List dataResults, AbstractSession session) {
        this.dataResults = dataResults;
        this.processDataResults(session);
    }

    protected void processDataResults(AbstractSession session) {
        this.dataResultsByPrimaryKey = new HashMap<Object, List<AbstractRecord>>();
        int size2 = this.dataResults.size();
        Object firstKey = null;
        Object lastKey = null;
        List<AbstractRecord> childRows = null;
        ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
        int parentIndex = this.getParentResultIndex();
        NonSynchronizedSubVector trimedFields = null;
        int dataResultsIndex = 0;
        while (dataResultsIndex < size2) {
            Object sourceKey;
            AbstractRecord row;
            AbstractRecord parentRow = row = this.dataResults.get(dataResultsIndex);
            if (parentIndex > 0) {
                if (trimedFields == null) {
                    trimedFields = new NonSynchronizedSubVector(row.getFields(), parentIndex, row.size());
                }
                NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(row.getValues(), parentIndex, row.size());
                parentRow = new DatabaseRecord(trimedFields, trimedValues);
            }
            if ((sourceKey = builder.extractPrimaryKeyFromRow(parentRow, session)) != null) {
                if (firstKey == null) {
                    firstKey = sourceKey;
                }
                if (lastKey != null && lastKey.equals(sourceKey)) {
                    childRows.add(row);
                    if (this.shouldFilterDuplicates()) {
                        this.dataResults.set(dataResultsIndex, null);
                    }
                } else {
                    childRows = this.dataResultsByPrimaryKey.get(sourceKey);
                    if (childRows == null) {
                        childRows = new ArrayList<AbstractRecord>();
                        this.dataResultsByPrimaryKey.put(sourceKey, childRows);
                    } else if (this.shouldFilterDuplicates()) {
                        this.dataResults.set(dataResultsIndex, null);
                    }
                    childRows.add(row);
                    lastKey = sourceKey;
                }
            }
            ++dataResultsIndex;
        }
        if (this.isToManyJoin) {
            if (lastKey != null && this.baseQuery.getMaxRows() > 0) {
                this.dataResultsByPrimaryKey.remove(lastKey);
            }
            if (firstKey != null && this.baseQuery.getFirstResult() > 0) {
                this.dataResultsByPrimaryKey.remove(firstKey);
            }
        }
    }

    public void clearDataResults() {
        this.dataResults = null;
        this.dataResultsByPrimaryKey = null;
    }

    public AbstractRecord processDataResults(AbstractRecord row, Cursor cursor, boolean forward) {
        AbstractRecord extraRow;
        Object sourceKey;
        ArrayList<AbstractRecord> childRows;
        block4: {
            AbstractRecord nextRow;
            if (this.dataResultsByPrimaryKey == null) {
                this.dataResultsByPrimaryKey = new HashMap<Object, List<AbstractRecord>>();
            }
            AbstractRecord parentRow = row;
            childRows = new ArrayList<AbstractRecord>();
            childRows.add(row);
            int parentIndex = this.getParentResultIndex();
            NonSynchronizedSubVector trimedFields = new NonSynchronizedSubVector(row.getFields(), parentIndex, row.size());
            if (parentIndex > 0) {
                NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(row.getValues(), parentIndex, row.size());
                parentRow = new DatabaseRecord(trimedFields, trimedValues);
            }
            ObjectBuilder builder = this.getDescriptor().getObjectBuilder();
            AbstractSession session = cursor.getExecutionSession();
            sourceKey = builder.extractPrimaryKeyFromRow(parentRow, session);
            extraRow = null;
            while (true) {
                nextRow = null;
                nextRow = forward ? cursor.getAccessor().cursorRetrieveNextRow(cursor.getFields(), cursor.getResultSet(), session) : cursor.getAccessor().cursorRetrievePreviousRow(cursor.getFields(), cursor.getResultSet(), session);
                if (nextRow == null) break block4;
                AbstractRecord nextParentRow = nextRow;
                if (parentIndex > 0) {
                    NonSynchronizedSubVector trimedValues = new NonSynchronizedSubVector(nextParentRow.getValues(), parentIndex, nextParentRow.size());
                    nextParentRow = new DatabaseRecord(trimedFields, trimedValues);
                }
                Object nextKey = builder.extractPrimaryKeyFromRow(nextParentRow, session);
                if (sourceKey == null || !sourceKey.equals(nextKey)) break;
                childRows.add(nextRow);
            }
            extraRow = nextRow;
        }
        this.dataResultsByPrimaryKey.put(sourceKey, childRows);
        return extraRow;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ForUpdateOfClause setupLockingClauseForJoinedExpressions(ForUpdateOfClause lockingClause, AbstractSession session) {
        if (this.hasJoinedAttributeExpressions()) {
            return this.setupLockingClauseForJoinedExpressions(this.getJoinedAttributeExpressions(), session, lockingClause);
        }
        if (this.hasJoinedMappingExpressions()) {
            return this.setupLockingClauseForJoinedExpressions(this.getJoinedMappingExpressions(), session, lockingClause);
        }
        return lockingClause;
    }

    private ForUpdateOfClause setupLockingClauseForJoinedExpressions(List joinedExpressions, AbstractSession session, ForUpdateOfClause lockingClause) {
        for (Expression expression : joinedExpressions) {
            ClassDescriptor nestedDescriptor;
            if (!expression.isObjectExpression()) continue;
            ObjectExpression joinedAttribute = (ObjectExpression)expression;
            joinedAttribute.getBuilder().setSession(session.getRootSession(null));
            if (joinedAttribute.getBuilder().getQueryClass() == null) {
                joinedAttribute.getBuilder().setQueryClass(this.descriptor.getJavaClass());
            }
            if ((nestedDescriptor = joinedAttribute.getDescriptor()) == null) {
                return lockingClause;
            }
            if (!nestedDescriptor.hasPessimisticLockingPolicy()) continue;
            if (lockingClause == null) {
                lockingClause = new ForUpdateOfClause();
                lockingClause.setLockMode(nestedDescriptor.getCMPPolicy().getPessimisticLockingPolicy().getLockingMode());
            }
            lockingClause.addLockedExpression(joinedAttribute);
        }
        return lockingClause;
    }

    public void setParentResultIndex(int parentsResultIndex) {
        this.parentResultIndex = parentsResultIndex;
    }

    public int getParentResultIndex() {
        return this.parentResultIndex;
    }

    public Map<DatabaseMapping, ObjectLevelReadQuery> getJoinedMappingQueryClones() {
        return this.joinedMappingQueryClones;
    }

    public void setJoinedMappingQueryClones(Map joinedMappingQueryClones) {
        this.joinedMappingQueryClones = joinedMappingQueryClones;
    }
}

