/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.DescriptorCompare;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitOrderCalculator;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class CommitManager {
    protected List<Class> commitOrder;
    protected Map<Object, Integer> commitState;
    protected static final Integer PRE = 1;
    protected static final Integer POST = 2;
    protected static final Integer COMPLETE = 3;
    protected static final Integer IGNORE = 4;
    protected Map shallowCommits;
    protected AbstractSession session;
    protected boolean isActive;
    protected Map<DatabaseMapping, List<Object[]>> dataModifications;
    protected Map<DatabaseTable, List<Object[]>> deferredCalls;
    protected List objectsToDelete;
    protected int commitDepth;

    public CommitManager(AbstractSession session) {
        this.session = session;
    }

    public void addDataModificationEvent(DatabaseMapping mapping, Object[] event) {
        if (!this.getDataModifications().containsKey(mapping)) {
            this.dataModifications.put(mapping, new ArrayList());
        }
        this.dataModifications.get(mapping).add(event);
    }

    public void addDeferredCall(DatabaseTable table, DatasourceCall call, DatabaseQueryMechanism mechanism) {
        if (!this.getDeferredCalls().containsKey(table)) {
            this.deferredCalls.put(table, new ArrayList());
        }
        Object[] arguments = new Object[]{call, mechanism};
        this.deferredCalls.get(table).add(arguments);
    }

    public void addObjectToDelete(Object objectToDelete) {
        this.getObjectsToDelete().add(objectToDelete);
    }

    public void commitAllObjectsWithChangeSet(UnitOfWorkChangeSet uowChangeSet) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.reinitialize();
        this.isActive = true;
        this.session.beginTransaction();
        try {
            try {
                if (uowChangeSet.getObjectChanges().size() + uowChangeSet.getNewObjectChangeSets().size() <= 1) {
                    Class theClass;
                    Iterator<Class> classes = uowChangeSet.getNewObjectChangeSets().keySet().iterator();
                    if (classes.hasNext()) {
                        theClass = classes.next();
                        this.commitNewObjectsForClassWithChangeSet(uowChangeSet, theClass);
                    }
                    if ((classes = uowChangeSet.getObjectChanges().keySet().iterator()).hasNext()) {
                        theClass = classes.next();
                        this.commitChangedObjectsForClassWithChangeSet(uowChangeSet, theClass);
                    }
                } else {
                    List<Class> commitOrder = this.getCommitOrder();
                    int size2 = commitOrder.size();
                    int index = 0;
                    while (index < size2) {
                        Class theClass = commitOrder.get(index);
                        this.commitAllObjectsForClassWithChangeSet(uowChangeSet, theClass);
                        ++index;
                    }
                }
                if (this.hasDeferredCalls()) {
                    for (List<Object[]> calls : this.deferredCalls.values()) {
                        for (Object[] argument : calls) {
                            ((DatabaseQueryMechanism)argument[1]).executeDeferredCall((DatasourceCall)argument[0]);
                        }
                    }
                }
                if (this.hasDataModifications()) {
                    for (Map.Entry<DatabaseMapping, List<Object[]>> entry2 : this.dataModifications.entrySet()) {
                        List<Object[]> events2 = entry2.getValue();
                        int size3 = events2.size();
                        DatabaseMapping mapping = entry2.getKey();
                        int index = 0;
                        while (index < size3) {
                            Object[] event = events2.get(index);
                            mapping.performDataModificationEvent(event, this.getSession());
                            ++index;
                        }
                    }
                }
                if (this.hasObjectsToDelete()) {
                    List objects = this.getObjectsToDelete();
                    int size4 = objects.size();
                    this.reinitialize();
                    int index = 0;
                    while (index < size4) {
                        this.session.deleteObject(objects.get(index));
                        ++index;
                    }
                }
                this.session.commitTransaction();
            }
            catch (RuntimeException exception) {
                this.session.rollbackTransaction();
                throw exception;
            }
        }
        finally {
            this.reinitialize();
            this.isActive = false;
        }
    }

    protected void commitAllObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class theClass) {
        this.commitChangedObjectsForClassWithChangeSet(uowChangeSet, theClass);
        this.commitNewObjectsForClassWithChangeSet(uowChangeSet, theClass);
    }

    protected void commitNewObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class theClass) {
        Map<ObjectChangeSet, ObjectChangeSet> newObjectChangesList = uowChangeSet.getNewObjectChangeSets().get(theClass);
        if (newObjectChangesList != null) {
            AbstractSession session = this.getSession();
            ClassDescriptor descriptor = session.getDescriptor(theClass);
            ArrayList<ObjectChangeSet> newChangeSets = new ArrayList<ObjectChangeSet>(newObjectChangesList.values());
            int size2 = newChangeSets.size();
            int index = 0;
            while (index < size2) {
                ObjectChangeSet changeSetToWrite = (ObjectChangeSet)newChangeSets.get(index);
                Object objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                if (!this.isProcessedCommit(objectToWrite)) {
                    InsertObjectQuery commitQuery = descriptor.getQueryManager().getInsertQuery();
                    if (commitQuery == null) {
                        commitQuery = new InsertObjectQuery();
                        commitQuery.setDescriptor(descriptor);
                    } else {
                        commitQuery.checkPrepare(session, commitQuery.getTranslationRow());
                        commitQuery = (InsertObjectQuery)commitQuery.clone();
                    }
                    commitQuery.setIsExecutionClone(true);
                    commitQuery.setObjectChangeSet(changeSetToWrite);
                    commitQuery.setObject(objectToWrite);
                    commitQuery.cascadeOnlyDependentParts();
                    commitQuery.setModifyRow(null);
                    session.executeQuery(commitQuery);
                }
                uowChangeSet.putNewObjectInChangesList(changeSetToWrite, session);
                ++index;
            }
        }
    }

    protected void commitChangedObjectsForClassWithChangeSet(UnitOfWorkChangeSet uowChangeSet, Class theClass) {
        Map<ObjectChangeSet, ObjectChangeSet> objectChangesList = uowChangeSet.getObjectChanges().get(theClass);
        if (objectChangesList != null) {
            ClassDescriptor descriptor = null;
            AbstractSession session = this.getSession();
            Collection<ObjectChangeSet> changes = objectChangesList.values();
            if (((UnitOfWorkImpl)session).shouldOrderUpdates()) {
                changes = new ArrayList<ObjectChangeSet>(objectChangesList.values());
                Collections.sort((List)changes);
            }
            for (ObjectChangeSet changeSetToWrite : changes) {
                Object objectToWrite = changeSetToWrite.getUnitOfWorkClone();
                if (descriptor == null) {
                    descriptor = session.getDescriptor(objectToWrite);
                }
                if (this.isProcessedCommit(objectToWrite)) continue;
                WriteObjectQuery commitQuery = null;
                commitQuery = changeSetToWrite.isNew() ? new InsertObjectQuery() : new UpdateObjectQuery();
                commitQuery.setIsExecutionClone(true);
                commitQuery.setDescriptor(descriptor);
                commitQuery.setObjectChangeSet(changeSetToWrite);
                commitQuery.setObject(objectToWrite);
                commitQuery.cascadeOnlyDependentParts();
                session.executeQuery(commitQuery);
            }
        }
    }

    public void deleteAllObjects(List objects) throws RuntimeException, DatabaseException, OptimisticLockException {
        this.isActive = true;
        AbstractSession session = this.getSession();
        session.beginTransaction();
        try {
            try {
                if (objects.size() == 1) {
                    this.deleteAllObjects(objects.get(0).getClass(), objects, session);
                } else {
                    List<Class> commitOrder = this.getCommitOrder();
                    int orderIndex = commitOrder.size() - 1;
                    while (orderIndex >= 0) {
                        Class theClass = commitOrder.get(orderIndex);
                        this.deleteAllObjects(theClass, objects, session);
                        --orderIndex;
                    }
                }
                session.commitTransaction();
            }
            catch (RuntimeException exception) {
                try {
                    session.rollbackTransaction();
                }
                catch (Exception exception2) {}
                throw exception;
            }
        }
        finally {
            this.reinitialize();
            this.isActive = false;
        }
    }

    public void deleteAllObjects(Class theClass, List objects, AbstractSession session) {
        ClassDescriptor descriptor = null;
        if (((UnitOfWorkImpl)session).shouldOrderUpdates()) {
            objects = this.sort(theClass, objects);
        }
        int size2 = objects.size();
        int index = 0;
        while (index < size2) {
            Object objectToDelete = objects.get(index);
            if (objectToDelete.getClass() == theClass) {
                DeleteObjectQuery deleteQuery;
                if (descriptor == null) {
                    descriptor = session.getDescriptor(theClass);
                }
                if ((deleteQuery = descriptor.getQueryManager().getDeleteQuery()) == null) {
                    deleteQuery = new DeleteObjectQuery();
                    deleteQuery.setDescriptor(descriptor);
                } else {
                    deleteQuery.checkPrepare(session, deleteQuery.getTranslationRow());
                    deleteQuery = (DeleteObjectQuery)deleteQuery.clone();
                }
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(objectToDelete);
                session.executeQuery(deleteQuery);
            }
            ++index;
        }
    }

    private List sort(Class theClass, List objects) {
        ClassDescriptor descriptor = this.session.getDescriptor(theClass);
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        int size2 = objects.size();
        TreeMap sortedObjects = new TreeMap();
        int index = 0;
        while (index < size2) {
            Object objectToDelete = objects.get(index);
            if (objectToDelete.getClass() == theClass) {
                sortedObjects.put(objectBuilder.extractPrimaryKeyFromObject(objectToDelete, this.session), objectToDelete);
            }
            ++index;
        }
        return new ArrayList(sortedObjects.values());
    }

    public List<Class> getCommitOrder() {
        if (this.commitOrder == null) {
            this.commitOrder = new ArrayList<Class>();
        }
        return this.commitOrder;
    }

    protected Map<Object, Integer> getCommitState() {
        if (this.commitState == null) {
            this.commitState = new IdentityHashMap<Object, Integer>();
        }
        return this.commitState;
    }

    protected boolean hasDataModifications() {
        return this.dataModifications != null && !this.dataModifications.isEmpty();
    }

    protected Map<DatabaseMapping, List<Object[]>> getDataModifications() {
        if (this.dataModifications == null) {
            this.dataModifications = new LinkedHashMap<DatabaseMapping, List<Object[]>>();
        }
        return this.dataModifications;
    }

    protected boolean hasDeferredCalls() {
        return this.deferredCalls != null && !this.deferredCalls.isEmpty();
    }

    protected Map<DatabaseTable, List<Object[]>> getDeferredCalls() {
        if (this.deferredCalls == null) {
            this.deferredCalls = new LinkedHashMap<DatabaseTable, List<Object[]>>();
        }
        return this.deferredCalls;
    }

    protected boolean hasObjectsToDelete() {
        return this.objectsToDelete != null && !this.objectsToDelete.isEmpty();
    }

    public List getObjectsToDelete() {
        if (this.objectsToDelete == null) {
            this.objectsToDelete = new ArrayList();
        }
        return this.objectsToDelete;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected Map getShallowCommits() {
        if (this.shallowCommits == null) {
            this.shallowCommits = new IdentityHashMap();
        }
        return this.shallowCommits;
    }

    public void initializeCommitOrder() {
        Vector descriptors = Helper.buildVectorFromMapElements(this.getSession().getDescriptors());
        descriptors = Helper.addAllUniqueToVector(new Vector(descriptors.size()), descriptors);
        Object[] descriptorsArray = new Object[descriptors.size()];
        int index = 0;
        while (index < descriptors.size()) {
            descriptorsArray[index] = descriptors.elementAt(index);
            ++index;
        }
        Arrays.sort(descriptorsArray, new DescriptorCompare());
        descriptors = new Vector(descriptors.size());
        index = 0;
        while (index < descriptorsArray.length) {
            descriptors.addElement(descriptorsArray[index]);
            ++index;
        }
        CommitOrderCalculator calculator = new CommitOrderCalculator(this.getSession());
        calculator.addNodes(descriptors);
        calculator.calculateMappingDependencies();
        calculator.orderCommits();
        descriptors = calculator.getOrderedDescriptors();
        calculator = new CommitOrderCalculator(this.getSession());
        calculator.addNodes(descriptors);
        calculator.calculateSpecifiedDependencies();
        calculator.orderCommits();
        this.setCommitOrder(calculator.getOrderedClasses());
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isProcessedCommit(Object object) {
        return this.getCommitState().get(object) != null;
    }

    public boolean isCommitCompleted(Object object) {
        return this.getCommitState().get(object) == COMPLETE;
    }

    public boolean isCommitCompletedInPostOrIgnore(Object object) {
        Integer state = this.getCommitState().get(object);
        return state == COMPLETE || state == POST || state == IGNORE;
    }

    public boolean isCommitInPostModify(Object object) {
        return this.getCommitState().get(object) == POST;
    }

    public boolean isCommitInPreModify(Object objectOrChangeSet) {
        return this.getCommitState().get(objectOrChangeSet) == PRE;
    }

    public boolean isShallowCommitted(Object object) {
        if (this.shallowCommits == null) {
            return false;
        }
        return this.shallowCommits.containsKey(object);
    }

    public void markCommitCompleted(Object object) {
        --this.commitDepth;
        this.getCommitState().put(object, COMPLETE);
        if (!this.isActive && this.commitDepth == 0) {
            this.reinitialize();
            return;
        }
    }

    public void markIgnoreCommit(Object object) {
        this.getCommitState().put(object, IGNORE);
    }

    public void markPostModifyCommitInProgress(Object object) {
        this.getCommitState().put(object, POST);
    }

    public void markPreModifyCommitInProgress(Object object) {
        ++this.commitDepth;
        this.getCommitState().put(object, PRE);
    }

    public void markShallowCommit(Object object) {
        this.getShallowCommits().put(object, object);
    }

    public void reinitialize() {
        this.commitState = null;
        this.commitDepth = 0;
        this.shallowCommits = null;
        this.objectsToDelete = null;
        this.dataModifications = null;
        this.deferredCalls = null;
    }

    public void setCommitOrder(List commitOrder) {
        this.commitOrder = commitOrder;
    }

    protected void setDataModifications(Map<DatabaseMapping, List<Object[]>> dataModifications) {
        this.dataModifications = dataModifications;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    protected void setObjectsToDelete(List objectsToDelete) {
        this.objectsToDelete = objectsToDelete;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    protected void setShallowCommits(Map shallowCommits) {
        this.shallowCommits = shallowCommits;
    }

    public String toString() {
        Object[] args = new Object[]{this.commitDepth};
        return String.valueOf(Helper.getShortClassName(this.getClass())) + ToStringLocalization.buildMessage("commit_depth", args);
    }
}

