/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination;

import org.eclipse.persistence.sessions.coordination.ServiceId;

public class ServiceAnnouncement {
    ServiceId serviceId;

    public ServiceAnnouncement(byte[] bytes2) {
        this.readFromBytes(bytes2);
    }

    public ServiceAnnouncement(ServiceId newServiceId) {
        this.serviceId = newServiceId;
    }

    public void readFromBytes(byte[] bytes2) {
        this.serviceId = new ServiceId();
        int curPos = 0;
        byte channelLength = bytes2[curPos];
        this.serviceId.setChannel(new String(bytes2, ++curPos, (int)channelLength));
        byte idLength = bytes2[curPos += channelLength];
        this.serviceId.setId(new String(bytes2, ++curPos, (int)idLength));
        byte urlLength = bytes2[curPos += idLength];
        ++curPos;
        if (urlLength > 0) {
            this.serviceId.setURL(new String(bytes2, curPos, (int)urlLength));
        }
    }

    public byte[] toBytes() {
        int curPos = 0;
        byte[] channelBytes = this.serviceId.getChannel().getBytes();
        int channelLength = channelBytes.length;
        byte[] idBytes = this.serviceId.getId().getBytes();
        int idLength = idBytes.length;
        byte[] urlBytes = null;
        int urlLength = 0;
        if (this.serviceId.getURL() == null) {
            urlBytes = new byte[]{};
        } else {
            urlBytes = this.serviceId.getURL().getBytes();
            urlLength = urlBytes.length;
        }
        byte[] bytes2 = new byte[channelLength + idLength + urlLength + 3];
        bytes2[curPos] = (byte)channelLength;
        System.arraycopy(channelBytes, 0, bytes2, ++curPos, channelLength);
        bytes2[curPos += channelLength] = (byte)idLength;
        System.arraycopy(idBytes, 0, bytes2, ++curPos, idLength);
        bytes2[curPos += idLength] = (byte)urlLength;
        System.arraycopy(urlBytes, 0, bytes2, ++curPos, urlLength);
        return bytes2;
    }

    public ServiceId getServiceId() {
        return this.serviceId;
    }
}

