/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.CustomObjectInputStream;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class SerializedObjectConverter
implements Converter {
    protected DatabaseMapping mapping;

    public SerializedObjectConverter() {
    }

    public SerializedObjectConverter(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session) throws DescriptorException {
        byte[] bytes2;
        if (fieldValue == null) {
            return null;
        }
        try {
            bytes2 = (byte[])((AbstractSession)session).getDatasourcePlatform().convertObject(fieldValue, ClassConstants.APBYTE);
        }
        catch (ConversionException e) {
            throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), e);
        }
        if (bytes2 == null || bytes2.length == 0) {
            return null;
        }
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes2);
        Object object = null;
        try {
            CustomObjectInputStream objectIn = new CustomObjectInputStream(byteIn, session);
            object = objectIn.readObject();
        }
        catch (Exception exception) {
            throw DescriptorException.notDeserializable(this.getMapping(), exception);
        }
        return object;
    }

    @Override
    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        if (attributeValue == null) {
            return null;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(attributeValue);
            objectOut.flush();
        }
        catch (IOException exception) {
            throw DescriptorException.notSerializable(this.getMapping(), exception);
        }
        return byteOut.toByteArray();
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        AbstractDirectMapping directMapping;
        this.mapping = mapping;
        if (this.getMapping().isDirectToFieldMapping() && (directMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            directMapping.setFieldClassification(ClassConstants.APBYTE);
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

