/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodBasedFieldTransformation;
import org.eclipse.persistence.internal.descriptors.TransformerBasedFieldTransformation;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.DatabaseValueHolder;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.TransformationMappingChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.mappings.transformers.MethodBasedAttributeTransformer;
import org.eclipse.persistence.mappings.transformers.MethodBasedFieldTransformer;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public abstract class AbstractTransformationMapping
extends DatabaseMapping {
    protected String attributeTransformerClassName;
    protected AttributeTransformer attributeTransformer;
    protected List<FieldTransformation> fieldTransformations = new ArrayList<FieldTransformation>();
    protected List<Object[]> fieldToTransformers = new ArrayList<Object[]>();
    protected boolean isMutable;
    protected IndirectionPolicy indirectionPolicy;

    public AbstractTransformationMapping() {
        this.setIsMutable(true);
        this.dontUseIndirection();
        this.setWeight(WEIGHT_TRANSFORM);
    }

    public void addFieldTransformation(DatabaseField field2, String methodName) {
        MethodBasedFieldTransformation transformation = new MethodBasedFieldTransformation();
        transformation.setField(field2);
        transformation.setMethodName(methodName);
        this.getFieldTransformations().add(transformation);
    }

    public void addFieldTransformation(String fieldName, String methodName) {
        this.addFieldTransformation(new DatabaseField(fieldName), methodName);
    }

    public void addFieldTransformerClassName(String fieldName, String className) {
        this.addFieldTransformerClassName(new DatabaseField(fieldName), className);
    }

    public void addFieldTransformerClassName(DatabaseField field2, String className) {
        TransformerBasedFieldTransformation transformation = new TransformerBasedFieldTransformation();
        transformation.setField(field2);
        transformation.setTransformerClassName(className);
        this.getFieldTransformations().add(transformation);
    }

    public void addFieldTransformer(String fieldName, FieldTransformer transformer) {
        this.addFieldTransformer(new DatabaseField(fieldName), transformer);
    }

    public void addFieldTransformer(DatabaseField field2, FieldTransformer transformer) {
        TransformerBasedFieldTransformation transformation = new TransformerBasedFieldTransformation(transformer);
        transformation.setField(field2);
        this.getFieldTransformations().add(transformation);
    }

    protected boolean areObjectsToBeProcessedInstantiated(Object object) {
        return this.indirectionPolicy.objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    @Override
    public void buildBackupClone(Object clone2, Object backup, UnitOfWorkImpl unitOfWork) {
        if (this.isWriteOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(clone2);
        Object clonedAttributeValue = this.indirectionPolicy.backupCloneAttribute(attributeValue, clone2, backup, unitOfWork);
        this.setAttributeValueInObject(backup, clonedAttributeValue);
    }

    protected AbstractRecord buildPhantomRowFrom(Object domainObject, AbstractSession session) {
        DatabaseRecord row = new DatabaseRecord(this.fieldToTransformers.size());
        for (Object[] pair : this.fieldToTransformers) {
            DatabaseField field2 = (DatabaseField)pair[0];
            FieldTransformer transformer = (FieldTransformer)pair[1];
            Object fieldValue = this.invokeFieldTransformer(field2, transformer, domainObject, session);
            row.put(field2, fieldValue);
        }
        return row;
    }

    @Override
    public void buildShallowOriginalFromRow(AbstractRecord record2, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)query.getSession();
        query.setSession(unitOfWork.getParent());
        try {
            this.readFromRowIntoObject(record2, joinManager, original, null, query, executionSession, false);
        }
        finally {
            query.setSession(unitOfWork);
        }
    }

    @Override
    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone2, Object backup, UnitOfWorkImpl unitOfWork) {
        return this.buildCloneForPartObject(attributeValue, clone2, null, backup, unitOfWork, null, true, true);
    }

    @Override
    public void buildClone(Object original, CacheKey cacheKey, Object clone2, Integer refreshCascade, AbstractSession cloningSession) {
        if (this.isWriteOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(original);
        Object clonedAttributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, original, cacheKey, clone2, refreshCascade, cloningSession, false);
        this.setAttributeValueInObject(clone2, clonedAttributeValue);
    }

    @Override
    public void buildCloneFromRow(AbstractRecord record2, JoinedAttributeManager joinManager, Object clone2, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        if (this.isWriteOnly()) {
            return;
        }
        Object attributeValue = this.readFromRowIntoObject(record2, joinManager, clone2, sharedCacheKey, sourceQuery, executionSession, true);
        if (this.usesIndirection()) {
            boolean wasCacheUsed;
            boolean bl = wasCacheUsed = this.isCacheable && sharedCacheKey != null && this.descriptor.getCachePolicy().isProtectedIsolation() && sharedCacheKey.getObject() != null;
            if (!wasCacheUsed) {
                attributeValue = this.indirectionPolicy.cloneAttribute(attributeValue, null, null, clone2, null, unitOfWork, true);
            }
            this.setAttributeValueInObject(clone2, attributeValue);
        }
    }

    @Override
    public Object buildCloneForPartObject(Object attributeValue, Object original, CacheKey cacheKey, Object clone2, AbstractSession cloningSession, Integer refreshCascade, boolean isExisting, boolean isFromSharedCache) {
        if (this.isReadOnly() || !this.isMutable()) {
            return attributeValue;
        }
        AbstractRecord row = this.buildPhantomRowFrom(original, cloningSession);
        return this.invokeAttributeTransformer(row, clone2, cloningSession);
    }

    @Override
    public void buildCopy(Object copy2, Object original, CopyGroup group) {
        Object clonedAttributeValue;
        if (this.isWriteOnly()) {
            return;
        }
        if (this.isReadOnly() || !this.isMutable()) {
            clonedAttributeValue = this.getRealAttributeValueFromObject(original, group.getSession());
        } else {
            AbstractRecord row = this.buildPhantomRowFrom(original, group.getSession());
            clonedAttributeValue = this.invokeAttributeTransformer(row, copy2, group.getSession());
        }
        this.indirectionPolicy.reset(copy2);
        this.setRealAttributeValueInObject(copy2, clonedAttributeValue);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public Object clone() {
        AbstractTransformationMapping clone2 = (AbstractTransformationMapping)super.clone();
        clone2.setFieldToTransformers(new ArrayList<Object[]>(this.fieldToTransformers.size()));
        for (Object[] pair : this.fieldToTransformers) {
            Object[] transformation = new Object[]{pair[0], pair[1]};
            clone2.getFieldToTransformers().add(transformation);
        }
        clone2.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        return clone2;
    }

    protected Vector collectFields() {
        Vector<Object> databaseFields = new Vector<Object>(this.fieldToTransformers.size());
        for (Object[] pair : this.fieldToTransformers) {
            databaseFields.add(pair[0]);
        }
        return databaseFields;
    }

    @Override
    public ChangeRecord compareForChange(Object clone2, Object backUp, ObjectChangeSet owner2, AbstractSession session) {
        if (this.isReadOnly() || this.isWriteOnly()) {
            return null;
        }
        Object cloneAttribute = this.getAttributeValueFromObject(clone2);
        Object backUpAttribute = null;
        if (cloneAttribute != null && !this.indirectionPolicy.objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        boolean difference = false;
        Object backupValue = null;
        if (owner2.isNew()) {
            difference = true;
        } else {
            if (backUp != null) {
                backUpAttribute = this.getAttributeValueFromObject(backUp);
                backupValue = this.indirectionPolicy.getRealAttributeValueFromObject(backUp, backUpAttribute);
            }
            boolean backUpIsInstantiated = backUpAttribute == null || this.indirectionPolicy.objectIsInstantiated(backUpAttribute);
            Object cloneValue = this.indirectionPolicy.getRealAttributeValueFromObject(clone2, cloneAttribute);
            if (backUpIsInstantiated) {
                if (cloneValue == backupValue) {
                    return null;
                }
                if (cloneValue != null && backupValue != null && cloneValue.equals(backupValue)) {
                    return null;
                }
            }
            for (Object[] pair : this.fieldToTransformers) {
                DatabaseField field2 = (DatabaseField)pair[0];
                FieldTransformer transformer = (FieldTransformer)pair[1];
                Object cloneFieldValue = null;
                Object backUpFieldValue = null;
                if (clone2 != null) {
                    cloneFieldValue = this.invokeFieldTransformer(field2, transformer, clone2, session);
                }
                if (backUpIsInstantiated && backUp != null) {
                    backUpFieldValue = this.invokeFieldTransformer(field2, transformer, backUp, session);
                }
                if (cloneFieldValue == backUpFieldValue) continue;
                if (cloneFieldValue == null || backUpFieldValue == null) {
                    difference = true;
                    break;
                }
                if (cloneFieldValue.equals(backUpFieldValue) || Helper.comparePotentialArrays(cloneFieldValue, backUpFieldValue)) continue;
                difference = true;
                break;
            }
        }
        if (difference) {
            return this.internalBuildChangeRecord(clone2, backupValue, owner2, session);
        }
        return null;
    }

    @Override
    public ChangeRecord buildChangeRecord(Object clone2, ObjectChangeSet owner2, AbstractSession session) {
        return this.internalBuildChangeRecord(clone2, null, owner2, session);
    }

    public ChangeRecord internalBuildChangeRecord(Object clone2, Object oldValue, ObjectChangeSet owner2, AbstractSession session) {
        TransformationMappingChangeRecord changeRecord = new TransformationMappingChangeRecord(owner2);
        changeRecord.setRow(this.buildPhantomRowFrom(clone2, session));
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.setOldValue(oldValue);
        return changeRecord;
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        if (!this.isWriteOnly()) {
            Object secondValue;
            Object firstValue = this.getRealAttributeValueFromObject(firstObject, session);
            if (firstValue == (secondValue = this.getRealAttributeValueFromObject(secondObject, session))) {
                return true;
            }
            if (firstValue == null || secondValue == null) {
                return false;
            }
            if (firstValue.equals(secondValue)) {
                return true;
            }
        }
        for (Object[] pair : this.fieldToTransformers) {
            Object secondFieldValue;
            FieldTransformer transformer;
            DatabaseField field2 = (DatabaseField)pair[0];
            Object firstFieldValue = this.invokeFieldTransformer(field2, transformer = (FieldTransformer)pair[1], firstObject, session);
            if (firstFieldValue == (secondFieldValue = this.invokeFieldTransformer(field2, transformer, secondObject, session))) continue;
            if (firstFieldValue == null || secondFieldValue == null) {
                return false;
            }
            if (firstFieldValue.equals(secondFieldValue) || Helper.comparePotentialArrays(firstFieldValue, secondFieldValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.attributeTransformerClassName != null) {
            Class attributeTransformerClass;
            block13: {
                attributeTransformerClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            attributeTransformerClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.attributeTransformerClassName, true, classLoader));
                            break block13;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeTransformerClassName, exception.getException());
                        }
                    }
                    attributeTransformerClass = PrivilegedAccessHelper.getClassForName(this.attributeTransformerClassName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeTransformerClassName, exc);
                }
            }
            this.setAttributeTransformerClass(attributeTransformerClass);
        }
        for (FieldTransformation transformation : this.getFieldTransformations()) {
            Class transformerClass;
            TransformerBasedFieldTransformation transformer;
            block14: {
                if (!(transformation instanceof TransformerBasedFieldTransformation)) continue;
                transformer = (TransformerBasedFieldTransformation)transformation;
                String transformerClassName = transformer.getTransformerClassName();
                if (transformerClassName == null) {
                    return;
                }
                transformerClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            transformerClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(transformerClassName, true, classLoader));
                            break block14;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(transformerClassName, exception.getException());
                        }
                    }
                    transformerClass = PrivilegedAccessHelper.getClassForName(transformerClassName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(transformerClassName, exc);
                }
            }
            transformer.setTransformerClass(transformerClass);
        }
    }

    @Override
    public DatabaseValueHolder createCloneValueHolder(ValueHolderInterface attributeValue, Object original, Object clone2, AbstractRecord row, AbstractSession cloningSession, boolean buildDirectlyFromRow) {
        return cloningSession.createCloneTransformationValueHolder(attributeValue, original, clone2, this);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, DistributedSession session) {
        this.indirectionPolicy.fixObjectReferences(object, objectDescriptors, processedObjects, query, session);
    }

    public AttributeTransformer getAttributeTransformer() {
        return this.attributeTransformer;
    }

    public String getAttributeMethodName() {
        if (this.attributeTransformer instanceof MethodBasedAttributeTransformer) {
            return ((MethodBasedAttributeTransformer)this.attributeTransformer).getMethodName();
        }
        return null;
    }

    public Class getAttributeTransformerClass() {
        if (this.attributeTransformer == null || this.attributeTransformer instanceof MethodBasedAttributeTransformer) {
            return null;
        }
        return this.attributeTransformer.getClass();
    }

    public void setAttributeTransformerClass(Class attributeTransformerClass) {
        if (attributeTransformerClass == null) {
            return;
        }
        try {
            Object instance = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    instance = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeTransformerClass));
                }
                catch (PrivilegedActionException ex) {
                    throw (Exception)ex.getCause();
                }
            } else {
                instance = PrivilegedAccessHelper.newInstanceFromClass(attributeTransformerClass);
            }
            this.setAttributeTransformer((AttributeTransformer)instance);
        }
        catch (Exception exception) {
            throw DescriptorException.attributeTransformerClassInvalid(attributeTransformerClass.getName(), this, exception);
        }
    }

    public String getAttributeTransformerClassName() {
        return this.attributeTransformerClassName;
    }

    @Override
    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        if (this.isWriteOnly()) {
            return null;
        }
        Object attributeValue = super.getAttributeValueFromObject(object);
        return this.indirectionPolicy.validateAttributeOfInstantiatedObject(attributeValue);
    }

    public List<FieldTransformation> getFieldTransformations() {
        return this.fieldTransformations;
    }

    public List<Object[]> getFieldToTransformers() {
        return this.fieldToTransformers;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    @Override
    public Object getRealAttributeValueFromAttribute(Object attributeValue, Object object, AbstractSession session) {
        return this.indirectionPolicy.getRealAttributeValueFromObject(object, attributeValue);
    }

    @Override
    public void instantiateAttribute(Object object, AbstractSession session) {
        this.indirectionPolicy.instantiateObject(object, this.getAttributeValueFromObject(object));
    }

    @Override
    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.indirectionPolicy.getValueFromRemoteValueHolder(remoteValueHolder);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.initializeAttributeTransformer(session);
        this.initializeFieldToTransformers(session);
        this.setFields(this.collectFields());
        this.indirectionPolicy.initialize();
        if (this.usesIndirection()) {
            for (DatabaseField field2 : this.fields) {
                field2.setKeepInRow(true);
            }
        }
    }

    protected void initializeAttributeTransformer(AbstractSession databaseSession) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        this.attributeTransformer.initialize(this);
    }

    public Hashtable getFieldNameToMethodNames() {
        Hashtable<String, String> table = new Hashtable<String, String>(this.getFieldTransformations().size());
        for (FieldTransformation transformation : this.getFieldTransformations()) {
            if (!(transformation instanceof MethodBasedFieldTransformation)) continue;
            table.put(transformation.getField().getQualifiedName(), ((MethodBasedFieldTransformation)transformation).getMethodName());
        }
        return table;
    }

    protected void initializeFieldToTransformers(AbstractSession session) throws DescriptorException {
        for (Object[] pair : this.fieldToTransformers) {
            pair[0] = this.getDescriptor().buildField((DatabaseField)pair[0]);
            ((FieldTransformer)pair[1]).initialize(this);
        }
        for (FieldTransformation transformation : this.getFieldTransformations()) {
            DatabaseField field2 = this.getDescriptor().buildField(transformation.getField());
            String transformerClassName = "MethodBasedFieldTransformer";
            FieldTransformer transformer = null;
            try {
                transformer = transformation.buildTransformer();
            }
            catch (ConversionException ex) {
                if (transformation instanceof TransformerBasedFieldTransformation) {
                    transformerClassName = ((TransformerBasedFieldTransformation)transformation).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassNotFound(transformerClassName, this, ex);
            }
            catch (Exception ex) {
                if (transformation instanceof TransformerBasedFieldTransformation) {
                    transformerClassName = ((TransformerBasedFieldTransformation)transformation).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassInvalid(transformerClassName, this, ex);
            }
            transformer.initialize(this);
            if (field2.getType() == null) {
                if (transformer instanceof MethodBasedFieldTransformer) {
                    field2.setType(((MethodBasedFieldTransformer)transformer).getFieldType());
                } else if (field2.getColumnDefinition() != null && session.getDatasourcePlatform() instanceof DatabasePlatform) {
                    for (Map.Entry<Class, FieldTypeDefinition> entry2 : session.getPlatform().getFieldTypes().entrySet()) {
                        if (!entry2.getValue().getName().equals(field2.getColumnDefinition())) continue;
                        field2.setType(entry2.getKey());
                        break;
                    }
                }
            }
            Object[] fieldToTransformer = new Object[]{field2, transformer};
            this.fieldToTransformers.add(fieldToTransformer);
        }
    }

    public Object invokeAttributeTransformer(AbstractRecord record2, Object domainObject, AbstractSession session) throws DescriptorException {
        return this.attributeTransformer.buildAttributeValue(record2, domainObject, session);
    }

    protected Object invokeFieldTransformer(DatabaseField field2, FieldTransformer transformer, Object domainObject, AbstractSession session) throws DescriptorException {
        return transformer.buildFieldValue(domainObject, field2.getName(), session);
    }

    protected Object invokeFieldTransformer(DatabaseField field2, Object domainObject, AbstractSession session) {
        for (Object[] pair : this.fieldToTransformers) {
            if (!field2.equals(pair[0])) continue;
            return this.invokeFieldTransformer(field2, (FieldTransformer)pair[1], domainObject, session);
        }
        return null;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        return this.getFieldTransformations().isEmpty() && this.fieldToTransformers.isEmpty();
    }

    @Override
    public boolean isTransformationMapping() {
        return true;
    }

    @Override
    public boolean isWriteOnly() {
        return this.getAttributeName() == null && this.attributeTransformer == null && this.attributeTransformerClassName == null;
    }

    @Override
    public void iterate(DescriptorIterator iterator2) {
        Object attributeValue = this.getAttributeValueFromObject(iterator2.getVisitedParent());
        this.indirectionPolicy.iterateOnAttributeValue(iterator2, attributeValue);
    }

    @Override
    public void iterateOnRealAttributeValue(DescriptorIterator iterator2, Object realAttributeValue) {
        iterator2.iteratePrimitiveForMapping(realAttributeValue, this);
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.isWriteOnly()) {
            return;
        }
        if (!this.isMutable() && source != null) {
            this.setRealAttributeValueInObject(target, this.getRealAttributeValueFromObject(source, mergeManager.getSession()));
            return;
        }
        AbstractRecord record2 = (AbstractRecord)((TransformationMappingChangeRecord)changeRecord).getRecord();
        Object attributeValue = this.invokeAttributeTransformer(record2, target, targetSession);
        this.setRealAttributeValueInObject(target, attributeValue);
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.isWriteOnly()) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.indirectionPolicy.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.isForRefresh() ? !this.areObjectsToBeProcessedInstantiated(target) : !this.areObjectsToBeProcessedInstantiated(source)) {
            return;
        }
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.areObjectsToBeProcessedInstantiated(source)) {
            this.setAttributeValueInObject(target, this.indirectionPolicy.getOriginalIndirectionObject(this.getAttributeValueFromObject(source), targetSession));
            return;
        }
        if (this.isReadOnly()) {
            this.setRealAttributeValueInObject(target, this.getRealAttributeValueFromObject(source, mergeManager.getSession()));
            return;
        }
        if (!this.isMutable()) {
            Object attribute = this.getRealAttributeValueFromObject(source, mergeManager.getSession());
            if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
                Object targetAttribute = this.getRealAttributeValueFromObject(target, mergeManager.getSession());
                if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && !mergeManager.isForRefresh() && (targetAttribute == null && attribute != null || targetAttribute != null && (attribute == null || !targetAttribute.equals(attribute) && !Helper.comparePotentialArrays(targetAttribute, attribute)))) {
                    this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), targetAttribute, attribute);
                }
            }
            this.setRealAttributeValueInObject(target, attribute);
            return;
        }
        AbstractRecord row = this.buildPhantomRowFrom(source, mergeManager.getSession());
        Object attributeValue = this.invokeAttributeTransformer(row, source, mergeManager.getSession());
        AbstractRecord targetRow = this.buildPhantomRowFrom(target, mergeManager.getSession());
        this.setRealAttributeValueInObject(target, attributeValue);
        if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Enumeration keys = targetRow.keys();
            while (keys.hasMoreElements()) {
                Object field2 = keys.nextElement();
                if (!mergeManager.shouldMergeCloneIntoWorkingCopy() && !mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy() || row.get(field2).equals(targetRow.get(field2))) continue;
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), this.invokeAttributeTransformer(targetRow, source, mergeManager.getSession()), attributeValue);
                break;
            }
        }
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.preInitialize(session);
        if (this.getAttributeClassification() != null && (this.getAttributeClassification().isPrimitive() || Helper.isPrimitiveWrapper(this.getAttributeClassification()) || this.getAttributeClassification().equals(ClassConstants.STRING) || this.getAttributeClassification().equals(ClassConstants.BIGDECIMAL) || this.getAttributeClassification().equals(ClassConstants.NUMBER))) {
            this.setIsMutable(false);
        }
    }

    public Object readFromReturnRowIntoObject(AbstractRecord row, Object object, ReadObjectQuery query, Collection handledMappings, ObjectChangeSet changeSet) throws DatabaseException {
        int size2 = this.fields.size();
        DatabaseRecord transformationRow = new DatabaseRecord(size2);
        int i = 0;
        while (i < size2) {
            DatabaseField field2 = (DatabaseField)this.fields.get(i);
            Object value2 = row.containsKey(field2) ? row.get(field2) : this.valueFromObject(object, field2, query.getSession());
            transformationRow.add(field2, value2);
            ++i;
        }
        if (changeSet != null && (!changeSet.isNew() || query.getDescriptor() != null && query.getDescriptor().shouldUseFullChangeSetsForNewObjects())) {
            TransformationMappingChangeRecord record2 = (TransformationMappingChangeRecord)changeSet.getChangesForAttributeNamed(this.attributeName);
            if (record2 == null) {
                record2 = new TransformationMappingChangeRecord(changeSet);
                record2.setAttribute(this.attributeName);
                record2.setMapping(this);
                record2.setOldValue(this.getAttributeValueFromObject(object));
                changeSet.addChange(record2);
            }
            record2.setRow(transformationRow);
        }
        Object attributeValue = this.readFromRowIntoObject(transformationRow, null, object, null, query, query.getSession(), true);
        if (handledMappings != null) {
            handledMappings.add(this);
        }
        return attributeValue;
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord row, JoinedAttributeManager joinManager, Object object, CacheKey parentCacheKey, ObjectBuildingQuery query, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        if (this.isWriteOnly()) {
            return null;
        }
        if (this.descriptor.getCachePolicy().isProtectedIsolation() && this.isCacheable && isTargetProtected && parentCacheKey != null) {
            Object cached = parentCacheKey.getObject();
            if (cached != null) {
                Object attributeValue = this.getAttributeValueFromObject(cached);
                Integer refreshCascade = null;
                if (query != null && query.shouldRefreshIdentityMapResult()) {
                    refreshCascade = query.getCascadePolicy();
                }
                return this.indirectionPolicy.cloneAttribute(attributeValue, cached, parentCacheKey, object, refreshCascade, executionSession, false);
            }
            return null;
        }
        if (row != null && row.hasSopObject()) {
            return this.getAttributeValueFromObject(row.getSopObject());
        }
        Object attributeValue = this.indirectionPolicy.valueFromMethod(object, row, query.getSession());
        Object oldAttribute = null;
        if (executionSession.isUnitOfWork() && query.shouldRefreshIdentityMapResult()) {
            oldAttribute = this.getAttributeValueFromObject(object);
        }
        try {
            this.attributeAccessor.setAttributeValueInObject(object, attributeValue);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
        if (executionSession.isUnitOfWork() && query.shouldRefreshIdentityMapResult() && this.indirectionPolicy.objectIsInstantiatedOrChanged(oldAttribute)) {
            this.indirectionPolicy.instantiateObject(object, attributeValue);
        }
        return attributeValue;
    }

    public Vector getFieldNameToMethodNameAssociations() {
        Vector<Association> associations = new Vector<Association>();
        for (FieldTransformation tf : this.getFieldTransformations()) {
            if (!(tf instanceof MethodBasedFieldTransformation)) continue;
            Association ass = new Association();
            ass.setKey(tf.getField().getQualifiedName());
            ass.setValue(((MethodBasedFieldTransformation)tf).getMethodName());
            associations.addElement(ass);
        }
        return associations;
    }

    public void setFieldNameToMethodNameAssociations(Vector associations) {
        this.setFieldTransformations(NonSynchronizedVector.newInstance(associations.size()));
        for (Association ass : associations) {
            MethodBasedFieldTransformation tf = new MethodBasedFieldTransformation();
            tf.setField(new DatabaseField((String)ass.getKey()));
            tf.setMethodName((String)ass.getValue());
            this.getFieldTransformations().add(tf);
        }
    }

    @Override
    public void remoteInitialization(DistributedSession session) {
        this.setFieldToTransformers(new Vector<Object[]>());
        if (!this.isWriteOnly()) {
            super.remoteInitialization(session);
            this.initializeAttributeTransformer(session);
        }
        this.initializeFieldToTransformers(session);
    }

    public void setAttributeTransformer(AttributeTransformer transformer) {
        this.attributeTransformer = transformer;
        if (transformer != null && !(transformer instanceof MethodBasedAttributeTransformer)) {
            this.attributeTransformerClassName = transformer.getClass().getName();
        }
    }

    public void setAttributeTransformerClassName(String className) {
        this.attributeTransformerClassName = className;
    }

    public void setAttributeTransformation(String methodName) {
        if (methodName != null && methodName != "") {
            this.setAttributeTransformer(new MethodBasedAttributeTransformer(methodName));
        } else {
            this.setAttributeTransformer(null);
        }
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value2) {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value2);
    }

    public void setIsMutable(boolean mutable) {
        this.isMutable = mutable;
    }

    @Override
    public void setRealAttributeValueInObject(Object object, Object value2) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        this.indirectionPolicy.setRealAttributeValueInObject(object, value2);
    }

    public void setFieldTransformations(List<FieldTransformation> fieldTransformations) {
        this.fieldTransformations = fieldTransformations;
    }

    protected void setFieldToTransformers(List<Object[]> fieldToTransformers) {
        this.fieldToTransformers = fieldToTransformers;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setUsesIndirection(boolean usesIndirection) {
        if (usesIndirection) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    @Override
    public void updateChangeRecord(Object clone2, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        TransformationMappingChangeRecord changeRecord = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        Object updatedObject = this.descriptor.getInstantiationPolicy().buildNewInstance();
        this.setAttributeValueInObject(updatedObject, newValue);
        if (!this.isWriteOnly()) {
            if (changeRecord == null) {
                objectChangeSet.addChange(this.internalBuildChangeRecord(updatedObject, oldValue, objectChangeSet, uow));
            } else {
                changeRecord.setRow(this.buildPhantomRowFrom(updatedObject, uow));
            }
        }
    }

    @Override
    public boolean isChangeTrackingSupported(Project project) {
        return !this.isMutable();
    }

    @Override
    public boolean isAttributeValueFromObjectInstantiated(Object object) {
        return this.indirectionPolicy.objectIsInstantiated(object);
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useContainerIndirection(Class containerClass) {
        ContainerIndirectionPolicy policy = new ContainerIndirectionPolicy();
        policy.setContainerClass(containerClass);
        this.setIndirectionPolicy(policy);
    }

    public void useIndirection() {
        this.useBasicIndirection();
    }

    public boolean usesIndirection() {
        return this.indirectionPolicy.usesIndirection();
    }

    @Override
    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        if (this.isWriteOnly()) {
            return;
        }
        if (this.attributeTransformer == null && this.attributeTransformerClassName == null) {
            session.getIntegrityChecker().handleError(DescriptorException.noAttributeTransformationMethod(this));
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.indirectionPolicy.validateDeclaredAttributeType(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.indirectionPolicy.validateGetMethodReturnType(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.indirectionPolicy.validateSetMethodParameterType(parameterType, session.getIntegrityChecker());
        }
    }

    @Override
    public Object valueFromObject(Object object, DatabaseField field2, AbstractSession session) {
        return this.invokeFieldTransformer(field2, object, session);
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        for (Object[] pair : this.fieldToTransformers) {
            DatabaseField field2 = (DatabaseField)pair[0];
            FieldTransformer transformer = (FieldTransformer)pair[1];
            Object fieldValue = this.invokeFieldTransformer(field2, transformer, object, session);
            row.put(field2, fieldValue);
        }
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        for (Object[] pair : this.fieldToTransformers) {
            DatabaseField field2 = (DatabaseField)pair[0];
            Object fieldValue = ((TransformationMappingChangeRecord)changeRecord).getRecord().get(field2);
            row.put(field2, fieldValue);
        }
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord record2) {
        if (!this.areObjectsToBeProcessedInstantiated(query.getObject())) {
            return;
        }
        if (query.getSession().isUnitOfWork() && this.compareObjects(query.getBackupClone(), query.getObject(), query.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(query.getObject(), record2, query.getSession(), DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord record2, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        for (Object[] pair : this.fieldToTransformers) {
            DatabaseField field2 = (DatabaseField)pair[0];
            record2.put(field2, (Object)null);
        }
    }
}

