/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.sequenced;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class Setting {
    private String name;
    private String namespaceURI;
    private Object value;
    private Object object;
    private DatabaseMapping mapping;
    private Setting parent;
    private List<Setting> children;

    public Setting() {
    }

    public Setting(String namespaceURI, String name) {
        this.setNamespaceURI(namespaceURI);
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value2) {
        this.setValue(value2, true);
    }

    public void setValue(Object value2, boolean updateObject) {
        this.value = value2;
        if (updateObject) {
            if (this.children != null) {
                return;
            }
            if (!this.mapping.isWriteOnly()) {
                this.mapping.setAttributeValueInObject(this.object, value2);
            }
        }
    }

    public void addValue(Object value2, boolean updateObject, Object container) {
        this.value = value2;
        if (updateObject) {
            if (this.children != null) {
                return;
            }
            ContainerMapping containerMapping = (ContainerMapping)((Object)this.mapping);
            ContainerPolicy containerPolicy = containerMapping.getContainerPolicy();
            if (container == null && !this.mapping.isWriteOnly()) {
                container = containerPolicy.containerInstance();
                this.mapping.setAttributeValueInObject(this.object, container);
            }
            containerMapping.getContainerPolicy().addInto(value2, container, (AbstractSession)null);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void addChild(Setting childSetting) {
        childSetting.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList<Setting>();
        }
        this.children.add(childSetting);
    }

    public Setting getParent() {
        return this.parent;
    }

    public void setParent(Setting parentSetting) {
        this.parent = parentSetting;
    }

    public List<Setting> getChildren() {
        return this.children;
    }

    public Setting copy() {
        Setting copy2 = new Setting();
        copy2.setName(this.name);
        copy2.setNamespaceURI(this.namespaceURI);
        copy2.setObject(this.object);
        copy2.setMapping(this.mapping);
        copy2.setValue(this.value, false);
        if (this.children != null) {
            int index = 0;
            int size2 = this.children.size();
            while (index < size2) {
                copy2.addChild(this.children.get(index).copy());
                ++index;
            }
        }
        return copy2;
    }

    public Setting copy(Object newParent) {
        Setting copy2 = new Setting();
        copy2.setName(this.name);
        copy2.setNamespaceURI(this.namespaceURI);
        if (this.getObject() != null) {
            copy2.setObject(newParent);
        }
        copy2.setMapping(this.mapping);
        copy2.setValue(this.value, false);
        if (this.children != null) {
            int index = 0;
            int size2 = this.children.size();
            while (index < size2) {
                copy2.addChild(this.children.get(index).copy(newParent));
                ++index;
            }
        }
        return copy2;
    }

    public Setting copy(Object newParent, Object copyValue) {
        Setting copy2 = new Setting();
        copy2.setName(this.name);
        copy2.setNamespaceURI(this.namespaceURI);
        if (this.getObject() != null) {
            copy2.setObject(newParent);
        }
        copy2.setMapping(this.mapping);
        copy2.setValue(copyValue, false);
        if (this.children != null) {
            int index = 0;
            int size2 = this.children.size();
            while (index < size2) {
                copy2.addChild(this.children.get(index).copy(newParent, copyValue));
                ++index;
            }
        }
        return copy2;
    }
}

