/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLComparer {
    private boolean ignoreOrder = false;

    public boolean isNodeEqual(Node control, Node test) {
        if (control == test) {
            return true;
        }
        if (control == null || test == null) {
            return false;
        }
        if (control.getNodeType() != test.getNodeType()) {
            return false;
        }
        switch (control.getNodeType()) {
            case 2: {
                return this.isAttributeEqual((Attr)control, (Attr)test);
            }
            case 4: {
                return this.isTextEqual((Text)control, (Text)test);
            }
            case 8: {
                return this.isCommentEqual((Comment)control, (Comment)test);
            }
            case 11: {
                return this.isDocumentFragmentEqual((DocumentFragment)control, (DocumentFragment)test);
            }
            case 9: {
                return this.isDocumentEqual((Document)control, (Document)test);
            }
            case 10: {
                return this.isDocumentTypeEqual((DocumentType)control, (DocumentType)test);
            }
            case 1: {
                return this.isElementEqual((Element)control, (Element)test);
            }
            case 6: {
                return false;
            }
            case 5: {
                return this.isEntityReferenceEqual((EntityReference)control, (EntityReference)test);
            }
            case 12: {
                return false;
            }
            case 7: {
                return this.isProcessingInstructionEqual((ProcessingInstruction)control, (ProcessingInstruction)test);
            }
            case 3: {
                return this.isTextEqual((Text)control, (Text)test);
            }
        }
        return true;
    }

    protected boolean isAttributeEqual(Attr control, Attr test) {
        if (!this.isStringEqual(control.getNamespaceURI(), test.getNamespaceURI())) {
            return false;
        }
        if (!this.isStringEqual(control.getName(), test.getName())) {
            return false;
        }
        return this.isStringEqual(control.getNodeValue(), test.getNodeValue());
    }

    private boolean isCommentEqual(Comment control, Comment test) {
        return this.isStringEqual(control.getNodeValue(), test.getNodeValue());
    }

    private boolean isDocumentEqual(Document control, Document test) {
        Element testRootElement;
        if (!this.isDocumentTypeEqual(control.getDoctype(), test.getDoctype())) {
            return false;
        }
        Element controlRootElement = control.getDocumentElement();
        if (controlRootElement == (testRootElement = test.getDocumentElement())) {
            return true;
        }
        if (controlRootElement == null || testRootElement == null) {
            return false;
        }
        return this.isElementEqual(controlRootElement, testRootElement);
    }

    private boolean isDocumentFragmentEqual(DocumentFragment control, DocumentFragment test) {
        return this.isNodeListEqual(control.getChildNodes(), test.getChildNodes());
    }

    private boolean isDocumentTypeEqual(DocumentType control, DocumentType test) {
        if (control == test) {
            return true;
        }
        if (control == null || test == null) {
            return false;
        }
        if (!this.isStringEqual(control.getName(), test.getName())) {
            return false;
        }
        if (!this.isStringEqual(control.getPublicId(), test.getPublicId())) {
            return false;
        }
        return this.isStringEqual(control.getSystemId(), test.getSystemId());
    }

    private boolean isElementEqual(Element control, Element test) {
        int numberOfTestAttributes;
        if (!this.isStringEqual(control.getNamespaceURI(), test.getNamespaceURI())) {
            return false;
        }
        if (!this.isStringEqual(control.getTagName(), test.getTagName())) {
            return false;
        }
        NamedNodeMap controlAttributes = control.getAttributes();
        NamedNodeMap testAttributes = test.getAttributes();
        int numberOfControlAttributes = controlAttributes.getLength();
        if (numberOfControlAttributes != (numberOfTestAttributes = testAttributes.getLength())) {
            return false;
        }
        int x = 0;
        while (x < numberOfControlAttributes) {
            Attr controlAttribute = (Attr)controlAttributes.item(x);
            Attr testAttribute = controlAttribute.getNamespaceURI() == null ? (Attr)testAttributes.getNamedItem(controlAttribute.getNodeName()) : (Attr)testAttributes.getNamedItemNS(controlAttribute.getNamespaceURI(), controlAttribute.getLocalName());
            if (testAttribute == null) {
                return false;
            }
            if (!this.isAttributeEqual(controlAttribute, testAttribute)) {
                return false;
            }
            ++x;
        }
        return this.isNodeListEqual(control.getChildNodes(), test.getChildNodes());
    }

    private boolean isEntityReferenceEqual(EntityReference control, EntityReference test) {
        return this.isStringEqual(control.getNodeName(), test.getNodeName());
    }

    private boolean isProcessingInstructionEqual(ProcessingInstruction control, ProcessingInstruction test) {
        if (!this.isStringEqual(control.getTarget(), test.getTarget())) {
            return false;
        }
        return this.isStringEqual(control.getData(), test.getData());
    }

    private boolean isTextEqual(Text control, Text test) {
        return this.isStringEqual(control.getNodeValue(), test.getNodeValue());
    }

    private boolean isNodeListEqual(NodeList control, NodeList test) {
        int numberOfControlNodes = control.getLength();
        if (numberOfControlNodes != test.getLength()) {
            return false;
        }
        if (this.ignoreOrder) {
            int x = 0;
            while (x < numberOfControlNodes) {
                if (!this.isNodeInNodeList(control.item(x), test)) {
                    return false;
                }
                ++x;
            }
            x = 0;
            while (x < numberOfControlNodes) {
                if (!this.isNodeInNodeList(test.item(x), control)) {
                    return false;
                }
                ++x;
            }
        } else {
            int x = 0;
            while (x < numberOfControlNodes) {
                if (!this.isNodeEqual(control.item(x), test.item(x))) {
                    return false;
                }
                ++x;
            }
        }
        return true;
    }

    private boolean isNodeInNodeList(Node node2, NodeList nodeList) {
        int length = nodeList.getLength();
        int x = 0;
        while (x < length) {
            Node nextNode = nodeList.item(x);
            if (this.isNodeEqual(node2, nextNode)) {
                return true;
            }
            ++x;
        }
        return false;
    }

    private boolean isStringEqual(String control, String test) {
        if (control == test) {
            return true;
        }
        if (control == null) {
            return false;
        }
        return control.equals(test);
    }

    public boolean isIgnoreOrder() {
        return this.ignoreOrder;
    }

    public void setIgnoreOrder(boolean ignoreOrder) {
        this.ignoreOrder = ignoreOrder;
    }
}

