/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.jaxp;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class JAXPTransformer
implements XMLTransformer {
    private boolean fragment;
    private static final String NO = "no";
    private static final String YES = "yes";
    private Transformer transformer;
    private String encoding;
    private boolean formatted;
    private String version;

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
        if (this.transformer != null) {
            this.transformer.setOutputProperty("encoding", encoding);
        }
    }

    @Override
    public boolean isFormattedOutput() {
        return this.formatted;
    }

    @Override
    public void setFormattedOutput(boolean shouldFormat) {
        this.formatted = shouldFormat;
        if (this.transformer != null) {
            if (shouldFormat) {
                this.transformer.setOutputProperty("indent", YES);
            } else {
                this.transformer.setOutputProperty("indent", NO);
            }
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
        if (this.transformer != null) {
            this.transformer.setOutputProperty("version", version);
        }
    }

    @Override
    public void transform(Node sourceNode, OutputStream resultOutputStream) throws XMLPlatformException {
        DOMSource source = new DOMSource(sourceNode);
        StreamResult result2 = new StreamResult(resultOutputStream);
        if (this.isFragment()) {
            this.getTransformer().setOutputProperty("omit-xml-declaration", YES);
        }
        this.transform(source, (Result)result2);
    }

    @Override
    public void transform(Node sourceNode, ContentHandler resultContentHandler) throws XMLPlatformException {
        DOMSource source = new DOMSource(sourceNode);
        SAXResult result2 = new SAXResult(resultContentHandler);
        this.transform(source, (Result)result2);
    }

    @Override
    public void transform(Node sourceNode, Result result2) throws XMLPlatformException {
        DOMSource source = null;
        if (this.isFragment() && result2 instanceof SAXResult) {
            if (sourceNode instanceof Document) {
                source = new DOMSource(((Document)sourceNode).getDocumentElement());
            }
        } else {
            source = new DOMSource(sourceNode);
        }
        this.transform(source, result2);
    }

    @Override
    public void transform(Node sourceNode, Writer resultWriter) throws XMLPlatformException {
        DOMSource source = new DOMSource(sourceNode);
        StreamResult result2 = new StreamResult(resultWriter);
        if (this.isFragment()) {
            this.getTransformer().setOutputProperty("omit-xml-declaration", YES);
        }
        this.transform(source, (Result)result2);
    }

    @Override
    public void transform(Source source, Result result2) throws XMLPlatformException {
        try {
            if (result2 instanceof StreamResult && this.isFragment()) {
                this.getTransformer().setOutputProperty("omit-xml-declaration", YES);
            }
            this.getTransformer().transform(source, result2);
        }
        catch (TransformerException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    @Override
    public void transform(Document sourceDocument, Node resultParentNode, URL stylesheet) throws XMLPlatformException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(new TransformErrorListener());
            StreamSource stylesheetSource = new StreamSource(stylesheet.openStream());
            Transformer transformer = transformerFactory.newTransformer(stylesheetSource);
            DOMSource source = new DOMSource(sourceDocument);
            DOMResult result2 = new DOMResult(resultParentNode);
            transformer.transform(source, result2);
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    @Override
    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    @Override
    public boolean isFragment() {
        return this.fragment;
    }

    public Transformer getTransformer() {
        if (this.transformer == null) {
            try {
                this.transformer = TransformerFactoryHelper.getTransformerFactory().newTransformer();
                if (this.formatted) {
                    this.transformer.setOutputProperty("indent", YES);
                } else {
                    this.transformer.setOutputProperty("indent", NO);
                }
                if (this.encoding != null) {
                    this.transformer.setOutputProperty("encoding", this.encoding);
                }
                if (this.version != null) {
                    this.transformer.setOutputProperty("version", this.version);
                }
            }
            catch (TransformerConfigurationException e) {
                throw XMLPlatformException.xmlPlatformTransformException(e);
            }
        }
        return this.transformer;
    }

    private static class TransformErrorListener
    implements ErrorListener {
        private TransformErrorListener() {
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw XMLPlatformException.xmlPlatformTransformException(exception);
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw XMLPlatformException.xmlPlatformTransformException(exception);
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            throw XMLPlatformException.xmlPlatformTransformException(exception);
        }
    }

    private static class TransformerFactoryHelper {
        private TransformerFactoryHelper() {
        }

        static TransformerFactory getTransformerFactory() {
            return TransformerFactory.newInstance();
        }
    }
}

