/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.EntityResult;
import org.eclipse.persistence.queries.SQLResult;

public class SQLResultSetMapping
implements Serializable {
    protected String name;
    protected List<SQLResult> results;

    public SQLResultSetMapping(Class resultClass) {
        this.name = resultClass.getName();
        this.addResult(new EntityResult(resultClass));
    }

    public SQLResultSetMapping(String name) {
        this.name = name;
        if (this.name == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_in_sqlresultsetmapping"));
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Iterator<SQLResult> iterator2 = this.getResults().iterator();
        while (iterator2.hasNext()) {
            iterator2.next().convertClassNamesToClasses(classLoader);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addResult(SQLResult result2) {
        if (result2 == null) {
            return;
        }
        this.getResults().add(result2);
        result2.setSQLResultMapping(this);
    }

    public List<SQLResult> getResults() {
        if (this.results == null) {
            this.results = new ArrayList<SQLResult>();
        }
        return this.results;
    }
}

