/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;

public class SessionManager {
    protected static boolean shouldUseSchemaValidation = true;
    protected static SessionManager manager = SessionManager.initializeManager();
    protected AbstractSession defaultSession;
    protected ConcurrentMap<String, Session> sessions = new ConcurrentHashMap<String, Session>(5);
    protected static boolean shouldPerformDTDValidation;

    public static boolean shouldUseSchemaValidation() {
        return shouldUseSchemaValidation;
    }

    public static void setShouldUseSchemaValidation(boolean value2) {
        shouldUseSchemaValidation = value2;
    }

    public void addSession(Session session) {
        this.getSessions().put(session.getName(), session);
    }

    public void addSession(String sessionName, Session session) {
        session.setName(sessionName);
        this.getSessions().put(sessionName, session);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.getSession("default");
        }
        return this.defaultSession;
    }

    public void destroySession(String sessionName) {
        DatabaseSession session = (DatabaseSession)this.getSessions().get(sessionName);
        if (session != null) {
            this.destroy(session);
        } else {
            this.logAndThrowException(6, ValidationException.noSessionRegisteredForName(sessionName));
        }
    }

    private void destroy(DatabaseSession session) {
        try {
            if (session.isConnected()) {
                session.logout();
            }
        }
        catch (Throwable ignore) {
            AbstractSessionLog.getLog().logThrowable(6, "connection", ignore);
        }
        this.sessions.remove(session.getName());
        session = null;
    }

    public void destroyAllSessions() {
        Iterator toRemoveSessions = new ArrayList(this.getSessions().values()).iterator();
        while (toRemoveSessions.hasNext()) {
            this.destroy((DatabaseSession)toRemoveSessions.next());
        }
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String resourceName, ClassLoader objectClassLoader) {
        return this.getInternalMWConfigObjects(resourceName, objectClassLoader, true);
    }

    public synchronized SessionConfigs getInternalMWConfigObjects(String resourceName, ClassLoader objectClassLoader, boolean validate2) {
        return new XMLSessionConfigLoader(resourceName).loadConfigsForMappingWorkbench(objectClassLoader, validate2);
    }

    public static SessionManager getManager() {
        if (manager == null) {
            SessionManager.initializeManager();
        }
        return manager;
    }

    protected static SessionManager initializeManager() {
        return new SessionManager();
    }

    public AbstractSession getSession(String sessionName) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setShouldLogin(shouldLoginSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession, boolean shouldRefreshSession) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, Object objectBean) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        ClassLoader classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(objectBean.getClass()));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            classLoader = PrivilegedAccessHelper.getClassLoaderForClass(objectBean.getClass());
        }
        loader.setClassLoader(classLoader);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, String filename) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setResourceName(filename);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, String filename, ClassLoader classLoader) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setResourceName(filename);
        loader.setClassLoader(classLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(String sessionName, ClassLoader objectClassLoader) {
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldCheckClassLoader(true);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader, boolean shouldLoginSession, boolean shouldRefreshSession) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        return this.getSession(loader);
    }

    public AbstractSession getSession(XMLSessionConfigLoader loader, String sessionName, ClassLoader objectClassLoader, boolean shouldLoginSession, boolean shouldRefreshSession, boolean shouldCheckClassLoader) {
        if (loader == null) {
            loader = new XMLSessionConfigLoader();
        }
        loader.setSessionName(sessionName);
        loader.setClassLoader(objectClassLoader);
        loader.setShouldLogin(shouldLoginSession);
        loader.setShouldRefresh(shouldRefreshSession);
        loader.setShouldCheckClassLoader(shouldCheckClassLoader);
        return this.getSession(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSession getSession(XMLSessionConfigLoader loader) {
        SessionManager sessionManager;
        AbstractSession session = (AbstractSession)this.getSessions().get(loader.getSessionName());
        boolean shouldRefreshSession = loader.shouldRefresh();
        if (loader.shouldCheckClassLoader() && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(loader.getClassLoader())) {
            shouldRefreshSession = true;
        }
        if (session == null || shouldRefreshSession) {
            sessionManager = this;
            synchronized (sessionManager) {
                session = (AbstractSession)this.getSessions().get(loader.getSessionName());
                if (loader.shouldCheckClassLoader() && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(loader.getClassLoader())) {
                    shouldRefreshSession = true;
                }
                if (session == null || shouldRefreshSession) {
                    if (session != null) {
                        if (session.isDatabaseSession() && session.isConnected()) {
                            try {
                                ((DatabaseSession)((Object)session)).logout();
                            }
                            catch (Throwable ignore) {
                                AbstractSessionLog.getLog().logThrowable(6, "connection", ignore);
                            }
                        }
                        this.getSessions().remove(loader.getSessionName());
                    }
                    if (loader.load(this, loader.getClassLoader())) {
                        session = (AbstractSession)this.getSessions().get(loader.getSessionName());
                    }
                }
            }
        }
        if (session == null) {
            this.logAndThrowException(6, ValidationException.noSessionFound(loader.getSessionName(), loader.getResourcePath()));
        } else if (loader.shouldLogin() && !session.isConnected()) {
            sessionManager = this;
            synchronized (sessionManager) {
                if (loader.shouldLogin() && !session.isConnected()) {
                    ((DatabaseSession)((Object)session)).login();
                }
            }
        }
        return session;
    }

    private void logAndThrowException(int level, RuntimeException exception) throws RuntimeException {
        AbstractSessionLog.getLog().logThrowable(level, "connection", exception);
        throw exception;
    }

    public void setSessions(ConcurrentMap sessions) {
        this.sessions = sessions;
    }

    public ConcurrentMap getSessions() {
        return this.sessions;
    }

    public void setDefaultSession(Session defaultSession) {
        this.defaultSession = (AbstractSession)defaultSession;
        this.addSession("default", defaultSession);
    }

    public static void setManager(SessionManager theManager) {
        manager = theManager;
    }
}

