/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.persistence.internal.helper.CustomObjectInputStream;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.AbstractSerializer;

public class JavaSerializer
extends AbstractSerializer {
    public static final JavaSerializer instance = new JavaSerializer();

    @Override
    public Object serialize(Object object, Session session) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(object);
            objectOut.flush();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return byteOut.toByteArray();
    }

    @Override
    public Class getType() {
        return byte[].class;
    }

    @Override
    public Object deserialize(Object bytes2, Session session) {
        ByteArrayInputStream byteIn = new ByteArrayInputStream((byte[])bytes2);
        try {
            ObjectInputStream objectIn = null;
            objectIn = session == null ? new ObjectInputStream(byteIn) : new CustomObjectInputStream(byteIn, session);
            return objectIn.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

