/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.AbstractSerializer;

public class KryoSerializer
extends AbstractSerializer {
    ThreadLocal kryo;
    Constructor kryoConstructor;
    Constructor outputConstructor;
    Constructor inputConstructor;
    Method writeMethod;
    Method readMethod;
    Method inputCloseMethod;
    Method outputCloseMethod;

    public KryoSerializer() {
        try {
            Class<?> kryoClass = Class.forName("com.esotericsoftware.kryo.Kryo");
            this.kryoConstructor = kryoClass.getConstructor(new Class[0]);
            Class<?> inputClass = Class.forName("com.esotericsoftware.kryo.io.Input");
            this.inputConstructor = inputClass.getConstructor(InputStream.class);
            Class<?> outputClass = Class.forName("com.esotericsoftware.kryo.io.Output");
            this.outputConstructor = outputClass.getConstructor(OutputStream.class);
            this.writeMethod = kryoClass.getMethod("writeClassAndObject", outputClass, Object.class);
            this.readMethod = kryoClass.getMethod("readClassAndObject", inputClass);
            this.inputCloseMethod = inputClass.getMethod("close", new Class[0]);
            this.outputCloseMethod = outputClass.getMethod("close", new Class[0]);
            this.kryo = new ThreadLocal();
        }
        catch (Exception exception) {
            throw ValidationException.reflectiveExceptionWhileCreatingClassInstance("com.esotericsoftware.kryo.Kryo", exception);
        }
    }

    @Override
    public Class getType() {
        return byte[].class;
    }

    public Object getKryo() {
        Object value2 = this.kryo.get();
        if (value2 == null) {
            try {
                value2 = this.kryoConstructor.newInstance(new Object[0]);
                this.kryo.set(value2);
            }
            catch (Exception exception) {
                throw ValidationException.reflectiveExceptionWhileCreatingClassInstance("com.esotericsoftware.kryo.Kryo", exception);
            }
        }
        return value2;
    }

    @Override
    public Object serialize(Object object, Session session) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            Object output = this.outputConstructor.newInstance(stream);
            this.writeMethod.invoke(this.getKryo(), output, object);
            this.outputCloseMethod.invoke(output, new Object[0]);
            return stream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object deserialize(Object bytes2, Session session) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream((byte[])bytes2);
            Object input2 = this.inputConstructor.newInstance(stream);
            Object result2 = this.readMethod.invoke(this.getKryo(), input2);
            this.inputCloseMethod.invoke(input2, new Object[0]);
            return result2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

