/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ConnectionPool {
    protected static final String MONITOR_HEADER = "Info:ConnectionPool:";
    protected boolean isConnected;
    protected int maxNumberOfConnections;
    protected int minNumberOfConnections;
    protected int initialNumberOfConnections;
    protected int waitTimeout;
    protected List<Accessor> connectionsAvailable;
    protected List<Accessor> connectionsUsed;
    protected Login login;
    protected String name;
    protected ServerSession owner;
    protected volatile boolean checkConnections;
    protected volatile long timeOfDeath;
    protected volatile long deadCheckTime;
    protected volatile boolean isDead;
    protected List<String> failoverConnectionPools;
    public static final long DEAD_CHECK_TIME = 600000L;
    public static final int MAX_CONNECTIONS = 32;
    public static final int MIN_CONNECTIONS = 32;
    public static final int INITIAL_CONNECTIONS = 1;
    public static final int WAIT_TIMEOUT = 180000;

    public ConnectionPool() {
        this(null, null, null);
    }

    public ConnectionPool(String name, Login login, ServerSession owner2) {
        this(name, login, 1, 32, 32, owner2);
    }

    public ConnectionPool(String name, Login login, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner2) {
        this(name, login, Math.min(1, minNumberOfConnections), minNumberOfConnections, maxNumberOfConnections, owner2);
    }

    public ConnectionPool(String name, Login login, int initialNumberOfConnections, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner2) {
        this.login = login;
        this.owner = owner2;
        this.name = name;
        this.maxNumberOfConnections = maxNumberOfConnections;
        this.minNumberOfConnections = minNumberOfConnections;
        this.initialNumberOfConnections = initialNumberOfConnections;
        this.deadCheckTime = 600000L;
        this.waitTimeout = 180000;
        this.checkConnections = false;
        this.failoverConnectionPools = new ArrayList<String>();
        this.resetConnections();
    }

    public Accessor failover() {
        if (this.timeOfDeath + this.deadCheckTime < System.currentTimeMillis()) {
            this.isDead = false;
            return this.acquireConnection();
        }
        for (String poolName : this.failoverConnectionPools) {
            ConnectionPool pool = this.owner.getConnectionPool(poolName);
            if (pool.isDead()) continue;
            if (this.owner.shouldLog(1, "connection")) {
                Object[] args = new Object[]{this.name, poolName};
                this.owner.log(1, "connection", "failover", args);
            }
            return pool.acquireConnection();
        }
        throw QueryException.failoverFailed(this.name);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        if (!this.isDead) ** GOTO lbl28
        return this.failover();
lbl-1000:
        // 1 sources

        {
            if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.maxNumberOfConnections) {
                connection = null;
                try {
                    connection = this.buildConnection();
                }
                catch (RuntimeException failed) {
                    if (!this.failoverConnectionPools.isEmpty()) {
                        this.isDead = true;
                        this.timeOfDeath = System.currentTimeMillis();
                        this.owner.logThrowable(6, "sql", failed);
                        return this.acquireConnection();
                    }
                    throw failed;
                }
                this.connectionsUsed.add(connection);
                if (this.owner.isInProfile()) {
                    this.owner.updateProfile("Info:ConnectionPool:" + this.name, this.connectionsUsed.size());
                }
                if (this.owner.shouldLog(1, "connection")) {
                    args = new Object[]{this.name};
                    this.owner.log(1, "connection", "acquire_connection", args, connection);
                }
                return connection;
            }
            try {
                this.wait(this.waitTimeout);
                continue;
            }
            catch (InterruptedException exception) {
                throw ConcurrencyException.waitFailureOnClientSession(exception);
            }
lbl28:
            // 2 sources

            ** while (this.connectionsAvailable.isEmpty())
        }
lbl29:
        // 1 sources

        connectionSize = this.connectionsAvailable.size();
        connection = this.connectionsAvailable.remove(connectionSize - 1);
        if (this.checkConnections) {
            while (connectionSize >= 0) {
                if (this.owner.getLogin().isConnectionHealthValidatedOnError() && this.owner.getServerPlatform().wasFailureCommunicationBased(null, connection, this.owner)) {
                    block20: {
                        try {
                            try {
                                connection.closeConnection();
                            }
                            catch (Exception v0) {
                                connection.releaseCustomizer();
                                break block20;
                            }
                        }
                        catch (Throwable var3_7) {
                            connection.releaseCustomizer();
                            throw var3_7;
                        }
                        connection.releaseCustomizer();
                    }
                    if (this.connectionsAvailable.isEmpty()) {
                        this.checkConnections = false;
                        return this.acquireConnection();
                    }
                    connection = this.connectionsAvailable.remove(--connectionSize - 1);
                    continue;
                }
                this.checkConnections = false;
                break;
            }
        }
        this.connectionsUsed.add(connection);
        if (this.owner.isInProfile()) {
            this.owner.updateProfile("Info:ConnectionPool:" + this.name, this.connectionsUsed.size());
        }
        if (this.owner.shouldLog(1, "connection")) {
            args = new Object[]{this.name};
            this.owner.log(1, "connection", "acquire_connection", args, connection);
        }
        return connection;
    }

    protected Accessor buildConnection() {
        Accessor connection = this.login.buildAccessor();
        connection.setPool(this);
        connection.connect(this.login, this.owner);
        return connection;
    }

    public List<Accessor> getConnectionsAvailable() {
        return this.connectionsAvailable;
    }

    protected List<Accessor> getConnectionsUsed() {
        return this.connectionsUsed;
    }

    public Login getLogin() {
        return this.login;
    }

    public int getMaxNumberOfConnections() {
        return this.maxNumberOfConnections;
    }

    public int getMinNumberOfConnections() {
        return this.minNumberOfConnections;
    }

    public String getName() {
        return this.name;
    }

    protected ServerSession getOwner() {
        return this.owner;
    }

    public int getTotalNumberOfConnections() {
        return this.getConnectionsUsed().size() + this.getConnectionsAvailable().size();
    }

    public boolean hasConnectionAvailable() {
        return !this.getConnectionsAvailable().isEmpty();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isThereConflictBetweenLoginAndType() {
        return this.getLogin().shouldUseExternalConnectionPooling();
    }

    public synchronized void releaseConnection(Accessor connection) throws DatabaseException {
        if (this.owner.shouldLog(1, "connection")) {
            Object[] args = new Object[]{this.name};
            this.owner.log(1, "connection", "release_connection", args, connection);
        }
        connection.reset();
        this.connectionsUsed.remove(connection);
        if (!connection.isValid()) {
            this.checkConnections = true;
            try {
                connection.disconnect(this.owner);
            }
            catch (DatabaseException databaseException) {}
        } else if (this.connectionsUsed.size() + this.connectionsAvailable.size() < this.minNumberOfConnections) {
            this.connectionsAvailable.add(connection);
        } else {
            connection.disconnect(this.getOwner());
        }
        if (this.owner.isInProfile()) {
            this.owner.updateProfile(MONITOR_HEADER + this.name, this.connectionsUsed.size());
        }
        this.notify();
    }

    public void resetConnections() {
        this.connectionsUsed = new Vector<Accessor>();
        this.connectionsAvailable = new Vector<Accessor>();
        this.checkConnections = false;
        this.isDead = false;
        this.timeOfDeath = 0L;
    }

    public void setCheckConnections() {
        this.checkConnections = true;
    }

    protected void setConnectionsAvailable(Vector connectionsAvailable) {
        this.connectionsAvailable = connectionsAvailable;
    }

    protected void setConnectionsUsed(Vector connectionsUsed) {
        this.connectionsUsed = connectionsUsed;
    }

    public void setIsConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    public int getInitialNumberOfConnections() {
        return this.initialNumberOfConnections;
    }

    public void setInitialNumberOfConnections(int initialNumberOfConnections) {
        this.initialNumberOfConnections = initialNumberOfConnections;
    }

    public void setMaxNumberOfConnections(int maxNumberOfConnections) {
        this.maxNumberOfConnections = maxNumberOfConnections;
    }

    public void setMinNumberOfConnections(int minNumberOfConnections) {
        this.minNumberOfConnections = minNumberOfConnections;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setOwner(ServerSession owner2) {
        this.owner = owner2;
    }

    public synchronized void shutDown() {
        this.setIsConnected(false);
        Iterator<Accessor> iterator2 = this.getConnectionsAvailable().iterator();
        while (iterator2.hasNext()) {
            try {
                iterator2.next().disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        iterator2 = this.getConnectionsUsed().iterator();
        while (iterator2.hasNext()) {
            try {
                iterator2.next().disconnect(this.getOwner());
            }
            catch (DatabaseException databaseException) {}
        }
        this.resetConnections();
    }

    public synchronized void startUp() {
        if (this.isConnected()) {
            return;
        }
        int index = this.getInitialNumberOfConnections();
        while (index > 0) {
            this.getConnectionsAvailable().add(this.buildConnection());
            --index;
        }
        this.setIsConnected(true);
    }

    public String toString() {
        Object[] args = new Object[]{this.getMinNumberOfConnections(), this.getMaxNumberOfConnections()};
        return String.valueOf(Helper.getShortClassName(this.getClass())) + ToStringLocalization.buildMessage("min_max", args);
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setIsDead(boolean isDead) {
        this.isDead = isDead;
    }

    public List<String> getFailoverConnectionPools() {
        return this.failoverConnectionPools;
    }

    public void setFailoverConnectionPools(List<String> failoverConnectionPools) {
        this.failoverConnectionPools = failoverConnectionPools;
    }

    public boolean addFailoverConnectionPool(String poolName) {
        return this.failoverConnectionPools.add(poolName);
    }
}

