/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.RuntimeType;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public final class PropertiesHelper {
    private static final Logger LOGGER = Logger.getLogger(PropertiesHelper.class.getName());

    public static PrivilegedAction<Properties> getSystemProperties() {
        return new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        };
    }

    public static PrivilegedAction<String> getSystemProperty(final String name) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        };
    }

    public static PrivilegedAction<String> getSystemProperty(final String name, final String def) {
        return new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, def);
            }
        };
    }

    public static <T> T getValue(Map<String, ?> properties, String key, T defaultValue, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties, null, key, defaultValue, legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties, RuntimeType runtimeType, String key, T defaultValue, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties, runtimeType, key, defaultValue, defaultValue.getClass(), legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties, String key, T defaultValue, Class<T> type, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties, null, key, defaultValue, type, legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties, RuntimeType runtimeType, String key, T defaultValue, Class<T> type, Map<String, String> legacyMap) {
        T value2 = PropertiesHelper.getValue(properties, runtimeType, key, type, legacyMap);
        if (value2 == null) {
            value2 = defaultValue;
        }
        return value2;
    }

    public static <T> T getValue(Map<String, ?> properties, String key, Class<T> type, Map<String, String> legacyMap) {
        return PropertiesHelper.getValue(properties, null, key, type, legacyMap);
    }

    public static <T> T getValue(Map<String, ?> properties, RuntimeType runtimeType, String key, Class<T> type, Map<String, String> legacyMap) {
        Object value2 = null;
        if (runtimeType != null) {
            String runtimeAwareKey = PropertiesHelper.getPropertyNameForRuntime(key, runtimeType);
            if (key.equals(runtimeAwareKey)) {
                runtimeAwareKey = key + "." + runtimeType.name().toLowerCase();
            }
            value2 = properties.get(runtimeAwareKey);
        }
        if (value2 == null) {
            value2 = properties.get(key);
        }
        if (value2 == null) {
            value2 = PropertiesHelper.getLegacyFallbackValue(properties, legacyMap, key);
        }
        if (value2 == null) {
            return null;
        }
        return PropertiesHelper.convertValue(value2, type);
    }

    public static String getPropertyNameForRuntime(String key, RuntimeType runtimeType) {
        if (runtimeType != null && key.startsWith("jersey.config")) {
            RuntimeType[] types;
            for (RuntimeType type : types = RuntimeType.values()) {
                if (!key.startsWith("jersey.config." + type.name().toLowerCase())) continue;
                return key;
            }
            return key.replace("jersey.config", "jersey.config." + runtimeType.name().toLowerCase());
        }
        return key;
    }

    private static Object getLegacyFallbackValue(Map<String, ?> properties, Map<String, String> legacyFallbackMap, String key) {
        if (legacyFallbackMap == null || !legacyFallbackMap.containsKey(key)) {
            return null;
        }
        String fallbackKey = legacyFallbackMap.get(key);
        Object value2 = properties.get(fallbackKey);
        if (value2 != null && LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config(LocalizationMessages.PROPERTIES_HELPER_DEPRECATED_PROPERTY_NAME(fallbackKey, key));
        }
        return value2;
    }

    public static <T> T convertValue(Object value2, Class<T> type) {
        if (!type.isInstance(value2)) {
            Method valueOf;
            Constructor constructor = AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA(type));
            if (constructor != null) {
                try {
                    return type.cast(constructor.newInstance(value2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((valueOf = AccessController.doPrivileged(ReflectionHelper.getValueOfStringMethodPA(type))) != null) {
                try {
                    return type.cast(valueOf.invoke(null, value2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(LocalizationMessages.PROPERTIES_HELPER_GET_VALUE_NO_TRANSFORM(String.valueOf(value2), value2.getClass().getName(), type.getName()));
            }
            return null;
        }
        return type.cast(value2);
    }

    public static boolean isProperty(Map<String, Object> properties, String name) {
        return properties.containsKey(name) && PropertiesHelper.isProperty(properties.get(name));
    }

    public static boolean isProperty(Object value2) {
        if (value2 instanceof Boolean) {
            return (Boolean)Boolean.class.cast(value2);
        }
        return value2 != null && Boolean.parseBoolean(value2.toString());
    }

    private PropertiesHelper() {
    }
}

