/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.AbstractMultivaluedMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.ImmutableMap;
import jersey.repackaged.com.google.common.collect.Lists;
import jersey.repackaged.com.google.common.collect.Maps;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;

public final class HeaderUtils {
    private static final Logger LOGGER = Logger.getLogger(HeaderUtils.class.getName());

    public static AbstractMultivaluedMap<String, String> createInbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<String>();
    }

    public static <V> MultivaluedMap<String, V> empty() {
        return ImmutableMultivaluedMap.empty();
    }

    public static AbstractMultivaluedMap<String, Object> createOutbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<Object>();
    }

    public static String asString(Object headerValue, RuntimeDelegate rd) {
        RuntimeDelegate.HeaderDelegate<?> hp;
        if (headerValue == null) {
            return null;
        }
        if (headerValue instanceof String) {
            return (String)headerValue;
        }
        if (rd == null) {
            rd = RuntimeDelegate.getInstance();
        }
        return (hp = rd.createHeaderDelegate(headerValue.getClass())) != null ? hp.toString(headerValue) : headerValue.toString();
    }

    public static List<String> asStringList(List<Object> headerValues, RuntimeDelegate rd) {
        if (headerValues == null || headerValues.isEmpty()) {
            return Collections.emptyList();
        }
        final RuntimeDelegate delegate = rd == null ? RuntimeDelegate.getInstance() : rd;
        return Lists.transform(headerValues, new Function<Object, String>(){

            @Override
            public String apply(Object input2) {
                return input2 == null ? "[null]" : HeaderUtils.asString(input2, delegate);
            }
        });
    }

    public static MultivaluedMap<String, String> asStringHeaders(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        final RuntimeDelegate rd = RuntimeDelegate.getInstance();
        return new AbstractMultivaluedMap<String, String>(Maps.transformValues(headers, new Function<List<Object>, List<String>>(){

            @Override
            public List<String> apply(List<Object> input2) {
                return HeaderUtils.asStringList(input2, rd);
            }
        })){};
    }

    public static Map<String, String> asStringHeadersSingleValue(MultivaluedMap<String, Object> headers) {
        if (headers == null) {
            return null;
        }
        RuntimeDelegate rd = RuntimeDelegate.getInstance();
        ImmutableMap.Builder immutableMapBuilder = new ImmutableMap.Builder();
        for (Map.Entry entry2 : headers.entrySet()) {
            immutableMapBuilder.put(entry2.getKey(), HeaderUtils.asHeaderString((List)entry2.getValue(), rd));
        }
        return immutableMapBuilder.build();
    }

    public static String asHeaderString(List<Object> values, RuntimeDelegate rd) {
        if (values == null) {
            return null;
        }
        Iterator<String> stringValues = HeaderUtils.asStringList(values, rd).iterator();
        if (!stringValues.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(stringValues.next());
        while (stringValues.hasNext()) {
            buffer.append(',').append(stringValues.next());
        }
        return buffer.toString();
    }

    public static void checkHeaderChanges(Map<String, String> headersSnapshot, MultivaluedMap<String, Object> currentHeaders, String connectorName) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            RuntimeDelegate rd = RuntimeDelegate.getInstance();
            HashSet changedHeaderNames = new HashSet();
            for (Map.Entry entry2 : currentHeaders.entrySet()) {
                String newValue;
                if (!headersSnapshot.containsKey(entry2.getKey())) {
                    changedHeaderNames.add(entry2.getKey());
                    continue;
                }
                String prevValue = headersSnapshot.get(entry2.getKey());
                if (prevValue.equals(newValue = HeaderUtils.asHeaderString((List)currentHeaders.get(entry2.getKey()), rd))) continue;
                changedHeaderNames.add(entry2.getKey());
            }
            if (!changedHeaderNames.isEmpty() && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(LocalizationMessages.SOME_HEADERS_NOT_SENT(connectorName, ((Object)changedHeaderNames).toString()));
            }
        }
    }

    private HeaderUtils() {
        throw new AssertionError((Object)"No instances allowed.");
    }
}

