/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import com.google.common.io.ByteStreams;
import io.hops.util.Hops;
import io.hops.util.dela.DelaConsumer;
import io.hops.util.dela.DelaProducer;
import io.hops.util.exceptions.SchemaNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.avro.Schema;
import org.apache.commons.net.util.Base64;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.filter.LoggingFilter;
import org.json.JSONObject;

public class DelaHelper {
    private static final Logger LOGGER = Logger.getLogger(DelaHelper.class.getName());

    public static DelaConsumer getHopsConsumer(int projectId, String topicName, String brokerEndpoint, String restEndpoint, String keyStore, String trustStore, String keystorePwd, String truststorePwd) throws SchemaNotFoundException {
        LOGGER.log(Level.INFO, "projectId:{0}, topicName:{1}, brokerE:{2}, restE:{3}, keyS:{4}, trustS:{5}, keysP:{6}, trustsP:{7}", new Object[]{projectId, topicName, brokerEndpoint, restEndpoint, keyStore, trustStore, keystorePwd, truststorePwd});
        Hops.setup(projectId, topicName, brokerEndpoint, restEndpoint, keyStore, trustStore, keystorePwd, truststorePwd);
        String stringSchema = DelaHelper.getSchemaByTopic(Hops.getRestEndpoint(), projectId, topicName);
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(stringSchema);
        return new DelaConsumer(topicName, schema);
    }

    public static DelaProducer getHopsProducer(int projectId, String topicName, String brokerEndpoint, String restEndpoint, String keyStore, String trustStore, String keystorePwd, String truststorePwd, long lingerDelay) throws SchemaNotFoundException {
        LOGGER.log(Level.INFO, "projectId:{0}, topicName:{1}, brokerE:{2}, restE:{3}, keyS:{4}, trustS:{5}, keysP:{6}, trustsP:{7}, linger:{8}", new Object[]{projectId, topicName, brokerEndpoint, restEndpoint, keyStore, trustStore, keystorePwd, truststorePwd, lingerDelay});
        Hops.setup(projectId, topicName, brokerEndpoint, restEndpoint, keyStore, trustStore, keystorePwd, truststorePwd);
        String stringSchema = DelaHelper.getSchemaByTopic(Hops.getRestEndpoint(), projectId, topicName);
        LOGGER.log(Level.INFO, "schema:{0}", new Object[]{stringSchema});
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(stringSchema);
        return new DelaProducer(topicName, schema, lingerDelay);
    }

    public static String getSchemaByTopic(String restEndpoint, int projectId, String topicName) throws SchemaNotFoundException {
        return DelaHelper.getSchemaByTopic(restEndpoint, projectId, topicName, Integer.MIN_VALUE);
    }

    public static String getSchemaByTopic(String restEndpoint, int projectId, String topicName, int versionId) throws SchemaNotFoundException {
        JSONObject json = new JSONObject();
        DelaHelper.jsonAddKeyStore(json, Hops.getKeyStore(), Hops.getKeystorePwd());
        json.append("topicName", (Object)topicName);
        if (versionId > 0) {
            json.append("version", (Object)versionId);
        }
        String uri = Hops.getRestEndpoint() + "/schema";
        LOGGER.log(Level.INFO, "getting schema:{0}", uri);
        Response response = DelaHelper.postJsonResponse(uri, json.toString());
        if (response == null) {
            throw new SchemaNotFoundException("Could not reach schema endpoint");
        }
        if (response.getStatus() != 200) {
            LOGGER.log(Level.WARNING, "error code:{0}", response.getStatus());
            LOGGER.log(Level.WARNING, "response:{0}", response.toString());
            throw new SchemaNotFoundException(response.getStatus(), "Schema is not found");
        }
        String schema = DelaHelper.extractSchema(response);
        return schema;
    }

    private static void jsonAddKeyStore(JSONObject json, String keyStore, String keystorePwd) {
        json.append("keyStorePwd", (Object)keystorePwd);
        try {
            FileInputStream kfin = new FileInputStream(new File(keyStore));
            byte[] kStoreBlob = ByteStreams.toByteArray((InputStream)kfin);
            String keystorString = Base64.encodeBase64String((byte[])kStoreBlob);
            json.append("keyStore", (Object)keystorString);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private static Response postJsonResponse(String uri, String payload) {
        ClientConfig config = new ClientConfig().register(LoggingFilter.class);
        Client client = ClientBuilder.newClient((Configuration)config);
        WebTarget webTarget = client.target(uri);
        Invocation.Builder invocationBuilder = webTarget.request().accept(new String[]{"application/json"});
        return invocationBuilder.post(Entity.entity((Object)payload, (String)"application/json"));
    }

    private static String extractSchema(Response response) {
        String content = (String)response.readEntity(String.class);
        JSONObject json = new JSONObject(content);
        String schema = json.getString("contents");
        schema = DelaHelper.tempHack(schema);
        return schema;
    }

    private static String tempHack(String schema) {
        int actualSchema = schema.indexOf(123);
        return schema.substring(actualSchema);
    }
}

