/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.Hops;
import io.hops.util.HopsProcessType;
import io.hops.util.exceptions.CredentialsNotFoundException;
import io.hops.util.exceptions.SchemaNotFoundException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;

public abstract class HopsProcess
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(HopsProcess.class.getName());
    public HopsProcessType type;
    protected final String topic;
    protected final Schema schema;

    public HopsProcess(HopsProcessType type, String topic) throws SchemaNotFoundException, CredentialsNotFoundException {
        this.topic = topic;
        Schema.Parser parser = new Schema.Parser();
        LOGGER.log(Level.INFO, "Trying to get schema for topic:{0}", topic);
        this.schema = parser.parse(Hops.getSchema(topic));
        LOGGER.log(Level.INFO, "Got schema:{0}", this.schema);
    }

    public HopsProcess(HopsProcessType type, String topic, Schema schema) {
        this.type = type;
        this.topic = topic;
        this.schema = schema;
    }

    public abstract void close();

    public Schema getSchema() {
        return this.schema;
    }
}

