/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.Hops;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SparkInfo {
    private static final Logger LOG = Logger.getLogger(SparkInfo.class.getName());
    private final Configuration hdfsConf = new Configuration();
    private Path marker = new Path("/Projects/" + Hops.getProjectName() + "/" + "Resources" + File.separator + ".marker-" + Hops.getJobType().toLowerCase() + "-" + Hops.getJobName() + "-" + Hops.getAppId());

    protected SparkInfo(String jobName) {
        try {
            FileSystem hdfs = this.marker.getFileSystem(this.hdfsConf);
            hdfs.createNewFile(this.marker);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not create marker file for job:" + Hops.getJobName() + ", appId:" + Hops.getAppId(), ex);
        }
    }

    protected boolean isShutdownRequested() {
        try {
            FileSystem hdfs = this.marker.getFileSystem(this.hdfsConf);
            return !hdfs.exists(this.marker);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Could not check existence of marker file", ex);
            return false;
        }
    }
}

