/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.dela;

import com.twitter.bijection.Injection;
import com.twitter.bijection.avro.GenericAvroCodecs;
import io.hops.util.Hops;
import io.hops.util.HopsProcess;
import io.hops.util.HopsProcessType;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class DelaConsumer
extends HopsProcess
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(DelaConsumer.class.getName());
    private KafkaConsumer<Integer, String> consumer;
    private boolean consume;

    public DelaConsumer(String topic, Schema schema) {
        super(HopsProcessType.CONSUMER, topic, schema);
    }

    public void consume() {
        this.consume = true;
        new Thread(this).start();
    }

    public void stopConsuming() {
        this.consume = false;
    }

    @Override
    public void run() {
        Properties props = Hops.getKafkaProperties().getConsumerConfig();
        this.consumer = new KafkaConsumer(props);
        this.consumer.subscribe(Collections.singletonList(this.topic));
        while (this.consume) {
            ConsumerRecords records = this.consumer.poll(1000L);
            for (ConsumerRecord record : records) {
                Injection recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
                GenericRecord genericRecord = (GenericRecord)recordInjection.invert((Object)((String)record.value()).getBytes()).get();
                LOGGER.log(Level.INFO, "Consumer received message:{0}", genericRecord);
            }
        }
    }

    @Override
    public void close() {
        this.consume = false;
    }
}

