/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import com.twitter.bijection.Injection;
import com.twitter.bijection.avro.GenericAvroCodecs;
import io.hops.util.Hops;
import io.hops.util.exceptions.CredentialsNotFoundException;
import io.hops.util.exceptions.SchemaNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.streaming.util.serialization.DeserializationSchema;
import org.apache.flink.streaming.util.serialization.SerializationSchema;

public class AvroDeserializer
implements DeserializationSchema<String>,
SerializationSchema<Tuple4<String, String, String, String>> {
    private static final long serialVersionUID = 1L;
    private String schemaJson;
    private transient Schema.Parser parser = new Schema.Parser();
    private transient Schema schema;
    private transient Injection<GenericRecord, byte[]> recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
    private boolean initialized = false;

    public AvroDeserializer(String topicName) {
        try {
            this.schemaJson = Hops.getSchema(topicName);
        }
        catch (CredentialsNotFoundException | SchemaNotFoundException ex) {
            Logger.getLogger(AvroDeserializer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String deserialize(byte[] message) throws IOException {
        if (!this.initialized) {
            this.parser = new Schema.Parser();
            this.schema = this.parser.parse(this.schemaJson);
            this.recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
            this.initialized = true;
        }
        GenericRecord genericRecord = (GenericRecord)this.recordInjection.invert((Object)message).get();
        return genericRecord.toString().replaceAll("\\\\u001A", "");
    }

    @Deprecated
    public boolean isEndOfStream(String t) {
        return false;
    }

    public TypeInformation<String> getProducedType() {
        return BasicTypeInfo.STRING_TYPE_INFO;
    }

    public byte[] serialize(Tuple4<String, String, String, String> t) {
        if (!this.initialized) {
            this.parser = new Schema.Parser();
            this.schema = this.parser.parse(this.schemaJson);
            this.recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
            this.initialized = true;
        }
        GenericData.Record avroRecord = new GenericData.Record(this.schema);
        for (int i = 0; i < t.getArity() - 1; i += 2) {
            avroRecord.put(t.getField(i).toString(), (Object)t.getField(i + 1).toString());
        }
        byte[] bytes = (byte[])this.recordInjection.apply((Object)avroRecord);
        return bytes;
    }
}

