/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import com.twitter.bijection.Injection;
import com.twitter.bijection.avro.GenericAvroCodecs;
import io.hops.util.Hops;
import io.hops.util.HopsProcess;
import io.hops.util.HopsProcessType;
import io.hops.util.exceptions.CredentialsNotFoundException;
import io.hops.util.exceptions.SchemaNotFoundException;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class HopsConsumer
extends HopsProcess
implements Runnable {
    private static final Logger LOG = Logger.getLogger(HopsConsumer.class.getName());
    private KafkaConsumer<Integer, String> consumer;
    private boolean consume;
    private BlockingQueue<String> messages;
    private final boolean callback = false;
    private final StringBuilder consumed = new StringBuilder();

    HopsConsumer(String topic) throws SchemaNotFoundException, CredentialsNotFoundException {
        super(HopsProcessType.CONSUMER, topic);
    }

    public void consume() {
        this.consume = true;
        Properties props = Hops.getKafkaProperties().getConsumerConfig();
        this.consumer = new KafkaConsumer(props);
        this.consumer.subscribe(Collections.singletonList(this.topic));
        while (this.consume) {
            ConsumerRecords records = this.consumer.poll(1000L);
            for (ConsumerRecord record : records) {
                Injection recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
                GenericRecord genericRecord = (GenericRecord)recordInjection.invert((Object)((String)record.value()).getBytes()).get();
                this.consumed.append((String)record.value()).append("\n");
                LOG.log(Level.FINE, "Consumer received message:{0}", genericRecord);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, "Error while consuming records", ex);
            }
        }
        this.consumer.close();
    }

    public void stopConsuming() {
        this.consume = false;
    }

    @Override
    public void run() {
        Properties props = Hops.getKafkaProperties().getConsumerConfig();
        this.consumer = new KafkaConsumer(props);
        this.consumer.subscribe(Collections.singletonList(this.topic));
        while (this.consume) {
            ConsumerRecords records = this.consumer.poll(1000L);
            for (ConsumerRecord record : records) {
                Injection recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
                GenericRecord genericRecord = (GenericRecord)recordInjection.invert((Object)((String)record.value()).getBytes()).get();
                this.consumed.append((String)record.value()).append("\n");
                LOG.log(Level.FINE, "Consumer received message:{0}", genericRecord);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, "Error while consuming records", ex);
            }
        }
    }

    @Override
    public void close() {
        this.consume = false;
    }
}

