/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import com.twitter.bijection.Injection;
import com.twitter.bijection.avro.GenericAvroCodecs;
import io.hops.util.Hops;
import io.hops.util.HopsProcess;
import io.hops.util.HopsProcessType;
import io.hops.util.exceptions.CredentialsNotFoundException;
import io.hops.util.exceptions.SchemaNotFoundException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class HopsProducer
extends HopsProcess {
    private static final Logger LOGGER = Logger.getLogger(HopsProducer.class.getName());
    private final KafkaProducer<String, byte[]> producer;
    private final Injection<GenericRecord, byte[]> recordInjection;
    private GenericData.Record avroRecord;
    private ProducerRecord<String, byte[]> record;

    public HopsProducer(String topic, Properties userProps) throws SchemaNotFoundException, CredentialsNotFoundException {
        super(HopsProcessType.PRODUCER, topic);
        Properties props = Hops.getKafkaProperties().defaultProps();
        props.put("client.id", "HopsProducer");
        if (userProps != null) {
            props.putAll((Map<?, ?>)userProps);
        }
        this.producer = new KafkaProducer(props);
        this.recordInjection = GenericAvroCodecs.toBinary((Schema)this.schema);
    }

    public void produce(Map<String, String> messageFields) {
        this.avroRecord = new GenericData.Record(this.schema);
        for (Map.Entry<String, String> message : messageFields.entrySet()) {
            this.avroRecord.put(message.getKey(), (Object)message.getValue());
        }
        byte[] bytes = (byte[])this.recordInjection.apply((Object)this.avroRecord);
        this.record = new ProducerRecord(this.topic, (Object)bytes);
        this.producer.send(this.record);
        LOGGER.log(Level.INFO, "Producer sent message: {0}", messageFields);
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

