/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import com.google.common.base.Strings;
import io.hops.util.Hops;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;

public class KafkaProperties {
    public Properties defaultProps() {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", Hops.getBrokerEndpoints());
        props.setProperty("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.setProperty("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.setProperty("security.protocol", "SSL");
        props.setProperty("ssl.truststore.location", Hops.getTrustStore());
        props.setProperty("ssl.truststore.password", Hops.getTruststorePwd());
        props.setProperty("ssl.keystore.location", Hops.getKeyStore());
        props.setProperty("ssl.keystore.password", Hops.getKeystorePwd());
        props.setProperty("ssl.key.password", Hops.getKeystorePwd());
        return props;
    }

    public Properties getConsumerConfig() {
        return this.getConsumerConfig(null);
    }

    public Properties getConsumerConfig(Properties userProps) {
        Properties props = new Properties();
        props.put("bootstrap.servers", Hops.getBrokerEndpointsList());
        if (Hops.getConsumerGroups() != null && !Hops.getConsumerGroups().isEmpty()) {
            props.put("group.id", Hops.getConsumerGroups().get(0));
        }
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "1000");
        props.put("session.timeout.ms", "30000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.IntegerDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        if (!Strings.isNullOrEmpty((String)Hops.getTrustStore()) && !Strings.isNullOrEmpty((String)Hops.getKeyStore())) {
            props.setProperty("security.protocol", "SSL");
            props.setProperty("ssl.truststore.location", Hops.getTrustStore());
            props.setProperty("ssl.truststore.password", Hops.getTruststorePwd());
            props.setProperty("ssl.keystore.location", Hops.getKeyStore());
            props.setProperty("ssl.keystore.password", Hops.getKeystorePwd());
            props.setProperty("ssl.key.password", Hops.getKeystorePwd());
        }
        if (userProps != null) {
            props.putAll((Map<?, ?>)userProps);
        }
        return props;
    }

    public Properties getSparkConsumerConfig() {
        return this.getSparkConsumerConfig(null);
    }

    public Properties getSparkConsumerConfig(Properties userProps) {
        Properties props = new Properties();
        props.put("bootstrap.servers", Hops.getBrokerEndpoints());
        props.put("group.id", Hops.getConsumerGroups().get(0));
        props.put("auto.offset.reset", "latest");
        props.put("enable.auto.commit", "false");
        props.put("key.deserializer", StringDeserializer.class.getCanonicalName());
        props.put("value.deserializer", ByteArrayDeserializer.class.getCanonicalName());
        if (!Strings.isNullOrEmpty((String)Hops.getTrustStore()) && !Strings.isNullOrEmpty((String)Hops.getKeyStore())) {
            props.setProperty("security.protocol", "SSL");
            props.setProperty("ssl.truststore.location", Hops.getTrustStore());
            props.setProperty("ssl.truststore.password", Hops.getTruststorePwd());
            props.setProperty("ssl.keystore.location", Hops.getKeyStore());
            props.setProperty("ssl.keystore.password", Hops.getKeystorePwd());
            props.setProperty("ssl.key.password", Hops.getKeystorePwd());
        }
        if (userProps != null) {
            props.putAll((Map<?, ?>)userProps);
        }
        return props;
    }

    public Map<String, Object> getSparkConsumerConfigMap() {
        return this.getSparkConsumerConfigMap(null);
    }

    public Map<String, String> getSparkStructuredStreamingKafkaProps() {
        return this.getSparkStructuredStreamingKafkaProps(null);
    }

    public Map<String, String> getSparkStructuredStreamingKafkaProps(Map<String, String> userOptions) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("kafka.bootstrap.servers", Hops.getBrokerEndpoints());
        options.put("subscribe", Hops.getTopicsAsCSV());
        options.put("kafka.security.protocol", "SSL");
        options.put("kafka.ssl.truststore.location", Hops.getTrustStore());
        options.put("kafka.ssl.truststore.password", Hops.getTruststorePwd());
        options.put("kafka.ssl.keystore.location", Hops.getKeyStore());
        options.put("kafka.ssl.keystore.password", Hops.getKeystorePwd());
        options.put("kafka.ssl.key.password", Hops.getKeystorePwd());
        if (userOptions != null) {
            options.putAll(userOptions);
        }
        return options;
    }

    public Map<String, Object> getSparkConsumerConfigMap(Properties userProps) {
        Properties props = this.getSparkConsumerConfig(userProps);
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        for (String name : props.stringPropertyNames()) {
            propsMap.put(name, props.getProperty(name));
        }
        return propsMap;
    }
}

