/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.Constants;
import io.hops.util.Hops;
import io.hops.util.exceptions.CredentialsNotFoundException;
import io.hops.util.exceptions.HTTPSClientInitializationException;
import io.hops.util.exceptions.WorkflowManagerException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.json.JSONObject;

public class WorkflowManager {
    private static final Logger LOG = Logger.getLogger(WorkflowManager.class.getName());

    public static boolean waitForJobs(Integer ... jobs) throws CredentialsNotFoundException, InterruptedException, WorkflowManagerException {
        return WorkflowManager.waitForJobs(7L, Constants.WAIT_JOBS_TIMEOUT_TIMEUNIT, jobs);
    }

    public static boolean waitForJobs(long timeout, TimeUnit timeoutUnit, Integer[] jobs) throws CredentialsNotFoundException, InterruptedException, WorkflowManagerException {
        return WorkflowManager.waitForJobs(7L, Constants.WAIT_JOBS_TIMEOUT_TIMEUNIT, true, jobs);
    }

    public static boolean waitForJobs(long timeout, TimeUnit timeoutUnit, boolean waitOnJobState, Integer ... jobs) throws CredentialsNotFoundException, InterruptedException, WorkflowManagerException {
        return WorkflowManager.waitForJobs(5L, TimeUnit.MILLISECONDS, timeout, timeoutUnit, waitOnJobState, jobs);
    }

    public static boolean waitForJobs(long pollingInterval, TimeUnit pollingIntervalUnit, long timeout, TimeUnit timeoutUnit, boolean waitOnJobState, Integer ... jobs) throws CredentialsNotFoundException, InterruptedException, WorkflowManagerException {
        JSONObject json = new JSONObject();
        json.put("jobIds", (Object)jobs);
        json.put("running", waitOnJobState);
        boolean flag = true;
        long startTime = System.nanoTime();
        timeout = timeoutUnit.toNanos(timeout);
        pollingInterval = pollingIntervalUnit.toMillis(pollingInterval);
        while (flag) {
            String response;
            try {
                response = (String)Hops.clientWrapper(json, "jobs").readEntity(String.class);
            }
            catch (HTTPSClientInitializationException e) {
                throw new WorkflowManagerException(e.getMessage());
            }
            LOG.log(Level.INFO, "Retrieved running jobs:{0}", response);
            JSONObject jobsJSON = new JSONObject(response);
            if (waitOnJobState && jobsJSON.getJSONArray("jobIds").length() == 0) {
                flag = false;
            } else if (!waitOnJobState && jobsJSON.getJSONArray("jobIds").length() > 0) {
                flag = false;
            }
            Thread.sleep(pollingInterval);
            long elapsed = System.nanoTime() - startTime;
            if (elapsed <= timeout) continue;
            return false;
        }
        return true;
    }

    public static Response sendEmail(String dest, String subject, String message) throws CredentialsNotFoundException, WorkflowManagerException {
        JSONObject json = new JSONObject();
        json.append("dest", (Object)dest);
        json.append("subject", (Object)subject);
        json.append("message", (Object)message);
        try {
            return Hops.clientWrapper(json, "mail");
        }
        catch (HTTPSClientInitializationException e) {
            throw new WorkflowManagerException(e.getMessage());
        }
    }

    public static Response startJobs(Integer ... jobIds) throws CredentialsNotFoundException, WorkflowManagerException {
        JSONObject json = new JSONObject();
        json.put("jobIds", (Object)jobIds);
        try {
            return Hops.clientWrapper(json, "mail");
        }
        catch (HTTPSClientInitializationException e) {
            throw new WorkflowManagerException(e.getMessage());
        }
    }
}

