/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.dela;

import com.twitter.bijection.Injection;
import com.twitter.bijection.avro.GenericAvroCodecs;
import io.hops.util.Hops;
import io.hops.util.HopsProcess;
import io.hops.util.HopsProcessType;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class DelaProducer
extends HopsProcess {
    private static final Logger LOGGER = Logger.getLogger(DelaProducer.class.getName());
    private final KafkaProducer<String, byte[]> producer;
    private final Injection<GenericRecord, byte[]> recordInjection;

    public DelaProducer(String topic, Schema schema, long lingerDelay) {
        super(HopsProcessType.PRODUCER, topic, schema);
        Properties props = Hops.getKafkaProperties().defaultProps();
        props.put("client.id", "DelaProducer");
        props.put("linger.ms", (Object)lingerDelay);
        this.producer = new KafkaProducer(props);
        this.recordInjection = GenericAvroCodecs.toBinary((Schema)schema);
    }

    public void produce(Map<String, Object> messageFields) {
        GenericData.Record avroRecord = new GenericData.Record(this.schema);
        for (Map.Entry<String, Object> message : messageFields.entrySet()) {
            avroRecord.put(message.getKey(), message.getValue());
        }
        this.produce((GenericRecord)avroRecord);
    }

    public void produce(GenericRecord avroRecord) {
        byte[] bytes = (byte[])this.recordInjection.apply((Object)avroRecord);
        this.produce(bytes);
    }

    public void produce(byte[] byteRecord) {
        ProducerRecord record = new ProducerRecord(this.topic, (Object)byteRecord);
        this.producer.send(record);
    }

    public byte[] prepareRecord(GenericRecord avroRecord) {
        byte[] bytes = (byte[])this.recordInjection.apply((Object)avroRecord);
        return bytes;
    }

    @Override
    public void close() {
        this.producer.close();
    }
}

