/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.spark;

import io.hops.util.Hops;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.streaming.api.java.JavaInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kafka010.ConsumerStrategies;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.KafkaUtils;
import org.apache.spark.streaming.kafka010.LocationStrategies;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.slf4j.Logger;
import scala.Function0;

public class SparkConsumer {
    private JavaStreamingContext jsc;
    private final Collection<String> topics;
    private final Map<String, Object> kafkaParams;
    private SparkSession sparkSession;

    public SparkConsumer() {
        this.topics = Hops.getTopics();
        this.kafkaParams = Hops.getKafkaProperties().getSparkConsumerConfigMap();
    }

    public SparkConsumer(Collection<String> topics) {
        this.topics = topics;
        this.kafkaParams = Hops.getKafkaProperties().getSparkConsumerConfigMap();
    }

    public SparkConsumer(Properties userProps) {
        this.topics = Hops.getTopics();
        this.kafkaParams = Hops.getKafkaProperties().getSparkConsumerConfigMap(userProps);
    }

    public SparkConsumer(JavaStreamingContext jsc, Collection<String> topics) {
        this.jsc = jsc;
        this.topics = topics;
        this.kafkaParams = Hops.getKafkaProperties().getSparkConsumerConfigMap();
    }

    public SparkConsumer(JavaStreamingContext jsc, Collection<String> topics, Properties userProps) {
        this.jsc = jsc;
        this.topics = topics;
        this.kafkaParams = Hops.getKafkaProperties().getSparkConsumerConfigMap(userProps);
    }

    public SparkConsumer(JavaStreamingContext jsc, Collection<String> topics, Map<String, Object> kafkaParams) {
        this.jsc = jsc;
        this.topics = topics;
        this.kafkaParams = kafkaParams;
    }

    public <K, V> JavaInputDStream<ConsumerRecord<K, V>> createDirectStream() {
        JavaInputDStream directKafkaStream = KafkaUtils.createDirectStream((JavaStreamingContext)this.jsc, (LocationStrategy)LocationStrategies.PreferConsistent(), (ConsumerStrategy)ConsumerStrategies.Subscribe(this.topics, this.kafkaParams));
        return directKafkaStream;
    }

    public DataStreamReader getKafkaDataStreamReader() {
        return this.getKafkaDataStreamReader(null);
    }

    public DataStreamReader getKafkaDataStreamReader(Map<String, String> userOptions) {
        this.sparkSession = SparkSession.builder().appName(Hops.getJobName()).getOrCreate();
        return this.sparkSession.readStream().format("kafka").options(Hops.getKafkaProperties().getSparkStructuredStreamingKafkaProps(userOptions));
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public <K, V> JavaInputDStream<ConsumerRecord<K, V>> createDirectStream(LocationStrategy ls) {
        return KafkaUtils.createDirectStream((JavaStreamingContext)this.jsc, (LocationStrategy)ls, (ConsumerStrategy)ConsumerStrategies.Subscribe(this.topics, this.kafkaParams));
    }

    public <K, V> JavaRDD<ConsumerRecord<K, V>> createRDD(JavaSparkContext jsc, OffsetRange[] osr, LocationStrategy ls) {
        return KafkaUtils.createRDD((JavaSparkContext)jsc, this.kafkaParams, (OffsetRange[])osr, (LocationStrategy)ls);
    }

    public void initializeLogIfNecessary(boolean init) {
        KafkaUtils.initializeLogIfNecessary((boolean)init);
    }

    public boolean isTraceEnabled() {
        return KafkaUtils.isTraceEnabled();
    }

    public Logger log() {
        return KafkaUtils.log();
    }

    public String logName() {
        return KafkaUtils.logName();
    }

    public void logDebug(Function0<String> fun) {
        KafkaUtils.logDebug(fun);
    }

    public void logDebug(Function0<String> fun, Throwable thr) {
        KafkaUtils.logDebug(fun, (Throwable)thr);
    }

    public void logError(Function0<String> fun) {
        KafkaUtils.logError(fun);
    }

    public void logError(Function0<String> fun, Throwable thr) {
        KafkaUtils.logError(fun, (Throwable)thr);
    }

    public void logInfo(Function0<String> fun) {
        KafkaUtils.logInfo(fun);
    }

    public void logInfo(Function0<String> fun, Throwable thr) {
        KafkaUtils.logInfo(fun, (Throwable)thr);
    }

    public void logTrace(Function0<String> fun) {
        KafkaUtils.logTrace(fun);
    }

    public void logTrace(Function0<String> fun, Throwable thr) {
        KafkaUtils.logTrace(fun, (Throwable)thr);
    }

    public void logWarning(Function0<String> fun) {
        KafkaUtils.logWarning(fun);
    }

    public void logWarning(Function0<String> fun, Throwable thr) {
        KafkaUtils.logWarning(fun, (Throwable)thr);
    }
}

