/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.dtos.featuregroup.OnDemandFeaturegroupDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreJdbcConnectorDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreReadFeaturegroup
extends FeaturestoreOp {
    public FeaturestoreReadFeaturegroup(String name) {
        super(name);
    }

    public Dataset<Row> read() throws HiveNotEnabled, FeaturegroupDoesNotExistError, StorageConnectorDoesNotExistError, OnlineFeaturestorePasswordNotFound, FeaturestoreNotFound, OnlineFeaturestoreUserNotFound, JAXBException, OnlineFeaturestoreNotEnabled {
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        FeaturegroupDTO featuregroupDTO = FeaturestoreHelper.findFeaturegroup(featurestoreMetadata.getFeaturegroups(), this.name, this.version);
        this.getSpark().sparkContext().setJobGroup("Fetching Feature Group", "Getting Feature group: " + this.name + " from the featurestore:" + this.featurestore, true);
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            return this.readOnDemandFeaturegroup((OnDemandFeaturegroupDTO)featuregroupDTO, featurestoreMetadata);
        }
        return this.readCachedFeaturegroup();
    }

    public Dataset<Row> readOnDemandFeaturegroup(OnDemandFeaturegroupDTO onDemandFeaturegroupDTO, FeaturestoreMetadataDTO featurestoreMetadataDTO) throws HiveNotEnabled, StorageConnectorDoesNotExistError {
        FeaturestoreJdbcConnectorDTO jdbcConnector = (FeaturestoreJdbcConnectorDTO)FeaturestoreHelper.findStorageConnector(featurestoreMetadataDTO.getStorageConnectors(), onDemandFeaturegroupDTO.getJdbcConnectorName());
        String jdbcConnectionString = FeaturestoreHelper.getJDBCUrlFromConnector(jdbcConnector, this.jdbcArguments);
        FeaturestoreHelper.registerCustomJdbcDialects();
        return FeaturestoreHelper.getOnDemandFeaturegroup(this.getSpark(), onDemandFeaturegroupDTO.getQuery(), jdbcConnectionString);
    }

    public Dataset<Row> readCachedFeaturegroup() throws HiveNotEnabled, OnlineFeaturestorePasswordNotFound, FeaturestoreNotFound, OnlineFeaturestoreUserNotFound, JAXBException, OnlineFeaturestoreNotEnabled {
        return FeaturestoreHelper.getCachedFeaturegroup(this.getSpark(), this.name, this.featurestore, this.version, this.online);
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    public FeaturestoreReadFeaturegroup setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreReadFeaturegroup setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadFeaturegroup setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreReadFeaturegroup setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreReadFeaturegroup setJdbcArguments(Map<String, String> jdbcArguments) {
        this.jdbcArguments = jdbcArguments;
        return this;
    }

    public FeaturestoreReadFeaturegroup setOnline(Boolean online) {
        this.online = online;
        return this;
    }
}

