/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturegroupDisableOnlineError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import javax.xml.bind.JAXBException;

public class FeaturestoreDisableFeaturegroupOnline
extends FeaturestoreOp {
    public FeaturestoreDisableFeaturegroupOnline(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws JAXBException, FeaturestoreNotFound, JWTNotFoundException, FeaturegroupDoesNotExistError, FeaturegroupDisableOnlineError {
        this.featurestore = FeaturestoreHelper.featurestoreGetOrDefault(this.featurestore);
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        FeaturegroupDTO featuregroupDTO = FeaturestoreHelper.findFeaturegroup(featurestoreMetadata.getFeaturegroups(), this.name, this.version);
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new IllegalArgumentException("Cannot Disable Online Feature Serving on an on-demand feature group, this operation is only supported for cached feature groups");
        }
        FeaturestoreRestClient.disableFeaturegroupOnlineRest(featuregroupDTO, FeaturestoreHelper.getFeaturegroupDtoTypeStr(featurestoreMetadata.getSettings(), false));
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
    }

    public FeaturestoreDisableFeaturegroupOnline setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreDisableFeaturegroupOnline setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreDisableFeaturegroupOnline setVersion(int version) {
        this.version = version;
        return this;
    }
}

