/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.CannotInsertIntoOnDemandFeaturegroups;
import io.hops.util.exceptions.CannotReadPartitionsOfOnDemandFeaturegroups;
import io.hops.util.exceptions.CannotUpdateStatsOfOnDemandFeaturegroups;
import io.hops.util.exceptions.CannotWriteImageDataFrameException;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturegroupDeletionError;
import io.hops.util.exceptions.FeaturegroupDisableOnlineError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupEnableOnlineError;
import io.hops.util.exceptions.FeaturegroupUpdateStatsError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.FeaturestoresNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.InvalidPrimaryKeyForFeaturegroup;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.SparkDataTypeNotRecognizedError;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.exceptions.StorageConnectorNotFound;
import io.hops.util.exceptions.StorageConnectorTypeNotSupportedForFeatureImport;
import io.hops.util.exceptions.TrainingDatasetCreationError;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public abstract class FeaturestoreOp {
    protected String name;
    protected SparkSession spark = null;
    protected String featurestore = FeaturestoreHelper.featurestoreGetOrDefault(null);
    protected int version = 1;
    protected String featuregroup;
    protected List<String> features;
    protected Map<String, Integer> featuregroupsAndVersions;
    protected String joinKey;
    protected String corrMethod = FeaturestoreHelper.correlationMethodGetOrDefault(null);
    protected int numBins = FeaturestoreHelper.numBinsGetOrDefault(null);
    protected int numClusters = FeaturestoreHelper.numClustersGetOrDefault(null);
    protected String mode;
    protected Dataset<Row> dataframe;
    protected Boolean descriptiveStats = true;
    protected Boolean featureCorr = true;
    protected Boolean featureHistograms = true;
    protected Boolean clusterAnalysis = true;
    protected List<String> statColumns = null;
    protected List<String> jobs = new ArrayList<String>();
    protected String primaryKey;
    protected String description = "";
    protected String dataFormat = FeaturestoreHelper.dataFormatGetOrDefault(null);
    protected List<String> partitionBy = new ArrayList<String>();
    protected Boolean onDemand = false;
    protected String sink = null;
    protected String jdbcConnector = null;
    protected String sqlQuery = "";
    protected Map<String, String> jdbcArguments;
    protected Map<String, Map<String, String>> onDemandFeaturegroupsjdbcArguments;
    protected StatisticsDTO statisticsDTO;
    protected Boolean hudi = false;
    protected Map<String, String> hudiArgs = new HashMap<String, String>();
    protected String hudiBasePath = "";
    protected String storageConnector = null;
    protected String externalPath;
    protected Boolean online = false;
    protected Boolean offline = true;
    protected Map<String, String> onlineTypes;

    public FeaturestoreOp(String name) {
        this.name = name;
    }

    public FeaturestoreOp(List<String> features) {
        this.features = features;
    }

    public String getName() {
        return this.name;
    }

    public SparkSession getSpark() throws HiveNotEnabled {
        if (this.spark == null) {
            this.spark = Hops.findSpark();
            FeaturestoreHelper.verifyHiveEnabled(this.spark);
        }
        return this.spark;
    }

    public String getFeaturestore() {
        return this.featurestore;
    }

    public int getVersion() {
        return this.version;
    }

    public String getFeaturegroup() {
        return this.featuregroup;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public Map<String, Integer> getFeaturegroupsAndVersions() {
        return this.featuregroupsAndVersions;
    }

    public String getJoinKey() {
        return this.joinKey;
    }

    public String getCorrMethod() {
        return this.corrMethod;
    }

    public int getNumBins() {
        return this.numBins;
    }

    public int getNumClusters() {
        return this.numClusters;
    }

    public String getMode() {
        return this.mode;
    }

    public Dataset<Row> getDataframe() {
        return this.dataframe;
    }

    public Boolean getDescriptiveStats() {
        return this.descriptiveStats;
    }

    public Boolean getFeatureCorr() {
        return this.featureCorr;
    }

    public Boolean getFeatureHistograms() {
        return this.featureHistograms;
    }

    public Boolean getClusterAnalysis() {
        return this.clusterAnalysis;
    }

    public List<String> getStatColumns() {
        return this.statColumns;
    }

    public List<String> getJobs() {
        return this.jobs;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public List<String> getPartitionBy() {
        return this.partitionBy;
    }

    public Boolean getOnDemand() {
        return this.onDemand;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public Map<String, String> getJdbcArguments() {
        return this.jdbcArguments;
    }

    public String getSink() {
        return this.sink;
    }

    public String getJdbcConnector() {
        return this.jdbcConnector;
    }

    public Map<String, Map<String, String>> getOnDemandFeaturegroupsjdbcArguments() {
        return this.onDemandFeaturegroupsjdbcArguments;
    }

    public StatisticsDTO getStatisticsDTO() {
        return this.statisticsDTO;
    }

    public Boolean getHudi() {
        return this.hudi;
    }

    public Map<String, String> getHudiArgs() {
        return this.hudiArgs;
    }

    public String getHudiBasePath() {
        return this.hudiBasePath;
    }

    public String getStorageConnector() {
        return this.storageConnector;
    }

    public String getExternalPath() {
        return this.externalPath;
    }

    public Boolean getOnline() {
        return this.online;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public Map<String, String> getOnlineTypes() {
        return this.onlineTypes;
    }

    public abstract Object read() throws FeaturestoreNotFound, JAXBException, TrainingDatasetFormatNotSupportedError, TrainingDatasetDoesNotExistError, IOException, FeaturestoresNotFound, JWTNotFoundException, HiveNotEnabled, StorageConnectorDoesNotExistError, FeaturegroupDoesNotExistError, CannotReadPartitionsOfOnDemandFeaturegroups, StorageConnectorNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreUserNotFound, OnlineFeaturestoreNotEnabled;

    public abstract void write() throws FeaturegroupDeletionError, DataframeIsEmpty, SparkDataTypeNotRecognizedError, JAXBException, FeaturegroupUpdateStatsError, FeaturestoreNotFound, TrainingDatasetDoesNotExistError, TrainingDatasetFormatNotSupportedError, IOException, InvalidPrimaryKeyForFeaturegroup, FeaturegroupCreationError, TrainingDatasetCreationError, CannotWriteImageDataFrameException, JWTNotFoundException, FeaturegroupDoesNotExistError, HiveNotEnabled, StorageConnectorDoesNotExistError, CannotInsertIntoOnDemandFeaturegroups, CannotUpdateStatsOfOnDemandFeaturegroups, StorageConnectorTypeNotSupportedForFeatureImport, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, FeaturegroupEnableOnlineError, FeaturegroupDisableOnlineError, OnlineFeaturestoreNotEnabled;
}

