/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.Constants;
import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.InvalidPrimaryKeyForFeaturegroup;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.feature.FeatureDTO;
import io.hops.util.featurestore.dtos.featuregroup.CachedFeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.dtos.featuregroup.OnDemandFeaturegroupDTO;
import io.hops.util.featurestore.dtos.jobs.FeaturestoreJobDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreStorageConnectorDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreStorageConnectorType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreSyncHiveTable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.parquet.Strings;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreCreateFeaturegroup
extends FeaturestoreOp {
    public FeaturestoreCreateFeaturegroup(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws JWTNotFoundException, FeaturegroupCreationError, FeaturestoreNotFound, JAXBException, InvalidPrimaryKeyForFeaturegroup, HiveNotEnabled, DataframeIsEmpty, StorageConnectorDoesNotExistError, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreNotEnabled, FeaturegroupDoesNotExistError {
        if (this.onDemand.booleanValue()) {
            this.writeOnDemandFeaturegroup();
        } else {
            this.writeCachedFeaturegroup();
        }
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
    }

    public void writeOnDemandFeaturegroup() throws StorageConnectorDoesNotExistError, FeaturestoreNotFound, FeaturegroupCreationError, JWTNotFoundException, JAXBException {
        if (Strings.isNullOrEmpty((String)this.sqlQuery)) {
            throw new IllegalArgumentException("SQL Query Cannot be Empty or Null for On-Demand Feature Groups");
        }
        if (Strings.isNullOrEmpty((String)this.jdbcConnector)) {
            throw new IllegalArgumentException("To create an on-demand feature group you must specify the name of a JDBC Storage Connector");
        }
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        FeaturestoreStorageConnectorDTO storageConnectorDTO = FeaturestoreHelper.findStorageConnector(featurestoreMetadata.getStorageConnectors(), this.jdbcConnector);
        if (storageConnectorDTO.getStorageConnectorType() != FeaturestoreStorageConnectorType.JDBC) {
            throw new IllegalArgumentException("OnDemand Feature groups can only be linked to JDBC Storage Connectors, the provided storage connector is of type: " + (Object)((Object)storageConnectorDTO.getStorageConnectorType()));
        }
        FeaturestoreRestClient.createFeaturegroupRest(this.groupInputParamsIntoDTO(storageConnectorDTO.getId()), FeaturestoreHelper.getFeaturegroupDtoTypeStr(featurestoreMetadata.getSettings(), this.onDemand));
    }

    public void writeCachedFeaturegroup() throws DataframeIsEmpty, JAXBException, InvalidPrimaryKeyForFeaturegroup, FeaturegroupCreationError, FeaturestoreNotFound, JWTNotFoundException, HiveNotEnabled, StorageConnectorDoesNotExistError, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreNotEnabled, FeaturegroupDoesNotExistError {
        if (this.dataframe == null) {
            throw new IllegalArgumentException("Dataframe to create featuregroup from cannot be null, specify dataframe with .setDataframe(df)");
        }
        this.primaryKey = FeaturestoreHelper.primaryKeyGetOrDefault(this.primaryKey, (Dataset<Row>)this.dataframe);
        FeaturestoreHelper.validatePrimaryKey((Dataset<Row>)this.dataframe, this.primaryKey);
        FeaturestoreHelper.validateMetadata(this.name, this.dataframe.dtypes(), this.description);
        StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.getSpark(), (Dataset<Row>)this.dataframe, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
        List<FeatureDTO> featuresSchema = FeaturestoreHelper.parseSparkFeaturesSchema(this.dataframe.schema(), this.primaryKey, this.partitionBy, this.online, this.onlineTypes);
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        if (!this.hudi.booleanValue()) {
            FeaturestoreRestClient.createFeaturegroupRest(this.groupInputParamsIntoDTO(featuresSchema, statisticsDTO), FeaturestoreHelper.getFeaturegroupDtoTypeStr(featurestoreMetadata.getSettings(), this.onDemand));
            if (this.offline.booleanValue()) {
                FeaturestoreHelper.insertIntoOfflineFeaturegroup((Dataset<Row>)this.dataframe, this.getSpark(), this.name, this.featurestore, this.version);
            }
            if (this.online.booleanValue()) {
                FeaturestoreHelper.insertIntoOnlineFeaturegroup((Dataset<Row>)this.dataframe, this.name, this.featurestore, this.version, "overwrite");
            }
        } else {
            Map<String, String> hudiWriteArgs = this.setupHudiArgs();
            FeaturestoreHelper.writeHudiDataset((Dataset<Row>)this.dataframe, this.getSpark(), this.name, this.featurestore, this.version, hudiWriteArgs, this.hudiBasePath, "overwrite");
            new FeaturestoreSyncHiveTable(this.name).setFeaturestore(this.featurestore).setDescription(this.description).setVersion(this.version).setStatisticsDTO(statisticsDTO).setJobs(this.jobs).write();
        }
    }

    private Map<String, String> setupHudiArgs() throws StorageConnectorDoesNotExistError {
        this.primaryKey = FeaturestoreHelper.primaryKeyGetOrDefault(this.primaryKey, (Dataset<Row>)this.dataframe);
        Map<String, String> hArgs = Constants.HUDI_DEFAULT_ARGS;
        hArgs.put("hoodie.datasource.write.operation", "bulk_insert");
        hArgs.put("hoodie.table.name", FeaturestoreHelper.getTableName(this.name, this.version));
        hArgs.put("hoodie.datasource.write.recordkey.field", this.primaryKey);
        if (!this.partitionBy.isEmpty()) {
            hArgs.put("hoodie.datasource.write.partitionpath.field", StringUtils.join((Iterable)this.partitionBy, (String)","));
            hArgs.put("hoodie.datasource.write.precombine.field", StringUtils.join((Iterable)this.partitionBy, (String)","));
            hArgs.put("hoodie.datasource.hive_sync.partition_fields", StringUtils.join((Iterable)this.partitionBy, (String)","));
        }
        hArgs = FeaturestoreHelper.setupHudiHiveArgs(hArgs, FeaturestoreHelper.getTableName(this.name, this.version));
        for (Map.Entry entry : this.hudiArgs.entrySet()) {
            hArgs.put((String)entry.getKey(), (String)entry.getValue());
        }
        return hArgs;
    }

    private FeaturegroupDTO groupInputParamsIntoDTO(Integer jdbcConnectorId) {
        OnDemandFeaturegroupDTO onDemandFeaturegroupDTO = new OnDemandFeaturegroupDTO();
        onDemandFeaturegroupDTO.setFeaturestoreName(this.featurestore);
        onDemandFeaturegroupDTO.setName(this.name);
        onDemandFeaturegroupDTO.setVersion(this.version);
        onDemandFeaturegroupDTO.setDescription(this.description);
        onDemandFeaturegroupDTO.setQuery(this.sqlQuery);
        onDemandFeaturegroupDTO.setJdbcConnectorId(jdbcConnectorId);
        onDemandFeaturegroupDTO.setFeaturegroupType(FeaturegroupType.ON_DEMAND_FEATURE_GROUP);
        return onDemandFeaturegroupDTO;
    }

    private FeaturegroupDTO groupInputParamsIntoDTO(List<FeatureDTO> features, StatisticsDTO statisticsDTO) {
        if (FeaturestoreHelper.jobNameGetOrDefault(null) != null) {
            this.jobs.add(FeaturestoreHelper.jobNameGetOrDefault(null));
        }
        List<FeaturestoreJobDTO> jobsDTOs = this.jobs.stream().map(jobName -> {
            FeaturestoreJobDTO featurestoreJobDTO = new FeaturestoreJobDTO();
            featurestoreJobDTO.setJobName((String)jobName);
            return featurestoreJobDTO;
        }).collect(Collectors.toList());
        CachedFeaturegroupDTO cachedFeaturegroupDTO = new CachedFeaturegroupDTO();
        cachedFeaturegroupDTO.setFeaturestoreName(this.featurestore);
        cachedFeaturegroupDTO.setName(this.name);
        cachedFeaturegroupDTO.setVersion(this.version);
        cachedFeaturegroupDTO.setDescription(this.description);
        cachedFeaturegroupDTO.setJobs(jobsDTOs);
        cachedFeaturegroupDTO.setFeatures(features);
        cachedFeaturegroupDTO.setClusterAnalysis(statisticsDTO.getClusterAnalysisDTO());
        cachedFeaturegroupDTO.setDescriptiveStatistics(statisticsDTO.getDescriptiveStatsDTO());
        cachedFeaturegroupDTO.setFeaturesHistogram(statisticsDTO.getFeatureDistributionsDTO());
        cachedFeaturegroupDTO.setFeatureCorrelationMatrix(statisticsDTO.getFeatureCorrelationMatrixDTO());
        cachedFeaturegroupDTO.setFeaturegroupType(FeaturegroupType.CACHED_FEATURE_GROUP);
        cachedFeaturegroupDTO.setOnlineFeaturegroupEnabled(this.online);
        return cachedFeaturegroupDTO;
    }

    public FeaturestoreCreateFeaturegroup setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setNumBins(int numBins) {
        this.numBins = numBins;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setNumClusters(int numClusters) {
        this.numClusters = numClusters;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setDescriptiveStats(Boolean descriptiveStats) {
        this.descriptiveStats = descriptiveStats;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setFeatureCorr(Boolean featureCorr) {
        this.featureCorr = featureCorr;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setFeatureHistograms(Boolean featureHistograms) {
        this.featureHistograms = featureHistograms;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setClusterAnalysis(Boolean clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setStatColumns(List<String> statColumns) {
        this.statColumns = statColumns;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setJobs(List<String> jobs) {
        this.jobs = jobs;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setDescription(String description) {
        this.description = description;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setPartitionBy(List<String> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setJdbcConnector(String jdbcConnector) {
        this.jdbcConnector = jdbcConnector;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setOnDemand(Boolean onDemand) {
        this.onDemand = onDemand;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setHudi(Boolean hudi) {
        this.hudi = hudi;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setHudiArgs(Map<String, String> hudiArgs) {
        this.hudiArgs = hudiArgs;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setHudiBasePath(String hudiBasePath) {
        this.hudiBasePath = hudiBasePath;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setOnline(Boolean online) {
        this.online = online;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    public FeaturestoreCreateFeaturegroup setOnlineTypes(Map<String, String> onlineTypes) {
        this.onlineTypes = onlineTypes;
        return this;
    }
}

