/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.InvalidPrimaryKeyForFeaturegroup;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.exceptions.StorageConnectorTypeNotSupportedForFeatureImport;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreS3ConnectorDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreStorageConnectorDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreCreateFeaturegroup;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.parquet.Strings;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreImportFeaturegroup
extends FeaturestoreOp {
    public FeaturestoreImportFeaturegroup(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws FeaturestoreNotFound, JAXBException, StorageConnectorDoesNotExistError, StorageConnectorTypeNotSupportedForFeatureImport, TrainingDatasetFormatNotSupportedError, HiveNotEnabled, TrainingDatasetDoesNotExistError, IOException, InvalidPrimaryKeyForFeaturegroup, DataframeIsEmpty, FeaturegroupCreationError, JWTNotFoundException, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreNotEnabled, FeaturegroupDoesNotExistError {
        FeaturestoreMetadataDTO featurestoreMetadataDTO = Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read();
        SparkSession sparkSession = FeaturestoreHelper.sparkGetOrDefault(this.spark);
        Dataset<Row> sparkDf = this.doReadExternalFeaturegroup(featurestoreMetadataDTO, sparkSession);
        new FeaturestoreCreateFeaturegroup(this.name).setFeaturestore(this.featurestore).setSpark(sparkSession).setVersion(this.version).setCorrMethod(this.corrMethod).setNumBins(this.numBins).setNumClusters(this.numClusters).setMode(this.mode).setDataframe(sparkDf).setDescriptiveStats(this.descriptiveStats).setFeatureCorr(this.featureCorr).setFeatureHistograms(this.featureHistograms).setClusterAnalysis(this.clusterAnalysis).setStatColumns(this.statColumns).setJobs(this.jobs).setDescription(this.description).setPartitionBy(this.partitionBy).write();
    }

    private Dataset<Row> doReadExternalFeaturegroup(FeaturestoreMetadataDTO featurestoreMetadataDTO, SparkSession sparkSession) throws StorageConnectorDoesNotExistError, StorageConnectorTypeNotSupportedForFeatureImport, IOException, TrainingDatasetDoesNotExistError, TrainingDatasetFormatNotSupportedError {
        FeaturestoreStorageConnectorDTO connectorDTO = FeaturestoreHelper.findStorageConnector(featurestoreMetadataDTO.getStorageConnectors(), this.storageConnector);
        if (!featurestoreMetadataDTO.getSettings().getFeatureImportConnectors().contains(connectorDTO.getStorageConnectorType().name())) {
            throw new StorageConnectorTypeNotSupportedForFeatureImport("The provided storage connector type for importing the feature data is no in the list of supported connector types for feature import. Provided connector type: " + connectorDTO.getStorageConnectorType().name() + ", supported connector types: " + Strings.join(featurestoreMetadataDTO.getSettings().getFeatureImportConnectors(), (String)","));
        }
        switch (connectorDTO.getStorageConnectorType()) {
            case S3: {
                return this.doReadFeaturegroupFromS3((FeaturestoreS3ConnectorDTO)connectorDTO, sparkSession);
            }
        }
        throw new StorageConnectorTypeNotSupportedForFeatureImport("The provided storage connector type for importing the feature data is no in the list of supported connector types for feature import. Provided connector type: " + connectorDTO.getStorageConnectorType().name() + ", supported connector types: " + Strings.join(featurestoreMetadataDTO.getSettings().getFeatureImportConnectors(), (String)","));
    }

    private Dataset<Row> doReadFeaturegroupFromS3(FeaturestoreS3ConnectorDTO s3ConnectorDTO, SparkSession sparkSession) throws TrainingDatasetFormatNotSupportedError, TrainingDatasetDoesNotExistError, IOException {
        String path = FeaturestoreHelper.getBucketPath(s3ConnectorDTO.getBucket(), this.externalPath);
        FeaturestoreHelper.setupS3CredentialsForSpark(s3ConnectorDTO.getAccessKey(), s3ConnectorDTO.getSecretKey(), sparkSession);
        return FeaturestoreHelper.getTrainingDataset(sparkSession, this.dataFormat, path, TrainingDatasetType.EXTERNAL_TRAINING_DATASET);
    }

    public FeaturestoreImportFeaturegroup setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreImportFeaturegroup setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreImportFeaturegroup setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreImportFeaturegroup setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreImportFeaturegroup setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
        return this;
    }

    public FeaturestoreImportFeaturegroup setNumBins(int numBins) {
        this.numBins = numBins;
        return this;
    }

    public FeaturestoreImportFeaturegroup setNumClusters(int numClusters) {
        this.numClusters = numClusters;
        return this;
    }

    public FeaturestoreImportFeaturegroup setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreImportFeaturegroup setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreImportFeaturegroup setDescriptiveStats(Boolean descriptiveStats) {
        this.descriptiveStats = descriptiveStats;
        return this;
    }

    public FeaturestoreImportFeaturegroup setFeatureCorr(Boolean featureCorr) {
        this.featureCorr = featureCorr;
        return this;
    }

    public FeaturestoreImportFeaturegroup setFeatureHistograms(Boolean featureHistograms) {
        this.featureHistograms = featureHistograms;
        return this;
    }

    public FeaturestoreImportFeaturegroup setClusterAnalysis(Boolean clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
        return this;
    }

    public FeaturestoreImportFeaturegroup setStatColumns(List<String> statColumns) {
        this.statColumns = statColumns;
        return this;
    }

    public FeaturestoreImportFeaturegroup setJobs(List<String> jobs) {
        this.jobs = jobs;
        return this;
    }

    public FeaturestoreImportFeaturegroup setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public FeaturestoreImportFeaturegroup setDescription(String description) {
        this.description = description;
        return this;
    }

    public FeaturestoreImportFeaturegroup setPartitionBy(List<String> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }

    public FeaturestoreImportFeaturegroup setStorageConnector(String storageConnector) {
        this.storageConnector = storageConnector;
        return this;
    }

    public FeaturestoreImportFeaturegroup setExternalPath(String externalPath) {
        this.externalPath = externalPath;
        return this;
    }

    public FeaturestoreImportFeaturegroup setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }
}

