/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.HopsworksErrorResponseDTO;
import io.hops.util.WorkflowManager;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HTTPSClientInitializationException;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.SchemaNotFoundException;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreGetMetadataForFeaturegroup;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeature;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeaturegroup;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeaturegroupLatestVersion;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeaturegroupPartitions;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeaturegroups;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeatures;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeaturesList;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadMetadata;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadOnlineConnector;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadProjectFeaturestore;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadProjectFeaturestores;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadStorageConnector;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadStorageConnectors;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadTrainingDataset;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadTrainingDatasetLatestVersion;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadTrainingDatasetPath;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadTrainingDatasets;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreSQLQuery;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreAddMetadataToFeaturegroup;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreCreateFeaturegroup;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreCreateTrainingDataset;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreDisableFeaturegroupOnline;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreEnableFeaturegroupOnline;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreImportFeaturegroup;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreInsertIntoFeaturegroup;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreInsertIntoTrainingDataset;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreRemoveMetadataFromFeaturegroup;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreSyncHiveTable;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreUpdateFeaturegroupStats;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreUpdateMetadataCache;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreUpdateTrainingDatasetStats;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.avro.Schema;
import org.apache.spark.sql.SparkSession;
import org.json.JSONObject;

public class Hops {
    private static final Logger LOG = Logger.getLogger(Hops.class.getName());
    private static Integer projectId;
    private static String projectName;
    private static String jobName;
    private static String appId;
    private static String jobType;
    private static List<String> brokerEndpointsList;
    private static String brokerEndpoints;
    private static String restEndpoint;
    private static boolean insecure;
    private static String keyStore;
    private static String trustStore;
    private static String keystorePwd;
    private static String truststorePwd;
    private static String elasticEndPoint;
    private static String domainCaTruststore;
    private static WorkflowManager workflowManager;

    private Hops() {
    }

    private static synchronized void setup() {
        Properties sysProps = System.getProperties();
        if (sysProps.containsKey("hopsworks.job.type") && sysProps.getProperty("hopsworks.job.type").equalsIgnoreCase("spark")) {
            String pwd;
            restEndpoint = sysProps.getProperty("hopsworks.restendpoint");
            insecure = Boolean.parseBoolean(sysProps.getProperty("hopsutil.insecure"));
            projectName = sysProps.getProperty("hopsworks.projectname");
            keyStore = "k_certificate";
            trustStore = "t_certificate";
            projectId = Integer.parseInt(sysProps.getProperty("hopsworks.projectid"));
            keystorePwd = pwd = Hops.getCertPw();
            truststorePwd = pwd;
            jobName = sysProps.getProperty("hopsworks.job.name");
            appId = sysProps.getProperty("hopsworks.job.appid");
            jobType = sysProps.getProperty("hopsworks.job.type");
            elasticEndPoint = sysProps.getProperty("hopsworks.elastic.endpoint");
            domainCaTruststore = sysProps.getProperty("hopsworks.domain.truststore");
            if (sysProps.containsKey("hopsworks.kafka.brokeraddress")) {
                Hops.parseBrokerEndpoints(sysProps.getProperty("hopsworks.kafka.brokeraddress"));
            }
            try {
                Hops.updateFeaturestoreMetadataCache().setFeaturestore(Hops.getProjectFeaturestore().read()).write();
            }
            catch (JAXBException e) {
                LOG.log(Level.SEVERE, "Could not fetch the feature store metadata for feature store: " + Hops.getProjectFeaturestore(), e);
            }
            catch (FeaturestoreNotFound e) {
                LOG.log(Level.FINEST, "Did not cache featurestore metadata as the project does not have the feature store service enabled");
            }
        }
    }

    public static Map<String, Schema> getSchemas(String[] topics) throws JWTNotFoundException, SchemaNotFoundException {
        if (topics == null) {
            throw new IllegalArgumentException("Topics were not provided.");
        }
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        for (String topic : topics) {
            Schema.Parser parser = new Schema.Parser();
            schemas.put(topic, parser.parse(Hops.getSchema(topic)));
        }
        return schemas;
    }

    public static String getSchema(String topic) throws JWTNotFoundException, SchemaNotFoundException {
        LOG.log(Level.FINE, "Getting schema for topic:{0}", new String[]{topic});
        JSONObject json = new JSONObject();
        json.append("topicName", (Object)topic);
        Response response = null;
        try {
            response = Hops.clientWrapper(json, "/project/" + projectId + "/kafka/" + topic + "/schema", "GET", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new SchemaNotFoundException(e.getMessage());
        }
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new SchemaNotFoundException("No schema found for topic:" + topic);
        }
        String responseEntity = (String)response.readEntity(String.class);
        LOG.log(Level.FINE, "responseEntity:" + responseEntity);
        json = new JSONObject(responseEntity);
        return json.getString("contents");
    }

    public static Properties getKafkaSSLProperties() {
        Properties properties = new Properties();
        properties.setProperty("security.protocol", "SSL");
        properties.setProperty("ssl.truststore.location", Hops.getTrustStore());
        properties.setProperty("ssl.truststore.password", Hops.getTruststorePwd());
        properties.setProperty("ssl.keystore.location", Hops.getKeyStore());
        properties.setProperty("ssl.keystore.password", Hops.getKeystorePwd());
        properties.setProperty("ssl.key.password", Hops.getKeystorePwd());
        properties.setProperty("ssl.endpoint.identification.algorithm", "");
        return properties;
    }

    protected static Response clientWrapper(String path, String httpMethod, Map<String, Object> queryParams) throws HTTPSClientInitializationException, JWTNotFoundException {
        return Hops.clientWrapper(null, path, httpMethod, queryParams);
    }

    protected static Response clientWrapper(JSONObject json, String path, String httpMethod, Map<String, Object> queryParams) throws HTTPSClientInitializationException, JWTNotFoundException {
        Client client;
        try {
            client = Hops.initClient();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new HTTPSClientInitializationException("Could not retrieve credentials from local working directory", e);
        }
        WebTarget webTarget = client.target(Hops.getRestEndpoint() + "/").path("hopsworks-api/api" + path);
        if (queryParams != null && !queryParams.isEmpty()) {
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                webTarget = webTarget.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        LOG.log(Level.FINE, "webTarget.getUri().getHost():" + webTarget.getUri().getHost());
        LOG.log(Level.FINE, "webTarget.getUri().getPort():" + webTarget.getUri().getPort());
        LOG.log(Level.FINE, "webTarget.getUri().getPath():" + webTarget.getUri().getPath());
        Invocation.Builder invocationBuilder = webTarget.request().header("Authorization", (Object)("Bearer " + Hops.getJwt().orElseThrow(IllegalArgumentException::new))).accept(new String[]{"application/json"});
        switch (httpMethod) {
            case "PUT": {
                if (json == null) {
                    return invocationBuilder.put(Entity.json((Object)""));
                }
                return invocationBuilder.put(Entity.entity((Object)json.toString(), (String)"application/json"));
            }
            case "POST": {
                if (json == null) {
                    return invocationBuilder.post(Entity.json((Object)""));
                }
                return invocationBuilder.post(Entity.entity((Object)json.toString(), (String)"application/json"));
            }
            case "GET": {
                return invocationBuilder.get();
            }
            case "DELETE": {
                return invocationBuilder.delete();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getCertPw() {
        try (FileInputStream fis = new FileInputStream("material_passwd");){
            int content;
            StringBuilder sb = new StringBuilder();
            while ((content = fis.read()) != -1) {
                sb.append((char)content);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Optional<String> getJwt() throws JWTNotFoundException {
        String jwt = null;
        try (FileChannel fc = FileChannel.open(Paths.get("token.jwt", new String[0]), StandardOpenOption.READ);){
            FileLock fileLock = fc.tryLock(0L, Long.MAX_VALUE, true);
            try {
                int numRetries = 5;
                for (int retries = 0; fileLock == null && retries < numRetries; retries = (int)((short)(retries + 1))) {
                    LOG.log(Level.FINEST, "Waiting for lock on jwt file at:token.jwt");
                    Thread.sleep(1000L);
                    fileLock = fc.tryLock(0L, Long.MAX_VALUE, true);
                }
                if (fileLock == null) {
                    throw new JWTNotFoundException("Could not read jwt token from local container, possibly another process has acquired the lock");
                }
                ByteBuffer buf = ByteBuffer.allocateDirect(512);
                fc.read(buf);
                buf.flip();
                jwt = StandardCharsets.UTF_8.decode(buf).toString();
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "JWT waiting thread was interrupted.", e);
            }
            finally {
                if (fileLock != null) {
                    fileLock.release();
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not read jwt token from local container.", e);
            throw new JWTNotFoundException("Could not read jwt token from local container." + e.getMessage(), e);
        }
        return Optional.ofNullable(jwt);
    }

    public static List<String> getBrokerEndpointsList() {
        return brokerEndpointsList;
    }

    public static String getBrokerEndpoints() {
        return brokerEndpoints;
    }

    public static Integer getProjectId() {
        return projectId;
    }

    public static String getRestEndpoint() {
        return restEndpoint;
    }

    public static String getKeyStore() {
        return keyStore;
    }

    public static String getTrustStore() {
        return trustStore;
    }

    public static String getKeystorePwd() {
        return keystorePwd;
    }

    public static String getTruststorePwd() {
        return truststorePwd;
    }

    public static String getProjectName() {
        return projectName;
    }

    public static String getElasticEndPoint() {
        return elasticEndPoint;
    }

    public static String getJobName() {
        return jobName;
    }

    public static String getAppId() {
        return appId;
    }

    public static String getJobType() {
        return jobType;
    }

    public static WorkflowManager getWorkflowManager() {
        return workflowManager;
    }

    private static void parseBrokerEndpoints(String addresses) {
        brokerEndpoints = addresses;
        brokerEndpointsList = Arrays.asList(addresses.split(","));
    }

    private static Client initClient() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream trustStoreIS = new FileInputStream(domainCaTruststore);){
            truststore.load(trustStoreIS, null);
        }
        return ClientBuilder.newBuilder().trustStore(truststore).hostnameVerifier((HostnameVerifier)InsecureHostnameVerifier.INSTANCE).build();
    }

    public static FeaturestoreReadProjectFeaturestore getProjectFeaturestore() {
        return new FeaturestoreReadProjectFeaturestore();
    }

    static HopsworksErrorResponseDTO parseHopsworksErrorResponse(Response response) {
        String jsonStrResponse = (String)response.readEntity(String.class);
        JSONObject jsonObjResponse = new JSONObject(jsonStrResponse);
        int errorCode = -1;
        String errorMsg = "";
        String userMsg = "";
        if (jsonObjResponse.has("errorCode")) {
            errorCode = jsonObjResponse.getInt("errorCode");
        }
        if (jsonObjResponse.has("errorMsg")) {
            errorMsg = jsonObjResponse.getString("errorMsg");
        }
        if (jsonObjResponse.has("usrMsg")) {
            userMsg = jsonObjResponse.getString("usrMsg");
        }
        return new HopsworksErrorResponseDTO(errorCode, errorMsg, userMsg);
    }

    private static FeaturestoreReadProjectFeaturestores getFeaturestoresForProject() {
        return new FeaturestoreReadProjectFeaturestores();
    }

    public static FeaturestoreInsertIntoFeaturegroup insertIntoFeaturegroup(String featuregroup) {
        return new FeaturestoreInsertIntoFeaturegroup(featuregroup);
    }

    public static FeaturestoreInsertIntoTrainingDataset insertIntoTrainingDataset(String trainingDataset) {
        return new FeaturestoreInsertIntoTrainingDataset(trainingDataset);
    }

    public static FeaturestoreReadFeaturegroup getFeaturegroup(String featuregroup) {
        return new FeaturestoreReadFeaturegroup(featuregroup);
    }

    public static FeaturestoreReadFeaturegroupPartitions getFeaturegroupPartitions(String featuregroup) {
        return new FeaturestoreReadFeaturegroupPartitions(featuregroup);
    }

    public static FeaturestoreReadTrainingDataset getTrainingDataset(String trainingDataset) {
        return new FeaturestoreReadTrainingDataset(trainingDataset);
    }

    public static FeaturestoreReadFeature getFeature(String feature) {
        return new FeaturestoreReadFeature(feature);
    }

    public static FeaturestoreUpdateFeaturegroupStats updateFeaturegroupStats(String featuregroup) throws FeaturegroupDoesNotExistError, JAXBException, FeaturestoreNotFound {
        return new FeaturestoreUpdateFeaturegroupStats(featuregroup);
    }

    public static FeaturestoreUpdateTrainingDatasetStats updateTrainingDatasetStats(String trainingDataset) {
        return new FeaturestoreUpdateTrainingDatasetStats(trainingDataset);
    }

    public static FeaturestoreReadFeatures getFeatures(List<String> features) {
        return new FeaturestoreReadFeatures(features);
    }

    public static FeaturestoreSQLQuery queryFeaturestore(String query) {
        return new FeaturestoreSQLQuery(query);
    }

    public static FeaturestoreReadProjectFeaturestores getProjectFeaturestores() {
        return Hops.getFeaturestoresForProject();
    }

    public static FeaturestoreReadFeaturegroups getFeaturegroups() {
        return new FeaturestoreReadFeaturegroups();
    }

    public static FeaturestoreReadFeaturesList getFeaturesList() {
        return new FeaturestoreReadFeaturesList();
    }

    public static FeaturestoreReadTrainingDatasets getTrainingDatasets() {
        return new FeaturestoreReadTrainingDatasets();
    }

    public static FeaturestoreReadStorageConnectors getStorageConnectors() {
        return new FeaturestoreReadStorageConnectors();
    }

    public static FeaturestoreReadStorageConnector getStorageConnector(String storageConnectorName) {
        return new FeaturestoreReadStorageConnector().setName(storageConnectorName);
    }

    public static FeaturestoreReadTrainingDatasetPath getTrainingDatasetPath(String trainingDataset) {
        return new FeaturestoreReadTrainingDatasetPath(trainingDataset);
    }

    public static FeaturestoreReadMetadata getFeaturestoreMetadata() {
        return new FeaturestoreReadMetadata();
    }

    public static FeaturestoreUpdateMetadataCache updateFeaturestoreMetadataCache() {
        return new FeaturestoreUpdateMetadataCache();
    }

    public static FeaturestoreCreateFeaturegroup createFeaturegroup(String featuregroup) {
        return new FeaturestoreCreateFeaturegroup(featuregroup);
    }

    public static FeaturestoreCreateTrainingDataset createTrainingDataset(String trainingDataset) {
        return new FeaturestoreCreateTrainingDataset(trainingDataset);
    }

    public static FeaturestoreReadFeaturegroupLatestVersion getLatestFeaturegroupVersion(String featuregroupName) {
        return new FeaturestoreReadFeaturegroupLatestVersion(featuregroupName);
    }

    public static FeaturestoreReadTrainingDatasetLatestVersion getLatestTrainingDatasetVersion(String trainingDatasetName) {
        return new FeaturestoreReadTrainingDatasetLatestVersion(trainingDatasetName);
    }

    public static FeaturestoreSyncHiveTable syncHiveTableWithFeaturestore(String hiveTableName) {
        return new FeaturestoreSyncHiveTable(hiveTableName);
    }

    public static FeaturestoreImportFeaturegroup importFeaturegroup(String featuregroupName) {
        return new FeaturestoreImportFeaturegroup(featuregroupName);
    }

    public static FeaturestoreReadOnlineConnector getOnlineFeaturestoreConnector() {
        return new FeaturestoreReadOnlineConnector();
    }

    public static FeaturestoreEnableFeaturegroupOnline enableFeaturegroupOnline(String featuregroupName) {
        return new FeaturestoreEnableFeaturegroupOnline(featuregroupName);
    }

    public static FeaturestoreDisableFeaturegroupOnline disableFeaturegroupOnline(String featuregroupName) {
        return new FeaturestoreDisableFeaturegroupOnline(featuregroupName);
    }

    public static SparkSession findSpark() {
        return SparkSession.builder().enableHiveSupport().getOrCreate();
    }

    public static FeaturestoreAddMetadataToFeaturegroup addMetadata(String featuregroupName) {
        return new FeaturestoreAddMetadataToFeaturegroup(featuregroupName);
    }

    public static FeaturestoreGetMetadataForFeaturegroup getMetadata(String featuregroupName) {
        return new FeaturestoreGetMetadataForFeaturegroup(featuregroupName);
    }

    public static FeaturestoreRemoveMetadataFromFeaturegroup removeMetadata(String featuregroupName) {
        return new FeaturestoreRemoveMetadataFromFeaturegroup(featuregroupName);
    }

    static {
        Hops.setup();
    }

    private static class InsecureHostnameVerifier
    implements HostnameVerifier {
        static InsecureHostnameVerifier INSTANCE = new InsecureHostnameVerifier();

        InsecureHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession ssls) {
            return insecure || string.equals(restEndpoint.split(":")[0]);
        }
    }
}

