/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.Constants;
import io.hops.util.Hops;
import io.hops.util.exceptions.HTTPSClientInitializationException;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.WorkflowManagerException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.json.JSONObject;

@Deprecated
public class WorkflowManager {
    private static final Logger LOG = Logger.getLogger(WorkflowManager.class.getName());

    public static boolean waitForJobs(String ... jobs) throws InterruptedException, WorkflowManagerException {
        return WorkflowManager.waitForJobs(5L, Constants.WAIT_JOBS_TIMEOUT_TIMEUNIT, 7L, Constants.WAIT_JOBS_TIMEOUT_TIMEUNIT, jobs);
    }

    public static boolean waitForJobs(long pollingInterval, TimeUnit pollingIntervalUnit, long timeout, TimeUnit timeoutUnit, String ... jobs) throws InterruptedException, WorkflowManagerException {
        boolean poll = true;
        long startTime = System.nanoTime();
        timeout = timeoutUnit.toNanos(timeout);
        pollingInterval = pollingIntervalUnit.toMillis(pollingInterval);
        while (poll) {
            for (String job : jobs) {
                String response;
                try {
                    response = (String)Hops.clientWrapper("/project/" + Hops.getProjectId() + "/jobs/" + job + "/executions?sort_by=submissiontime:desc&filter_by=state_neq:finished&filter_by=state_neq:failed&filter_by=state_neq:killed&filter_by=state_neq:framework_failure&filter_by=state_neq:app_master_start_failed&filter_by=state_neq:initialization_failed", "GET", null).readEntity(String.class);
                }
                catch (HTTPSClientInitializationException | JWTNotFoundException e) {
                    throw new WorkflowManagerException(e.getMessage());
                }
                LOG.log(Level.INFO, "Retrieved running jobs:{0}", response);
                JSONObject jobsJSON = new JSONObject(response);
                if (jobsJSON.getInt("count") != 0) continue;
                poll = false;
                break;
            }
            LOG.info("Waiting...");
            Thread.sleep(pollingInterval);
            long elapsed = System.nanoTime() - startTime;
            if (elapsed <= timeout) continue;
            return false;
        }
        return true;
    }

    public static Response sendEmail(String dest, String subject, String message) throws WorkflowManagerException {
        JSONObject json = new JSONObject();
        json.append("dest", (Object)dest);
        json.append("subject", (Object)subject);
        json.append("message", (Object)message);
        try {
            return Hops.clientWrapper(json, "mail", "POST", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new WorkflowManagerException(e.getMessage());
        }
    }

    public static void startJobs(String ... jobs) throws WorkflowManagerException {
        for (String job : jobs) {
            WorkflowManager.startJob(job);
        }
    }

    public static Response startJob(String job) throws WorkflowManagerException {
        try {
            return Hops.clientWrapper("/project/" + Hops.getProjectId() + "/jobs/" + job + "/executions", "POST", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new WorkflowManagerException(e.getMessage());
        }
    }
}

