/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupMetadataError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.Map;
import javax.xml.bind.JAXBException;

public class FeaturestoreAddMetadataToFeaturegroup
extends FeaturestoreOp {
    private Map<String, String> metadata;

    public FeaturestoreAddMetadataToFeaturegroup(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws JAXBException, FeaturestoreNotFound, FeaturegroupDoesNotExistError, FeaturegroupMetadataError {
        if (this.metadata == null || this.metadata.isEmpty()) {
            throw new IllegalArgumentException("No metadata is provided.");
        }
        for (Map.Entry<String, String> e : this.metadata.entrySet()) {
            FeaturestoreRestClient.addMetadata(this.getName(), this.getFeaturestore(), this.getVersion(), e.getKey(), e.getValue());
        }
    }

    public FeaturestoreAddMetadataToFeaturegroup setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreAddMetadataToFeaturegroup setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreAddMetadataToFeaturegroup setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}

