/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreS3ConnectorDTO;
import io.hops.util.featurestore.dtos.trainingdataset.ExternalTrainingDatasetDTO;
import io.hops.util.featurestore.dtos.trainingdataset.HopsfsTrainingDatasetDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreReadTrainingDataset
extends FeaturestoreOp {
    public FeaturestoreReadTrainingDataset(String name) {
        super(name);
    }

    public Dataset<Row> read() throws FeaturestoreNotFound, JAXBException, TrainingDatasetFormatNotSupportedError, TrainingDatasetDoesNotExistError, IOException, HiveNotEnabled, StorageConnectorDoesNotExistError {
        try {
            return this.doGetTrainingDataset(this.getSpark(), this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.version);
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            return this.doGetTrainingDataset(this.getSpark(), this.name, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read(), this.version);
        }
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    private Dataset<Row> doGetTrainingDataset(SparkSession sparkSession, String trainingDataset, FeaturestoreMetadataDTO featurestoreMetadata, int trainingDatasetVersion) throws TrainingDatasetDoesNotExistError, TrainingDatasetFormatNotSupportedError, IOException, StorageConnectorDoesNotExistError {
        sparkSession = FeaturestoreHelper.sparkGetOrDefault(sparkSession);
        List<TrainingDatasetDTO> trainingDatasetDTOList = featurestoreMetadata.getTrainingDatasets();
        TrainingDatasetDTO trainingDatasetDTO = FeaturestoreHelper.findTrainingDataset(trainingDatasetDTOList, trainingDataset, trainingDatasetVersion);
        if (trainingDatasetDTO.getTrainingDatasetType() == TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            return this.doGetHopsfsTrainingDataset(trainingDatasetDTO, sparkSession);
        }
        return this.doGetExternalTrainingDataset(trainingDatasetDTO, sparkSession, featurestoreMetadata);
    }

    private Dataset<Row> doGetHopsfsTrainingDataset(TrainingDatasetDTO trainingDatasetDTO, SparkSession sparkSession) throws TrainingDatasetFormatNotSupportedError, TrainingDatasetDoesNotExistError, IOException {
        HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO = (HopsfsTrainingDatasetDTO)trainingDatasetDTO;
        String path = FeaturestoreHelper.getHopsfsTrainingDatasetPath(hopsfsTrainingDatasetDTO);
        return FeaturestoreHelper.getTrainingDataset(sparkSession, trainingDatasetDTO.getDataFormat(), path, TrainingDatasetType.HOPSFS_TRAINING_DATASET);
    }

    private Dataset<Row> doGetExternalTrainingDataset(TrainingDatasetDTO trainingDatasetDTO, SparkSession sparkSession, FeaturestoreMetadataDTO featurestoreMetadataDTO) throws StorageConnectorDoesNotExistError, TrainingDatasetFormatNotSupportedError, TrainingDatasetDoesNotExistError, IOException {
        ExternalTrainingDatasetDTO externalTrainingDatasetDTO = (ExternalTrainingDatasetDTO)trainingDatasetDTO;
        FeaturestoreS3ConnectorDTO s3ConnectorDTO = (FeaturestoreS3ConnectorDTO)FeaturestoreHelper.findStorageConnector(featurestoreMetadataDTO.getStorageConnectors(), externalTrainingDatasetDTO.getS3ConnectorName());
        String path = FeaturestoreHelper.getExternalTrainingDatasetPath(externalTrainingDatasetDTO.getName(), externalTrainingDatasetDTO.getVersion(), s3ConnectorDTO.getBucket(), this.externalPath);
        FeaturestoreHelper.setupS3CredentialsForSpark(s3ConnectorDTO.getAccessKey(), s3ConnectorDTO.getSecretKey(), sparkSession);
        return FeaturestoreHelper.getTrainingDataset(sparkSession, trainingDatasetDTO.getDataFormat(), path, TrainingDatasetType.EXTERNAL_TRAINING_DATASET);
    }

    public FeaturestoreReadTrainingDataset setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreReadTrainingDataset setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadTrainingDataset setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreReadTrainingDataset setVersion(int version) {
        this.version = version;
        return this;
    }
}

