/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.CannotWriteImageDataFrameException;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.SparkDataTypeNotRecognizedError;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetCreationError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.feature.FeatureDTO;
import io.hops.util.featurestore.dtos.jobs.FeaturestoreJobDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreHopsfsConnectorDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreS3ConnectorDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreStorageConnectorDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreStorageConnectorType;
import io.hops.util.featurestore.dtos.trainingdataset.ExternalTrainingDatasetDTO;
import io.hops.util.featurestore.dtos.trainingdataset.HopsfsTrainingDatasetDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.json.JSONObject;

public class FeaturestoreCreateTrainingDataset
extends FeaturestoreOp {
    private static final Logger LOG = Logger.getLogger(FeaturestoreCreateTrainingDataset.class.getName());

    public FeaturestoreCreateTrainingDataset(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws DataframeIsEmpty, SparkDataTypeNotRecognizedError, JAXBException, FeaturestoreNotFound, TrainingDatasetCreationError, TrainingDatasetFormatNotSupportedError, CannotWriteImageDataFrameException, JWTNotFoundException, HiveNotEnabled, StorageConnectorDoesNotExistError, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreNotEnabled, FeaturegroupDoesNotExistError {
        if (this.dataframe == null) {
            throw new IllegalArgumentException("Dataframe to create featuregroup from cannot be null, specify dataframe with .setDataframe(df)");
        }
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        FeaturestoreHelper.validateMetadata(this.name, this.dataframe.dtypes(), this.description, featurestoreMetadata.getSettings());
        StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.getSpark(), (Dataset<Row>)this.dataframe, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
        List<FeatureDTO> featuresSchema = FeaturestoreHelper.parseSparkFeaturesSchema(this.dataframe.schema(), null, null, false, null);
        FeaturestoreStorageConnectorDTO storageConnectorDTO = this.storageConnector != null && !this.storageConnector.isEmpty() ? FeaturestoreHelper.findStorageConnector(featurestoreMetadata.getStorageConnectors(), this.storageConnector) : FeaturestoreHelper.findStorageConnector(featurestoreMetadata.getStorageConnectors(), FeaturestoreHelper.getProjectTrainingDatasetsSink());
        if (storageConnectorDTO.getStorageConnectorType() == FeaturestoreStorageConnectorType.S3) {
            this.doCreateExternalTrainingDataset(featurestoreMetadata, statisticsDTO, featuresSchema, (FeaturestoreS3ConnectorDTO)storageConnectorDTO);
        } else {
            this.doCreateHopsfsTrainingDataset(featurestoreMetadata, statisticsDTO, featuresSchema, (FeaturestoreHopsfsConnectorDTO)storageConnectorDTO);
        }
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
    }

    private HopsfsTrainingDatasetDTO groupInputParamsIntoHopsfsDTO(StatisticsDTO statisticsDTO, List<FeatureDTO> features, Integer hopsfsStorageConnectorId) {
        if (FeaturestoreHelper.jobNameGetOrDefault(null) != null) {
            this.jobs.add(FeaturestoreHelper.jobNameGetOrDefault(null));
        }
        List<FeaturestoreJobDTO> jobsDTOs = this.jobs.stream().map(jobName -> {
            FeaturestoreJobDTO featurestoreJobDTO = new FeaturestoreJobDTO();
            featurestoreJobDTO.setJobName((String)jobName);
            return featurestoreJobDTO;
        }).collect(Collectors.toList());
        HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO = new HopsfsTrainingDatasetDTO();
        hopsfsTrainingDatasetDTO.setFeaturestoreName(this.featurestore);
        hopsfsTrainingDatasetDTO.setName(this.name);
        hopsfsTrainingDatasetDTO.setVersion(this.version);
        hopsfsTrainingDatasetDTO.setDescription(this.description);
        hopsfsTrainingDatasetDTO.setJobs(jobsDTOs);
        hopsfsTrainingDatasetDTO.setDataFormat(this.dataFormat);
        hopsfsTrainingDatasetDTO.setFeatures(features);
        hopsfsTrainingDatasetDTO.setDescriptiveStatistics(statisticsDTO.getDescriptiveStatsDTO());
        hopsfsTrainingDatasetDTO.setFeatureCorrelationMatrix(statisticsDTO.getFeatureCorrelationMatrixDTO());
        hopsfsTrainingDatasetDTO.setFeaturesHistogram(statisticsDTO.getFeatureDistributionsDTO());
        hopsfsTrainingDatasetDTO.setClusterAnalysis(statisticsDTO.getClusterAnalysisDTO());
        hopsfsTrainingDatasetDTO.setHopsfsConnectorId(hopsfsStorageConnectorId);
        hopsfsTrainingDatasetDTO.setTrainingDatasetType(TrainingDatasetType.HOPSFS_TRAINING_DATASET);
        return hopsfsTrainingDatasetDTO;
    }

    private ExternalTrainingDatasetDTO groupInputParamsIntoExternalDTO(StatisticsDTO statisticsDTO, List<FeatureDTO> features, Integer s3ConnectorId) {
        if (FeaturestoreHelper.jobNameGetOrDefault(null) != null) {
            this.jobs.add(FeaturestoreHelper.jobNameGetOrDefault(null));
        }
        List<FeaturestoreJobDTO> jobsDTOs = this.jobs.stream().map(jobName -> {
            FeaturestoreJobDTO featurestoreJobDTO = new FeaturestoreJobDTO();
            featurestoreJobDTO.setJobName((String)jobName);
            return featurestoreJobDTO;
        }).collect(Collectors.toList());
        ExternalTrainingDatasetDTO externalTrainingDatasetDTO = new ExternalTrainingDatasetDTO();
        externalTrainingDatasetDTO.setFeaturestoreName(this.featurestore);
        externalTrainingDatasetDTO.setName(this.name);
        externalTrainingDatasetDTO.setVersion(this.version);
        externalTrainingDatasetDTO.setDescription(this.description);
        externalTrainingDatasetDTO.setJobs(jobsDTOs);
        externalTrainingDatasetDTO.setDataFormat(this.dataFormat);
        externalTrainingDatasetDTO.setFeatures(features);
        externalTrainingDatasetDTO.setDescriptiveStatistics(statisticsDTO.getDescriptiveStatsDTO());
        externalTrainingDatasetDTO.setFeatureCorrelationMatrix(statisticsDTO.getFeatureCorrelationMatrixDTO());
        externalTrainingDatasetDTO.setFeaturesHistogram(statisticsDTO.getFeatureDistributionsDTO());
        externalTrainingDatasetDTO.setClusterAnalysis(statisticsDTO.getClusterAnalysisDTO());
        externalTrainingDatasetDTO.setS3ConnectorId(s3ConnectorId);
        externalTrainingDatasetDTO.setTrainingDatasetType(TrainingDatasetType.EXTERNAL_TRAINING_DATASET);
        return externalTrainingDatasetDTO;
    }

    private void doCreateHopsfsTrainingDataset(FeaturestoreMetadataDTO featurestoreMetadataDTO, StatisticsDTO statisticsDTO, List<FeatureDTO> featuresSchema, FeaturestoreHopsfsConnectorDTO featurestoreHopsfsConnectorDTO) throws JAXBException, FeaturestoreNotFound, TrainingDatasetCreationError, JWTNotFoundException, HiveNotEnabled, TrainingDatasetFormatNotSupportedError, CannotWriteImageDataFrameException {
        Response response = FeaturestoreRestClient.createTrainingDatasetRest(this.groupInputParamsIntoHopsfsDTO(statisticsDTO, featuresSchema, featurestoreHopsfsConnectorDTO.getId()), featurestoreMetadataDTO.getSettings().getHopsfsTrainingDatasetDtoType());
        String jsonStrResponse = (String)response.readEntity(String.class);
        JSONObject jsonObjResponse = new JSONObject(jsonStrResponse);
        TrainingDatasetDTO trainingDatasetDTO = FeaturestoreHelper.parseTrainingDatasetJson(jsonObjResponse);
        HopsfsTrainingDatasetDTO hopsfsTrainingDatasetDTO = (HopsfsTrainingDatasetDTO)trainingDatasetDTO;
        String hdfsPath = hopsfsTrainingDatasetDTO.getHdfsStorePath() + "/" + this.name;
        FeaturestoreHelper.writeTrainingDataset(this.getSpark(), (Dataset<Row>)this.dataframe, hdfsPath, this.dataFormat, "overwrite");
        if (this.dataFormat.equals("tfrecords")) {
            try {
                JSONObject tfRecordSchemaJson = FeaturestoreHelper.getDataframeTfRecordSchemaJson((Dataset<Row>)this.dataframe);
                FeaturestoreHelper.writeTfRecordSchemaJson(hopsfsTrainingDatasetDTO.getHdfsStorePath() + "/" + "tf_record_schema.txt", tfRecordSchemaJson.toString());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Could not save tf record schema json to HDFS for training dataset: " + this.name, e);
            }
        }
    }

    private void doCreateExternalTrainingDataset(FeaturestoreMetadataDTO featurestoreMetadataDTO, StatisticsDTO statisticsDTO, List<FeatureDTO> featuresSchema, FeaturestoreS3ConnectorDTO s3ConnectorDTO) throws FeaturestoreNotFound, JWTNotFoundException, TrainingDatasetCreationError, JAXBException, HiveNotEnabled, TrainingDatasetFormatNotSupportedError, CannotWriteImageDataFrameException {
        String path = FeaturestoreHelper.getExternalTrainingDatasetPath(this.name, this.version, s3ConnectorDTO.getBucket(), this.externalPath);
        FeaturestoreHelper.setupS3CredentialsForSpark(s3ConnectorDTO.getAccessKey(), s3ConnectorDTO.getSecretKey(), this.getSpark());
        FeaturestoreRestClient.createTrainingDatasetRest(this.groupInputParamsIntoExternalDTO(statisticsDTO, featuresSchema, s3ConnectorDTO.getId()), featurestoreMetadataDTO.getSettings().getExternalTrainingDatasetDtoType());
        FeaturestoreHelper.writeTrainingDataset(this.getSpark(), (Dataset<Row>)this.dataframe, path, this.dataFormat, "overwrite");
    }

    public FeaturestoreCreateTrainingDataset setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setNumBins(int numBins) {
        this.numBins = numBins;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setNumClusters(int numClusters) {
        this.numClusters = numClusters;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDescriptiveStats(Boolean descriptiveStats) {
        this.descriptiveStats = descriptiveStats;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setFeatureCorr(Boolean featureCorr) {
        this.featureCorr = featureCorr;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setFeatureHistograms(Boolean featureHistograms) {
        this.featureHistograms = featureHistograms;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setClusterAnalysis(Boolean clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setStatColumns(List<String> statColumns) {
        this.statColumns = statColumns;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setJobs(List<String> jobs) {
        this.jobs = jobs;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDescription(String description) {
        this.description = description;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setSink(String storageConnector) {
        this.storageConnector = storageConnector;
        return this;
    }

    public FeaturestoreCreateTrainingDataset setPath(String path) {
        this.externalPath = path;
        return this;
    }
}

