/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupEnableOnlineError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.feature.FeatureDTO;
import io.hops.util.featurestore.dtos.featuregroup.CachedFeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadFeaturegroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreEnableFeaturegroupOnline
extends FeaturestoreOp {
    public FeaturestoreEnableFeaturegroupOnline(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws JAXBException, FeaturestoreNotFound, JWTNotFoundException, FeaturegroupDoesNotExistError, FeaturegroupEnableOnlineError, HiveNotEnabled, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, StorageConnectorDoesNotExistError, OnlineFeaturestoreNotEnabled {
        this.featurestore = FeaturestoreHelper.featurestoreGetOrDefault(this.featurestore);
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        FeaturegroupDTO featuregroupDTO = FeaturestoreHelper.findFeaturegroup(featurestoreMetadata.getFeaturegroups(), this.name, this.version);
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new IllegalArgumentException("Cannot Enable Online Feature Serving on an on-demand feature group, this operation is only supported for cached feature groups");
        }
        featuregroupDTO = this.setupMySQLDataTypes((CachedFeaturegroupDTO)featuregroupDTO, this.featurestore, this.getSpark());
        FeaturestoreRestClient.enableFeaturegroupOnlineRest(featuregroupDTO, FeaturestoreHelper.getFeaturegroupDtoTypeStr(featurestoreMetadata.getSettings(), false));
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
    }

    private CachedFeaturegroupDTO setupMySQLDataTypes(CachedFeaturegroupDTO cachedFeaturegroupDTO, String featurestore, SparkSession sparkSession) throws JAXBException, FeaturestoreNotFound, OnlineFeaturestorePasswordNotFound, StorageConnectorDoesNotExistError, OnlineFeaturestoreUserNotFound, FeaturegroupDoesNotExistError, HiveNotEnabled, OnlineFeaturestoreNotEnabled {
        Dataset<Row> sparkDf = new FeaturestoreReadFeaturegroup(cachedFeaturegroupDTO.getName()).setVersion(cachedFeaturegroupDTO.getVersion()).setFeaturestore(featurestore).setSpark(sparkSession).read();
        ArrayList<String> primaryKey = new ArrayList<String>();
        for (FeatureDTO feature : cachedFeaturegroupDTO.getFeatures()) {
            if (!feature.getPrimary().booleanValue()) continue;
            primaryKey.add(feature.getName());
        }
        List<FeatureDTO> featuresSchema = FeaturestoreHelper.parseSparkFeaturesSchema(sparkDf.schema(), primaryKey, new ArrayList<String>(), true, this.onlineTypes);
        cachedFeaturegroupDTO.setFeatures(featuresSchema);
        return cachedFeaturegroupDTO;
    }

    public FeaturestoreEnableFeaturegroupOnline setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreEnableFeaturegroupOnline setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreEnableFeaturegroupOnline setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreEnableFeaturegroupOnline setOnlineTypes(Map<String, String> onlineTypes) {
        this.onlineTypes = onlineTypes;
        return this;
    }

    public FeaturestoreEnableFeaturegroupOnline setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }
}

