/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.featurestore.dtos.featuregroup.CachedFeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;

public class FeaturestoreReadFeaturesList
extends FeaturestoreOp {
    public FeaturestoreReadFeaturesList() {
        super("");
    }

    @Override
    public List<String> read() throws FeaturestoreNotFound, JAXBException {
        List featureNamesLists = Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read().getFeaturegroups().stream().filter(fg -> this.filterOnline((FeaturegroupDTO)fg)).map(fg -> fg.getFeatures().stream().map(f -> f.getName()).collect(Collectors.toList())).collect(Collectors.toList());
        ArrayList<String> featureNames = new ArrayList<String>();
        featureNamesLists.stream().forEach(flist -> featureNames.addAll((Collection<String>)flist));
        return featureNames;
    }

    private Boolean filterOnline(FeaturegroupDTO featuregroupDTO) {
        if (this.online == null || !this.online.booleanValue()) {
            return true;
        }
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            return false;
        }
        CachedFeaturegroupDTO cachedFeaturegroupDTO = (CachedFeaturegroupDTO)featuregroupDTO;
        return cachedFeaturegroupDTO.getOnlineFeaturegroupEnabled();
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    public FeaturestoreReadFeaturesList setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadFeaturesList setOnline(Boolean online) {
        this.online = online;
        return this;
    }
}

