/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.dtos.jobs.FeaturestoreJobDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;

public class FeaturestoreSyncHiveTable
extends FeaturestoreOp {
    public FeaturestoreSyncHiveTable(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws JAXBException, FeaturestoreNotFound, FeaturegroupCreationError, JWTNotFoundException {
        this.featurestore = FeaturestoreHelper.featurestoreGetOrDefault(this.featurestore);
        if (this.onDemand.booleanValue()) {
            throw new IllegalArgumentException("Cannot Synchronize a Hive Table as an on-demand feature group, only as a cached feature group");
        }
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        FeaturestoreRestClient.syncHiveTableWithFeaturestoreRest(this.groupInputParamsIntoDTO(), FeaturestoreHelper.getFeaturegroupDtoTypeStr(featurestoreMetadata.getSettings(), false));
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
    }

    private FeaturegroupDTO groupInputParamsIntoDTO() {
        if (FeaturestoreHelper.jobNameGetOrDefault(null) != null) {
            this.jobs.add(FeaturestoreHelper.jobNameGetOrDefault(null));
        }
        List<FeaturestoreJobDTO> jobsDTOs = this.jobs.stream().map(jobName -> {
            FeaturestoreJobDTO featurestoreJobDTO = new FeaturestoreJobDTO();
            featurestoreJobDTO.setJobName((String)jobName);
            return featurestoreJobDTO;
        }).collect(Collectors.toList());
        FeaturegroupDTO featuregroupDTO = new FeaturegroupDTO();
        featuregroupDTO.setFeaturestoreName(this.featurestore);
        featuregroupDTO.setName(this.name);
        featuregroupDTO.setVersion(this.version);
        featuregroupDTO.setDescription(this.description);
        featuregroupDTO.setJobs(jobsDTOs);
        if (this.statisticsDTO != null) {
            featuregroupDTO.setClusterAnalysis(this.statisticsDTO.getClusterAnalysisDTO());
            featuregroupDTO.setDescriptiveStatistics(this.statisticsDTO.getDescriptiveStatsDTO());
            featuregroupDTO.setFeaturesHistogram(this.statisticsDTO.getFeatureDistributionsDTO());
            featuregroupDTO.setFeatureCorrelationMatrix(this.statisticsDTO.getFeatureCorrelationMatrixDTO());
        }
        featuregroupDTO.setFeaturegroupType(FeaturegroupType.CACHED_FEATURE_GROUP);
        return featuregroupDTO;
    }

    public FeaturestoreSyncHiveTable setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreSyncHiveTable setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreSyncHiveTable setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreSyncHiveTable setJobs(List<String> jobs) {
        this.jobs = jobs;
        return this;
    }

    public FeaturestoreSyncHiveTable setDescription(String description) {
        this.description = description;
        return this;
    }

    public FeaturestoreSyncHiveTable setStatisticsDTO(StatisticsDTO statisticsDTO) {
        this.statisticsDTO = statisticsDTO;
        return this;
    }
}

