/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.featuregroup.CachedFeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;

public class FeaturestoreReadFeaturegroups
extends FeaturestoreOp {
    public FeaturestoreReadFeaturegroups() {
        super("");
    }

    @Override
    public List<String> read() throws FeaturestoreNotFound, JAXBException {
        return Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read().getFeaturegroups().stream().filter(fg -> this.filterOnline((FeaturegroupDTO)fg)).map(fg -> FeaturestoreHelper.getTableName(fg.getName(), fg.getVersion())).collect(Collectors.toList());
    }

    private Boolean filterOnline(FeaturegroupDTO featuregroupDTO) {
        if (this.online == null || !this.online.booleanValue()) {
            return true;
        }
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            return false;
        }
        CachedFeaturegroupDTO cachedFeaturegroupDTO = (CachedFeaturegroupDTO)featuregroupDTO;
        return cachedFeaturegroupDTO.getOnlineFeaturegroupEnabled();
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    public FeaturestoreReadFeaturegroups setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadFeaturegroups setOnline(Boolean online) {
        this.online = online;
        return this;
    }
}

