/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.Constants;
import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.CannotInsertIntoOnDemandFeaturegroups;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturegroupDeletionError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupUpdateStatsError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.SparkDataTypeNotRecognizedError;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.featuregroup.CachedFeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupType;
import io.hops.util.featurestore.dtos.jobs.FeaturestoreJobDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreSyncHiveTable;
import io.hops.util.featurestore.ops.write_ops.FeaturestoreUpdateMetadataCache;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreInsertIntoFeaturegroup
extends FeaturestoreOp {
    public FeaturestoreInsertIntoFeaturegroup(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws DataframeIsEmpty, SparkDataTypeNotRecognizedError, JAXBException, FeaturegroupUpdateStatsError, FeaturestoreNotFound, JWTNotFoundException, FeaturegroupDeletionError, FeaturegroupDoesNotExistError, HiveNotEnabled, CannotInsertIntoOnDemandFeaturegroups, StorageConnectorDoesNotExistError, FeaturegroupCreationError, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreNotEnabled {
        Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
        FeaturestoreMetadataDTO featurestoreMetadata = FeaturestoreHelper.getFeaturestoreMetadataCache();
        FeaturegroupDTO featuregroupDTO = FeaturestoreHelper.findFeaturegroup(featurestoreMetadata.getFeaturegroups(), this.name, this.version);
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new CannotInsertIntoOnDemandFeaturegroups("The insert operation is only supported for cached feature groups");
        }
        this.corrMethod = featuregroupDTO.getCorrMethod();
        this.numBins = featuregroupDTO.getNumBins();
        this.numClusters = featuregroupDTO.getNumClusters();
        this.statColumns = featuregroupDTO.getStatisticColumns();
        this.descriptiveStats = featuregroupDTO.isDescStatsEnabled();
        this.clusterAnalysis = featuregroupDTO.isClusterAnalysisEnabled();
        this.featureCorr = featuregroupDTO.isFeatCorrEnabled();
        this.featureHistograms = featuregroupDTO.isFeatHistEnabled();
        FeaturestoreHelper.validateDataframe((Dataset<Row>)this.dataframe);
        this.getSpark().sparkContext().setJobGroup("Inserting dataframe into featuregroup", "Inserting into featuregroup:" + this.name + " in the featurestore:" + this.featurestore, true);
        FeaturestoreHelper.validateWriteMode(this.mode);
        if (this.mode.equalsIgnoreCase("overwrite")) {
            FeaturestoreRestClient.deleteTableContentsRest(this.groupInputParamsIntoDTO());
            new FeaturestoreUpdateMetadataCache().setFeaturestore(this.featurestore).write();
        }
        this.doInsertIntoFeaturegroup(Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
    }

    private FeaturegroupDTO groupInputParamsIntoDTO() {
        if (FeaturestoreHelper.jobNameGetOrDefault(null) != null) {
            this.jobs.add(FeaturestoreHelper.jobNameGetOrDefault(null));
        }
        List<FeaturestoreJobDTO> jobsDTOs = this.jobs.stream().map(jobName -> {
            FeaturestoreJobDTO featurestoreJobDTO = new FeaturestoreJobDTO();
            featurestoreJobDTO.setJobName((String)jobName);
            return featurestoreJobDTO;
        }).collect(Collectors.toList());
        FeaturegroupDTO featuregroupDTO = new FeaturegroupDTO();
        featuregroupDTO.setFeaturestoreName(this.featurestore);
        featuregroupDTO.setName(this.name);
        featuregroupDTO.setVersion(this.version);
        featuregroupDTO.setJobs(jobsDTOs);
        return featuregroupDTO;
    }

    private FeaturegroupDTO groupInputParamsIntoDTO(StatisticsDTO statisticsDTO) {
        if (FeaturestoreHelper.jobNameGetOrDefault(null) != null) {
            this.jobs.add(FeaturestoreHelper.jobNameGetOrDefault(null));
        }
        List<FeaturestoreJobDTO> jobsDTOs = this.jobs.stream().map(jobName -> {
            FeaturestoreJobDTO featurestoreJobDTO = new FeaturestoreJobDTO();
            featurestoreJobDTO.setJobName((String)jobName);
            return featurestoreJobDTO;
        }).collect(Collectors.toList());
        FeaturegroupDTO featuregroupDTO = new FeaturegroupDTO();
        featuregroupDTO.setFeaturestoreName(this.featurestore);
        featuregroupDTO.setName(this.name);
        featuregroupDTO.setVersion(this.version);
        featuregroupDTO.setDescriptiveStatistics(statisticsDTO.getDescriptiveStatsDTO());
        featuregroupDTO.setFeatureCorrelationMatrix(statisticsDTO.getFeatureCorrelationMatrixDTO());
        featuregroupDTO.setFeaturesHistogram(statisticsDTO.getFeatureDistributionsDTO());
        featuregroupDTO.setClusterAnalysis(statisticsDTO.getClusterAnalysisDTO());
        featuregroupDTO.setJobs(jobsDTOs);
        return featuregroupDTO;
    }

    private void doInsertIntoFeaturegroup(FeaturestoreMetadataDTO featurestoreMetadataDTO) throws HiveNotEnabled, FeaturestoreNotFound, DataframeIsEmpty, SparkDataTypeNotRecognizedError, FeaturegroupDoesNotExistError, FeaturegroupUpdateStatsError, JAXBException, JWTNotFoundException, StorageConnectorDoesNotExistError, FeaturegroupCreationError, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreNotEnabled {
        FeaturegroupDTO featuregroupDTO;
        try {
            featuregroupDTO = FeaturestoreHelper.findFeaturegroup(featurestoreMetadataDTO.getFeaturegroups(), this.name, this.version);
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            featurestoreMetadataDTO = Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read();
            featuregroupDTO = FeaturestoreHelper.findFeaturegroup(featurestoreMetadataDTO.getFeaturegroups(), this.name, this.version);
        }
        this.getSpark().sparkContext().setJobGroup("", "", true);
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.CACHED_FEATURE_GROUP && ((CachedFeaturegroupDTO)featuregroupDTO).getInputFormat().startsWith("org.apache.hudi")) {
            Map<String, String> hudiWriteArgs = this.setupHudiArgs();
            FeaturestoreHelper.writeHudiDataset((Dataset<Row>)this.dataframe, this.getSpark(), this.name, this.featurestore, this.version, hudiWriteArgs, ((CachedFeaturegroupDTO)featuregroupDTO).getHdfsStorePaths().get(0), this.mode);
            StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.getSpark(), (Dataset<Row>)this.dataframe, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
            new FeaturestoreSyncHiveTable(this.name).setFeaturestore(this.featurestore).setDescription(featuregroupDTO.getDescription()).setVersion(featuregroupDTO.getVersion()).setStatisticsDTO(statisticsDTO).setJobs(this.jobs).write();
        } else {
            if (this.offline.booleanValue()) {
                FeaturestoreHelper.insertIntoOfflineFeaturegroup((Dataset<Row>)this.dataframe, this.getSpark(), this.name, this.featurestore, this.version);
            }
            if (this.online.booleanValue()) {
                FeaturestoreHelper.insertIntoOnlineFeaturegroup((Dataset<Row>)this.dataframe, this.name, this.featurestore, this.version, this.mode);
            }
            StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.getSpark(), (Dataset<Row>)this.dataframe, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
            Boolean onDemand = featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP;
            FeaturestoreRestClient.updateFeaturegroupStatsRest(this.groupInputParamsIntoDTO(statisticsDTO), FeaturestoreHelper.getFeaturegroupDtoTypeStr(featurestoreMetadataDTO.getSettings(), onDemand));
        }
        this.getSpark().sparkContext().setJobGroup("", "", true);
    }

    private Map<String, String> setupHudiArgs() throws StorageConnectorDoesNotExistError {
        List<String> primaryKey = FeaturestoreHelper.primaryKeyGetOrDefault(this.getPrimaryKey(), (Dataset<Row>)this.dataframe);
        Map<String, String> hArgs = Constants.HUDI_DEFAULT_ARGS;
        hArgs.put("hoodie.datasource.write.operation", "upsert");
        hArgs.put("hoodie.table.name", FeaturestoreHelper.getTableName(this.name, this.version));
        hArgs.put("hoodie.datasource.write.recordkey.field", primaryKey.get(0));
        if (!this.partitionBy.isEmpty()) {
            hArgs.put("hoodie.datasource.write.partitionpath.field", StringUtils.join((Iterable)this.partitionBy, (String)","));
            hArgs.put("hoodie.datasource.write.precombine.field", StringUtils.join((Iterable)this.partitionBy, (String)","));
            hArgs.put("hoodie.datasource.hive_sync.partition_fields", StringUtils.join((Iterable)this.partitionBy, (String)","));
        }
        hArgs = FeaturestoreHelper.setupHudiHiveArgs(hArgs, FeaturestoreHelper.getTableName(this.name, this.version));
        for (Map.Entry entry : this.hudiArgs.entrySet()) {
            hArgs.put((String)entry.getKey(), (String)entry.getValue());
        }
        return hArgs;
    }

    public FeaturestoreInsertIntoFeaturegroup setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setHudi(Boolean hudi) {
        this.hudi = hudi;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setHudiArgs(Map<String, String> hudiArgs) {
        this.hudiArgs = hudiArgs;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setHudiBasePath(String hudiBasePath) {
        this.hudiBasePath = hudiBasePath;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setPartitionBy(List<String> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setPrimaryKey(List<String> primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setOnline(Boolean online) {
        this.online = online;
        return this;
    }

    public FeaturestoreInsertIntoFeaturegroup setOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }
}

