/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.Hops;
import io.hops.util.HopsworksErrorResponseDTO;
import io.hops.util.exceptions.FeaturegroupCreationError;
import io.hops.util.exceptions.FeaturegroupDeletionError;
import io.hops.util.exceptions.FeaturegroupDisableOnlineError;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupEnableOnlineError;
import io.hops.util.exceptions.FeaturegroupMetadataError;
import io.hops.util.exceptions.FeaturegroupUpdateStatsError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.FeaturestoresNotFound;
import io.hops.util.exceptions.HTTPSClientInitializationException;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.TrainingDatasetCreationError;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.featuregroup.FeaturegroupDTO;
import io.hops.util.featurestore.dtos.storageconnector.FeaturestoreJdbcConnectorDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.json.JSONArray;
import org.json.JSONObject;

public class FeaturestoreRestClient {
    private static final Logger LOG = Logger.getLogger(FeaturestoreRestClient.class.getName());

    private FeaturestoreRestClient() {
    }

    public static FeaturestoreMetadataDTO getFeaturestoreMetadataRest(String featurestore) throws FeaturestoreNotFound, JAXBException {
        Response response;
        LOG.log(Level.FINE, "Getting metadata for featurestore " + featurestore);
        try {
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestore + "/" + "metadata", "GET", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new FeaturestoreNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new FeaturestoreNotFound("Could not fetch metadata for featurestore:" + featurestore);
        }
        String responseEntity = (String)response.readEntity(String.class);
        JSONObject featurestoreMetadata = new JSONObject(responseEntity);
        return FeaturestoreHelper.parseFeaturestoreMetadataJson(featurestoreMetadata);
    }

    public static void deleteTableContentsRest(FeaturegroupDTO featuregroupDTO) throws JWTNotFoundException, FeaturegroupDeletionError, JAXBException, FeaturestoreNotFound, FeaturegroupDoesNotExistError {
        LOG.log(Level.FINE, "Deleting table contents of featuregroup " + featuregroupDTO.getName() + "version: " + featuregroupDTO.getVersion() + " in featurestore: " + featuregroupDTO.getFeaturestoreName());
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featuregroupDTO.getFeaturestoreName());
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featuregroupDTO.getFeaturestoreName(), featuregroupDTO.getName(), featuregroupDTO.getVersion());
            Response response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId + "/" + "clear", "POST", null);
            LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
            if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
                throw new FeaturegroupDeletionError("Could not clear the contents of featuregroup:" + featuregroupDTO.getName() + " , response code: " + response.getStatusInfo().getStatusCode());
            }
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupDeletionError(e.getMessage());
        }
    }

    public static void createFeaturegroupRest(FeaturegroupDTO featuregroupDTO, String featuregroupDTOType) throws JWTNotFoundException, JAXBException, FeaturegroupCreationError, FeaturestoreNotFound {
        Response response;
        LOG.log(Level.FINE, "Creating featuregroup " + featuregroupDTO.getName() + " in featurestore: " + featuregroupDTO.getFeaturestoreName());
        JSONObject json = FeaturestoreHelper.convertFeaturegroupDTOToJsonObject(featuregroupDTO);
        json.put("type", (Object)featuregroupDTOType);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featuregroupDTO.getFeaturestoreName());
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups", "POST", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupCreationError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.CREATED.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new FeaturegroupCreationError("Could not create featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
    }

    public static Response createTrainingDatasetRest(TrainingDatasetDTO trainingDatasetDTO) throws JWTNotFoundException, JAXBException, TrainingDatasetCreationError, FeaturestoreNotFound {
        Response response;
        LOG.log(Level.FINE, "Creating Training Dataset " + trainingDatasetDTO.getName() + " in featurestore: " + trainingDatasetDTO.getFeaturestoreName());
        JSONObject json = FeaturestoreHelper.convertTrainingDatasetDTOToJsonObject(trainingDatasetDTO);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(trainingDatasetDTO.getFeaturestoreName());
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "trainingdatasets", "POST", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new TrainingDatasetCreationError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.CREATED.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new TrainingDatasetCreationError("Could not create trainingDataset:" + trainingDatasetDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
        return response;
    }

    public static Response getFeaturestoresForProjectRest() throws JWTNotFoundException, FeaturestoresNotFound {
        Response response;
        LOG.log(Level.FINE, "Getting featurestores for current project");
        try {
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores", "GET", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturestoresNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new FeaturestoresNotFound("Could not fetch featurestores for the current project");
        }
        return response;
    }

    public static void updateFeaturegroupStatsRest(FeaturegroupDTO featuregroupDTO, String featuregroupDTOType) throws JWTNotFoundException, JAXBException, FeaturegroupUpdateStatsError, FeaturestoreNotFound, FeaturegroupDoesNotExistError {
        Response response;
        LOG.log(Level.FINE, "Updating featuregroup stats for: " + featuregroupDTO.getName() + " in featurestore: " + featuregroupDTO.getFeaturestoreName());
        JSONObject json = FeaturestoreHelper.convertFeaturegroupDTOToJsonObject(featuregroupDTO);
        json.put("type", (Object)featuregroupDTOType);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featuregroupDTO.getFeaturestoreName());
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featuregroupDTO.getFeaturestoreName(), featuregroupDTO.getName(), featuregroupDTO.getVersion());
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("updateStats", true);
            queryParams.put("updateStatsSettings", true);
            queryParams.put("updateJob", !featuregroupDTO.getJobs().isEmpty());
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId, "PUT", queryParams);
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupUpdateStatsError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            LOG.severe("Could not update statistics and the settings for featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
            throw new FeaturegroupUpdateStatsError("Could not update statistics and the settings for featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
    }

    public static Response updateTrainingDatasetStatsRest(TrainingDatasetDTO trainingDatasetDTO) throws JWTNotFoundException, JAXBException, FeaturegroupUpdateStatsError, TrainingDatasetDoesNotExistError, FeaturestoreNotFound {
        LOG.log(Level.FINE, "Updating training dataset stats for: " + trainingDatasetDTO.getName() + " in featurestore: " + trainingDatasetDTO.getFeaturestoreName());
        JSONObject json = FeaturestoreHelper.convertTrainingDatasetDTOToJsonObject(trainingDatasetDTO);
        Response response = null;
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(trainingDatasetDTO.getFeaturestoreName());
            int trainingDatasetId = FeaturestoreHelper.getTrainingDatasetId(trainingDatasetDTO.getFeaturestoreName(), trainingDatasetDTO.getName(), trainingDatasetDTO.getVersion());
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("updateStats", true);
            queryParams.put("updateJob", !trainingDatasetDTO.getJobs().isEmpty());
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "trainingdatasets" + "/" + trainingDatasetId, "PUT", queryParams);
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupUpdateStatsError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new FeaturegroupUpdateStatsError("Could not update statistics for trainingDataset:" + trainingDatasetDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
        return response;
    }

    public static void syncHiveTableWithFeaturestoreRest(FeaturegroupDTO featuregroupDTO, String featuregroupDTOType) throws JWTNotFoundException, JAXBException, FeaturegroupCreationError, FeaturestoreNotFound {
        Response response;
        LOG.log(Level.FINE, "Creating featuregroup " + featuregroupDTO.getName() + " in featurestore: " + featuregroupDTO.getFeaturestoreName());
        JSONObject json = FeaturestoreHelper.convertFeaturegroupDTOToJsonObject(featuregroupDTO);
        json.put("type", (Object)featuregroupDTOType);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featuregroupDTO.getFeaturestoreName());
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + "sync", "POST", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupCreationError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.CREATED.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            throw new FeaturegroupCreationError("Could not create featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
    }

    public static void enableFeaturegroupOnlineRest(FeaturegroupDTO featuregroupDTO, String featuregroupDTOType) throws JWTNotFoundException, JAXBException, FeaturestoreNotFound, FeaturegroupDoesNotExistError, FeaturegroupEnableOnlineError {
        Response response;
        LOG.log(Level.FINE, "Enabling online feature serving for feature group: " + featuregroupDTO.getName() + " in featurestore: " + featuregroupDTO.getFeaturestoreName());
        JSONObject json = FeaturestoreHelper.convertFeaturegroupDTOToJsonObject(featuregroupDTO);
        json.put("type", (Object)featuregroupDTOType);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featuregroupDTO.getFeaturestoreName());
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featuregroupDTO.getFeaturestoreName(), featuregroupDTO.getName(), featuregroupDTO.getVersion());
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("enableOnline", true);
            queryParams.put("disableOnline", false);
            queryParams.put("updateStats", false);
            queryParams.put("updateJob", !featuregroupDTO.getJobs().isEmpty());
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId, "PUT", queryParams);
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupEnableOnlineError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            LOG.severe("Could not enable online feature serving for featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
            throw new FeaturegroupEnableOnlineError("Could not enable online feature serving for featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
    }

    public static void disableFeaturegroupOnlineRest(FeaturegroupDTO featuregroupDTO, String featuregroupDTOType) throws JWTNotFoundException, JAXBException, FeaturestoreNotFound, FeaturegroupDoesNotExistError, FeaturegroupDisableOnlineError {
        Response response;
        LOG.log(Level.FINE, "Enabling online feature serving for feature group: " + featuregroupDTO.getName() + " in featurestore: " + featuregroupDTO.getFeaturestoreName());
        JSONObject json = FeaturestoreHelper.convertFeaturegroupDTOToJsonObject(featuregroupDTO);
        json.put("type", (Object)featuregroupDTOType);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featuregroupDTO.getFeaturestoreName());
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featuregroupDTO.getFeaturestoreName(), featuregroupDTO.getName(), featuregroupDTO.getVersion());
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("disableOnline", true);
            queryParams.put("enableOnline", false);
            queryParams.put("updateStats", false);
            queryParams.put("updateJob", !featuregroupDTO.getJobs().isEmpty());
            response = Hops.clientWrapper(json, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId, "PUT", queryParams);
        }
        catch (HTTPSClientInitializationException e) {
            throw new FeaturegroupDisableOnlineError(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            HopsworksErrorResponseDTO hopsworksErrorResponseDTO = Hops.parseHopsworksErrorResponse(response);
            LOG.severe("Could not disable online feature serving for featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
            throw new FeaturegroupDisableOnlineError("Could not disable online feature serving for featuregroup:" + featuregroupDTO.getName() + " , error code: " + hopsworksErrorResponseDTO.getErrorCode() + " error message: " + hopsworksErrorResponseDTO.getErrorMsg() + ", user message: " + hopsworksErrorResponseDTO.getUserMsg());
        }
    }

    public static FeaturestoreJdbcConnectorDTO getOnlineFeaturestoreJdbcConnectorRest(String featurestore) throws FeaturestoreNotFound, JAXBException {
        Response response;
        LOG.log(Level.FINE, "Getting JDBC connector for online feature store: " + featurestore);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "storageconnectors" + "/" + "onlinefeaturestore", "GET", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new FeaturestoreNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new FeaturestoreNotFound("Could not get JDBC Connector for online featurestore:" + featurestore);
        }
        String responseEntity = (String)response.readEntity(String.class);
        JSONObject onlineFeaturestoreConnector = new JSONObject(responseEntity);
        return FeaturestoreHelper.parseJdbcConnectorJson(onlineFeaturestoreConnector);
    }

    public static void addMetadata(String featuregroupName, String featurestore, Integer featuregroupVersion, String name, String value) throws FeaturestoreNotFound, JAXBException, FeaturegroupDoesNotExistError, FeaturegroupMetadataError {
        Response response;
        LOG.log(Level.FINE, "Adding metadata to featuregroup: " + featuregroupName);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(name, (Object)value);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featurestore, featuregroupName, featuregroupVersion);
            response = Hops.clientWrapper(jsonObject, "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId + "/" + "xattrs" + "/" + name, "PUT", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new FeaturestoreNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode() && response.getStatusInfo().getStatusCode() != Response.Status.CREATED.getStatusCode()) {
            throw new FeaturegroupMetadataError("Error while attaching metadata to featuregroup " + featuregroupName + ", Http Code: " + response.getStatus());
        }
    }

    public static Map<String, String> getMetadata(String featuregroupName, String featurestore, Integer featuregroupVersion, String name) throws FeaturestoreNotFound, JAXBException, FeaturegroupDoesNotExistError, FeaturegroupMetadataError {
        Response response;
        LOG.log(Level.FINE, "getting metadata for featuregroup: " + featuregroupName);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featurestore, featuregroupName, featuregroupVersion);
            String path = "/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId + "/" + "xattrs";
            if (name != null) {
                path = path + "/" + name;
            }
            response = Hops.clientWrapper(path, "GET", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new FeaturestoreNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.ACCEPTED.getStatusCode()) {
            throw new FeaturegroupMetadataError("Error while getting metadata for featuregroup " + featuregroupName + ", Http Code: " + response.getStatus());
        }
        String responseEntity = (String)response.readEntity(String.class);
        JSONObject metadata = new JSONObject(responseEntity);
        JSONArray items = metadata.getJSONArray("items");
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < items.length(); ++i) {
            JSONObject jsonObject = items.getJSONObject(i);
            result.put(jsonObject.getString("name"), jsonObject.getString("value"));
        }
        return result;
    }

    public static void removeMetadata(String featuregroupName, String featurestore, Integer featuregroupVersion, String name) throws FeaturestoreNotFound, JAXBException, FeaturegroupDoesNotExistError, FeaturegroupMetadataError {
        Response response;
        LOG.log(Level.FINE, "Removing metadata from featuregroup: " + featuregroupName);
        try {
            int featurestoreId = FeaturestoreHelper.getFeaturestoreId(featurestore);
            int featuregroupId = FeaturestoreHelper.getFeaturegroupId(featurestore, featuregroupName, featuregroupVersion);
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "featurestores" + "/" + featurestoreId + "/" + "featuregroups" + "/" + featuregroupId + "/" + "xattrs" + "/" + name, "DELETE", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new FeaturestoreNotFound(e.getMessage());
        }
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.NO_CONTENT.getStatusCode()) {
            throw new FeaturegroupMetadataError("Error while removing metadata from featuregroup " + featuregroupName + ", Http Code: " + response.getStatus());
        }
    }
}

