/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.read_ops;

import io.hops.util.Hops;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetType;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import java.util.List;
import javax.xml.bind.JAXBException;

public class FeaturestoreReadTrainingDatasetPath
extends FeaturestoreOp {
    public FeaturestoreReadTrainingDatasetPath(String name) {
        super(name);
    }

    @Override
    public String read() throws FeaturestoreNotFound, JAXBException, TrainingDatasetDoesNotExistError, StorageConnectorDoesNotExistError {
        try {
            return FeaturestoreReadTrainingDatasetPath.doGetTrainingDatasetPath(this.name, this.version, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
        }
        catch (Exception e) {
            Hops.updateFeaturestoreMetadataCache().setFeaturestore(this.featurestore).write();
            return FeaturestoreReadTrainingDatasetPath.doGetTrainingDatasetPath(this.name, this.version, Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read());
        }
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException("write() is not supported on a read operation");
    }

    public FeaturestoreReadTrainingDatasetPath setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreReadTrainingDatasetPath setVersion(int version) {
        this.version = version;
        return this;
    }

    private static String doGetTrainingDatasetPath(String trainingDataset, int trainingDatasetVersion, FeaturestoreMetadataDTO featurestoreMetadata) throws TrainingDatasetDoesNotExistError {
        List<TrainingDatasetDTO> trainingDatasetDTOList = featurestoreMetadata.getTrainingDatasets();
        TrainingDatasetDTO trainingDatasetDTO = FeaturestoreHelper.findTrainingDataset(trainingDatasetDTOList, trainingDataset, trainingDatasetVersion);
        if (trainingDatasetDTO.getTrainingDatasetType() == TrainingDatasetType.HOPSFS_TRAINING_DATASET) {
            return FeaturestoreHelper.getHopsfsTrainingDatasetPath(trainingDatasetDTO);
        }
        return FeaturestoreHelper.getExternalTrainingDatasetPath(trainingDatasetDTO);
    }
}

